import plotmath


def main(dirname, save):
    #
    # Define functions
    def f(x):
        return 4**x - 12 * 2**x + 32

    # List of functions and their labels.
    functions = [f]
    fontsize = 25
    fig, ax = plotmath.plot(
        functions=functions,
        fn_labels=False,
        xmin=-4,
        xmax=10,
        ymin=-10,
        ymax=40,
        ticks=True,
        xstep=1,
        ystep=1,
        grid=False,
        lw=2.5,
        alpha=None,
        domain=False,
        fontsize=fontsize,
        figsize=None,
    )

    ax.set_yticks([])

    ax.text(
        x=8,
        y=25,
        s="D",
        fontsize=fontsize,
        bbox=dict(boxstyle="round,pad=0.3", facecolor="white", edgecolor="black"),
    )

    # NOTE: Select an appropriate `dirname` to save the figure.
    # The directory `dirname` will be created automatically if it does not exist already.
    if save:
        fname = __file__.split("/")[-1].replace(".py", ".svg")
        plotmath.savefig(
            dirname=dirname, fname=fname
        )  # Lagrer figuren i `dirname`-directory

    if not save:

        plotmath.show()


if __name__ == "__main__":

    import pathlib

    # Get the directory where the script is located
    current_dir = str(pathlib.Path(__file__).resolve().parent)

    parts = current_dir.split("/")
    for i in range(len(parts)):
        if parts[~i] == "koder":
            parts[~i] = "figurer"
            break

    dirname = "/".join(parts)

    # NOTE: Set `save=True` to save figure. `save=False` to display figure.
    main(dirname=dirname, save=True)
