Opal
====

[![Build Status](https://travis-ci.org/openhealthcare/opal.svg?branch=v0.11.0)](https://travis-ci.org/openhealthcare/opal)
[![Coverage Status](https://coveralls.io/repos/github/openhealthcare/opal/badge.svg?branch=v0.11.0)](https://coveralls.io/github/openhealthcare/opal?branch=v0.11.0)
[![PyPI version](https://badge.fury.io/py/opal.svg)](https://badge.fury.io/py/opal)


Opal is a full stack web framework that makes building digital tools for health care easy.

It builds on established open source technologies with a track record of helping developers
build easy to maintain, robust applications.

Most notably, it makes use of [Django](https://djangoproject.com/), [AngularJS](https://angularjs.org/)
and [Bootstrap](http://getbootstrap.com/).

From there, Opal provides you with a common batteries-included architecture for writing healthcare
applications, and a composable modular framework that takes advantage of generic, re-usable components.

Opal is entirely open ([source](https://github.com/openhealthcare/opal) &
[governance](https://github.com/openhealthcare/opal/issues)) as are the wide library of plugins.

Opal was created by [Open Health Care UK](http://openhealthcare.org.uk), because it makes Healthcare IT Less Bad.

We'd love you to get involved by using what we make, reporting bugs/suggesting improvements, and fixing bugs/updating documentation/making improvements.

## Documentation

Documentation is available at: [http://opal.openhealthcare.org.uk/docs/](http://opal.openhealthcare.org.uk/docs/).
(The source is in this repository at `./doc`)

If you're just getting started we suggest:

* [Installation instructions](http://opal.openhealthcare.org.uk/docs/installation/)
* [The introductory tutorial](http://opal.openhealthcare.org.uk/docs/tutorial/)
* Reading through some [High level topic guides](http://opal.openhealthcare.org.uk/docs/guides/topic-guides/)

The documentation is updated frequently, and we welcome any feedback or contributions to it. If you find any problems,
or feel that anything needs clarifying in any way, please take 30 seconds to fill out a new isue [here](https://github.com/openhealthcare/opal/issues/new).

Documentation for old and development branches are available at e.g. [http://opal.openhealthcare.org.uk/docs/v0.7.1/](http://opal.openhealthcare.org.uk/docs/v0.7.1/)

## Getting more help

If you're looking for help and support, feel free to post to our [Mailing list](https://groups.google.com/forum/?ohc-dev#!forum/ohc-opal)

You could also tweet us at [@opalframework](http://twitter.com/opalframework) - although it can be hard to give long form support there !

## Contributing

Check out [CONTRIBUTING.md](./CONTRIBUTING.md) for information about getting involved.

## Open source

Opal is Licensed under the GNU Affero GPLv3

## Communications

* Email: hello@openhealthcare.org.uk
* Twitter: [@opalframework](https://twitter.com/opalframework)
* Mailing List: https://groups.google.com/forum/?ohc-dev#!forum/ohc-opal
