// variable
var stringArray = [for i in range(0, itemCount): 'item${(i + 1)}']

// output
output storageInfo array = [for (item, i) in range(0, storageCount): {
  id: storageAcct[i].id
  blobEndpoint: storageAcct[i].properties.primaryEndpoints.blob
  status: storageAcct[i].properties.statusOfPrimary
}]

// resource
resource storageIndex 'Microsoft.Storage/storageAccounts@2021-06-01' = [for i in range(0, 2): {
  name: '${i}storage${uniqueString(resourceGroup().id)}'
  location: location
  sku: {
    name: 'Standard_LRS'
  }
  kind: 'Storage'
}]

// module
module stgModule './storageAccount.bicep' = [for i in range(0, storageCount): {
  name: '${i}deploy${baseName}'
  params: {
    storageName: '${i}${baseName}'
    location: location
  }
}]
