import sys

from ewoks.__main__ import main


def test_show(capsys):
    argv = [sys.executable, "show", "demo", "--test"]
    main(argv=argv, shell=False)
    captured = capsys.readouterr()

    expected = """Workflow: demo
Id: demo
Description: demo
╒════════╤════════════════╤═══════════════════╤═══════╕
│ Name   │ Value          │ Task identifier   │ Id    │
╞════════╪════════════════╪═══════════════════╪═══════╡
│ list   │ [0, 1, 2]      │ SumList           │ task0 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumList           │ task0 │
├────────┼────────────────┼───────────────────┼───────┤
│ b      │ <MISSING_DATA> │ SumTask           │ task1 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumTask           │ task1 │
├────────┼────────────────┼───────────────────┼───────┤
│ a      │ 2              │ SumTask           │ task2 │
├────────┼────────────────┼───────────────────┼───────┤
│ b      │ <MISSING_DATA> │ SumTask           │ task2 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumTask           │ task2 │
├────────┼────────────────┼───────────────────┼───────┤
│ b      │ 3              │ SumTask           │ task3 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumTask           │ task3 │
├────────┼────────────────┼───────────────────┼───────┤
│ b      │ 4              │ SumTask           │ task4 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumTask           │ task4 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumTask           │ task5 │
├────────┼────────────────┼───────────────────┼───────┤
│ b      │ 6              │ SumTask           │ task6 │
├────────┼────────────────┼───────────────────┼───────┤
│ delay  │ 0              │ SumTask           │ task6 │
╘════════╧════════════════╧═══════════════════╧═══════╛
"""
    captured.out == expected
    captured.err == ""


def test_show_with_inputs(capsys):
    argv = [sys.executable, "show", "demo", "--test", "-p", "b=999", "--inputs=all"]
    main(argv=argv, shell=False)
    captured = capsys.readouterr()

    expected = """Workflow: demo
Id: demo
Description: demo
╒════════╤═══════════╤═══════════════════╤═══════╕
│ Name   │ Value     │ Task identifier   │ Id    │
╞════════╪═══════════╪═══════════════════╪═══════╡
│ list   │ [0, 1, 2] │ SumList           │ task0 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumList           │ task0 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumTask           │ task1 │
├────────┼───────────┼───────────────────┼───────┤
│ b      │ 999       │ SumTask           │ task1 │
├────────┼───────────┼───────────────────┼───────┤
│ a      │ 2         │ SumTask           │ task2 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumTask           │ task2 │
├────────┼───────────┼───────────────────┼───────┤
│ b      │ 999       │ SumTask           │ task2 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumTask           │ task3 │
├────────┼───────────┼───────────────────┼───────┤
│ b      │ 999       │ SumTask           │ task3 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumTask           │ task4 │
├────────┼───────────┼───────────────────┼───────┤
│ b      │ 999       │ SumTask           │ task4 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumTask           │ task5 │
├────────┼───────────┼───────────────────┼───────┤
│ delay  │ 0         │ SumTask           │ task6 │
├────────┼───────────┼───────────────────┼───────┤
│ b      │ 999       │ SumTask           │ task6 │
╘════════╧═══════════╧═══════════════════╧═══════╛
"""
    captured.out == expected
    captured.err == ""
