import { Cluster } from 'aws-cdk-lib/aws-eks';
import { Role } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface KarpenterProps {
    /**
     * The EKS Cluster to attach to
     */
    readonly cluster: Cluster;
    /**
     * The Kubernetes namespace to install to
     *
     * @default karpenter
     */
    readonly namespace?: string;
    /**
     * The helm chart version to install
     *
     * @default - latest
     */
    readonly version?: string;
}
export declare class Karpenter extends Construct {
    readonly cluster: Cluster;
    readonly namespace: string;
    readonly version?: string;
    readonly nodeRole: Role;
    private readonly chart;
    constructor(scope: Construct, id: string, props: KarpenterProps);
    /**
     * addProvisioner adds a provisioner manifest to the cluster. Currently the provisioner spec
     * parameter is relatively free form.
     *
     * @param id - must consist of lower case alphanumeric characters, \'-\' or \'.\', and must start and end with an alphanumeric character
     * @param provisionerSpec - spec of Karpenters Provisioner object.
     */
    addProvisioner(id: string, provisionerSpec: Record<string, any>): void;
}
