"""Adding OAuth2 config for ConnectionConfig

Revision ID: 0eef0016cf06
Revises: 9e0dcbf67b9f
Create Date: 2025-09-12 01:06:26.838560

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = "0eef0016cf06"
down_revision = "9e0dcbf67b9f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "oauth_config",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("connection_config_id", sa.String(), nullable=False),
        sa.Column(
            "grant_type",
            sa.Enum(
                "authorization_code",
                "client_credentials",
                "password",
                "implicit",
                name="oauthgranttype",
            ),
            nullable=False,
        ),
        sa.Column("token_url", sa.String(), nullable=False),
        sa.Column("scope", sa.String(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=False),
        sa.Column(
            "client_secret", sqlalchemy_utils.types.StringEncryptedType, nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["connection_config_id"],
            ["connectionconfig.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_oauth_config_id"), "oauth_config", ["id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_oauth_config_id"), table_name="oauth_config")
    op.drop_table("oauth_config")
    # ### end Alembic commands ###
