# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneRrsetsResult',
    'AwaitableGetZoneRrsetsResult',
    'get_zone_rrsets',
    'get_zone_rrsets_output',
]

@pulumi.output_type
class GetZoneRrsetsResult:
    """
    A collection of values returned by getZoneRrsets.
    """
    def __init__(__self__, id=None, rrsets=None, with_selector=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rrsets and not isinstance(rrsets, list):
            raise TypeError("Expected argument 'rrsets' to be a list")
        pulumi.set(__self__, "rrsets", rrsets)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def rrsets(self) -> Sequence['outputs.GetZoneRrsetsRrsetResult']:
        return pulumi.get(self, "rrsets")

    @_builtins.property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[_builtins.str]:
        """
        Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector)
        """
        return pulumi.get(self, "with_selector")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        ID or Name of the parent Zone.
        """
        return pulumi.get(self, "zone")


class AwaitableGetZoneRrsetsResult(GetZoneRrsetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneRrsetsResult(
            id=self.id,
            rrsets=self.rrsets,
            with_selector=self.with_selector,
            zone=self.zone)


def get_zone_rrsets(with_selector: Optional[_builtins.str] = None,
                    zone: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneRrsetsResult:
    """
    Provides a list of Hetzner Cloud Zone Resource Record Set (RRSet).

    See the [Zone RRSets API documentation](https://docs.hetzner.cloud/reference/cloud#zone-rrsets) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    example = hcloud.get_zone(name="example.com")
    all = hcloud.get_zone_rrsets(zone=example.name)
    by_label = hcloud.get_zone_rrsets(zone=example.name,
        with_selector="key=value")
    ```


    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector)
    :param _builtins.str zone: ID or Name of the parent Zone.
    """
    __args__ = dict()
    __args__['withSelector'] = with_selector
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getZoneRrsets:getZoneRrsets', __args__, opts=opts, typ=GetZoneRrsetsResult).value

    return AwaitableGetZoneRrsetsResult(
        id=pulumi.get(__ret__, 'id'),
        rrsets=pulumi.get(__ret__, 'rrsets'),
        with_selector=pulumi.get(__ret__, 'with_selector'),
        zone=pulumi.get(__ret__, 'zone'))
def get_zone_rrsets_output(with_selector: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           zone: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneRrsetsResult]:
    """
    Provides a list of Hetzner Cloud Zone Resource Record Set (RRSet).

    See the [Zone RRSets API documentation](https://docs.hetzner.cloud/reference/cloud#zone-rrsets) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    example = hcloud.get_zone(name="example.com")
    all = hcloud.get_zone_rrsets(zone=example.name)
    by_label = hcloud.get_zone_rrsets(zone=example.name,
        with_selector="key=value")
    ```


    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector)
    :param _builtins.str zone: ID or Name of the parent Zone.
    """
    __args__ = dict()
    __args__['withSelector'] = with_selector
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getZoneRrsets:getZoneRrsets', __args__, opts=opts, typ=GetZoneRrsetsResult)
    return __ret__.apply(lambda __response__: GetZoneRrsetsResult(
        id=pulumi.get(__response__, 'id'),
        rrsets=pulumi.get(__response__, 'rrsets'),
        with_selector=pulumi.get(__response__, 'with_selector'),
        zone=pulumi.get(__response__, 'zone')))
