# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[_builtins.str],
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[_builtins.str] mode: Mode of the Zone.
        :param pulumi.Input[_builtins.bool] delete_protection: Whether delete protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Zone.
        :param pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]] primary_nameservers: Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        :param pulumi.Input[_builtins.int] ttl: Default Time To Live (TTL) of the Zone.
        """
        pulumi.set(__self__, "mode", mode)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_nameservers is not None:
            pulumi.set(__self__, "primary_nameservers", primary_nameservers)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        Mode of the Zone.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether delete protection is enabled.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryNameservers")
    def primary_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]]]:
        """
        Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        """
        return pulumi.get(self, "primary_nameservers")

    @primary_nameservers.setter
    def primary_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]]]):
        pulumi.set(self, "primary_nameservers", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default Time To Live (TTL) of the Zone.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 authoritative_nameservers: Optional[pulumi.Input['ZoneAuthoritativeNameserversArgs']] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]]] = None,
                 registrar: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input['ZoneAuthoritativeNameserversArgs'] authoritative_nameservers: Authoritative nameservers of the Zone.
        :param pulumi.Input[_builtins.bool] delete_protection: Whether delete protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] mode: Mode of the Zone.
        :param pulumi.Input[_builtins.str] name: Name of the Zone.
        :param pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]] primary_nameservers: Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        :param pulumi.Input[_builtins.str] registrar: Registrar of the Zone.
        :param pulumi.Input[_builtins.int] ttl: Default Time To Live (TTL) of the Zone.
        """
        if authoritative_nameservers is not None:
            pulumi.set(__self__, "authoritative_nameservers", authoritative_nameservers)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_nameservers is not None:
            pulumi.set(__self__, "primary_nameservers", primary_nameservers)
        if registrar is not None:
            pulumi.set(__self__, "registrar", registrar)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="authoritativeNameservers")
    def authoritative_nameservers(self) -> Optional[pulumi.Input['ZoneAuthoritativeNameserversArgs']]:
        """
        Authoritative nameservers of the Zone.
        """
        return pulumi.get(self, "authoritative_nameservers")

    @authoritative_nameservers.setter
    def authoritative_nameservers(self, value: Optional[pulumi.Input['ZoneAuthoritativeNameserversArgs']]):
        pulumi.set(self, "authoritative_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether delete protection is enabled.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode of the Zone.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryNameservers")
    def primary_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]]]:
        """
        Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        """
        return pulumi.get(self, "primary_nameservers")

    @primary_nameservers.setter
    def primary_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZonePrimaryNameserverArgs']]]]):
        pulumi.set(self, "primary_nameservers", value)

    @_builtins.property
    @pulumi.getter
    def registrar(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Registrar of the Zone.
        """
        return pulumi.get(self, "registrar")

    @registrar.setter
    def registrar(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registrar", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default Time To Live (TTL) of the Zone.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("hcloud:index/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZonePrimaryNameserverArgs', 'ZonePrimaryNameserverArgsDict']]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Hetzner Cloud Zone resource.

        This can be used to create, modify, and delete Zones.

        For Internationalized domain names (IDN), see the `provider::hcloud::idna` function.

        See the [Zones API documentation](https://docs.hetzner.cloud/reference/cloud#zones) for more details.

        ## Import

        In Terraform v1.5.0 and later, the `import` block can be used with the `id` attribute, for example:

        terraform

        import {

          to = hcloud_zone.example_primary

          id = "$ZONE_ID_OR_NAME"

        }

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import hcloud:index/zone:Zone example "$ZONE_ID_OR_NAME"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_protection: Whether delete protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] mode: Mode of the Zone.
        :param pulumi.Input[_builtins.str] name: Name of the Zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZonePrimaryNameserverArgs', 'ZonePrimaryNameserverArgsDict']]]] primary_nameservers: Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        :param pulumi.Input[_builtins.int] ttl: Default Time To Live (TTL) of the Zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Hetzner Cloud Zone resource.

        This can be used to create, modify, and delete Zones.

        For Internationalized domain names (IDN), see the `provider::hcloud::idna` function.

        See the [Zones API documentation](https://docs.hetzner.cloud/reference/cloud#zones) for more details.

        ## Import

        In Terraform v1.5.0 and later, the `import` block can be used with the `id` attribute, for example:

        terraform

        import {

          to = hcloud_zone.example_primary

          id = "$ZONE_ID_OR_NAME"

        }

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import hcloud:index/zone:Zone example "$ZONE_ID_OR_NAME"
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZonePrimaryNameserverArgs', 'ZonePrimaryNameserverArgsDict']]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["labels"] = labels
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_nameservers"] = primary_nameservers
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["authoritative_nameservers"] = None
            __props__.__dict__["registrar"] = None
        super(Zone, __self__).__init__(
            'hcloud:index/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authoritative_nameservers: Optional[pulumi.Input[Union['ZoneAuthoritativeNameserversArgs', 'ZoneAuthoritativeNameserversArgsDict']]] = None,
            delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZonePrimaryNameserverArgs', 'ZonePrimaryNameserverArgsDict']]]]] = None,
            registrar: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ZoneAuthoritativeNameserversArgs', 'ZoneAuthoritativeNameserversArgsDict']] authoritative_nameservers: Authoritative nameservers of the Zone.
        :param pulumi.Input[_builtins.bool] delete_protection: Whether delete protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] mode: Mode of the Zone.
        :param pulumi.Input[_builtins.str] name: Name of the Zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZonePrimaryNameserverArgs', 'ZonePrimaryNameserverArgsDict']]]] primary_nameservers: Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        :param pulumi.Input[_builtins.str] registrar: Registrar of the Zone.
        :param pulumi.Input[_builtins.int] ttl: Default Time To Live (TTL) of the Zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["authoritative_nameservers"] = authoritative_nameservers
        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["labels"] = labels
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_nameservers"] = primary_nameservers
        __props__.__dict__["registrar"] = registrar
        __props__.__dict__["ttl"] = ttl
        return Zone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authoritativeNameservers")
    def authoritative_nameservers(self) -> pulumi.Output['outputs.ZoneAuthoritativeNameservers']:
        """
        Authoritative nameservers of the Zone.
        """
        return pulumi.get(self, "authoritative_nameservers")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether delete protection is enabled.
        """
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        Mode of the Zone.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryNameservers")
    def primary_nameservers(self) -> pulumi.Output[Sequence['outputs.ZonePrimaryNameserver']]:
        """
        Primary nameservers of the Zone. Forbidden when mode is primary and required when mode is secondary.
        """
        return pulumi.get(self, "primary_nameservers")

    @_builtins.property
    @pulumi.getter
    def registrar(self) -> pulumi.Output[_builtins.str]:
        """
        Registrar of the Zone.
        """
        return pulumi.get(self, "registrar")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Default Time To Live (TTL) of the Zone.
        """
        return pulumi.get(self, "ttl")

