# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneRrsetArgs', 'ZoneRrset']

@pulumi.input_type
class ZoneRrsetArgs:
    def __init__(__self__, *,
                 records: pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]],
                 type: pulumi.Input[_builtins.str],
                 zone: pulumi.Input[_builtins.str],
                 change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ZoneRrset resource.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]] records: Records of the Zone RRSet.
        :param pulumi.Input[_builtins.str] type: Type of the Zone RRSet.
        :param pulumi.Input[_builtins.str] zone: ID or Name of the parent Zone.
        :param pulumi.Input[_builtins.bool] change_protection: Whether change protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Zone RRSet.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) of the Zone RRSet.
        """
        pulumi.set(__self__, "records", records)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)
        if change_protection is not None:
            pulumi.set(__self__, "change_protection", change_protection)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def records(self) -> pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]]:
        """
        Records of the Zone RRSet.
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]]):
        pulumi.set(self, "records", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the Zone RRSet.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        ID or Name of the parent Zone.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter(name="changeProtection")
    def change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether change protection is enabled.
        """
        return pulumi.get(self, "change_protection")

    @change_protection.setter
    def change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "change_protection", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Zone RRSet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time To Live (TTL) of the Zone RRSet.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _ZoneRrsetState:
    def __init__(__self__, *,
                 change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneRrset resources.
        :param pulumi.Input[_builtins.bool] change_protection: Whether change protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Zone RRSet.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]] records: Records of the Zone RRSet.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) of the Zone RRSet.
        :param pulumi.Input[_builtins.str] type: Type of the Zone RRSet.
        :param pulumi.Input[_builtins.str] zone: ID or Name of the parent Zone.
        """
        if change_protection is not None:
            pulumi.set(__self__, "change_protection", change_protection)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if records is not None:
            pulumi.set(__self__, "records", records)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="changeProtection")
    def change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether change protection is enabled.
        """
        return pulumi.get(self, "change_protection")

    @change_protection.setter
    def change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "change_protection", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Zone RRSet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]]]:
        """
        Records of the Zone RRSet.
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRrsetRecordArgs']]]]):
        pulumi.set(self, "records", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time To Live (TTL) of the Zone RRSet.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Zone RRSet.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID or Name of the parent Zone.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("hcloud:index/zoneRrset:ZoneRrset")
class ZoneRrset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneRrsetRecordArgs', 'ZoneRrsetRecordArgsDict']]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        In Terraform v1.5.0 and later, the `import` block can be used with the `id` attribute, for example:

        terraform

        import {

          to = hcloud_zone_rrset.example

          id = "$ZONE_ID_OR_NAME/$RRSET_NAME/$RRSET_TYPE"

        }

        import {

          to = hcloud_zone_rrset.example

          id = "$ZONE_ID_OR_NAME/$RRSET_ID"

        }

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import hcloud:index/zoneRrset:ZoneRrset example "$ZONE_ID_OR_NAME/$RRSET_NAME/$RRSET_TYPE"
        ```

        ```sh
        $ pulumi import hcloud:index/zoneRrset:ZoneRrset example "$ZONE_ID_OR_NAME/$RRSET_ID"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] change_protection: Whether change protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Zone RRSet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneRrsetRecordArgs', 'ZoneRrsetRecordArgsDict']]]] records: Records of the Zone RRSet.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) of the Zone RRSet.
        :param pulumi.Input[_builtins.str] type: Type of the Zone RRSet.
        :param pulumi.Input[_builtins.str] zone: ID or Name of the parent Zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneRrsetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        In Terraform v1.5.0 and later, the `import` block can be used with the `id` attribute, for example:

        terraform

        import {

          to = hcloud_zone_rrset.example

          id = "$ZONE_ID_OR_NAME/$RRSET_NAME/$RRSET_TYPE"

        }

        import {

          to = hcloud_zone_rrset.example

          id = "$ZONE_ID_OR_NAME/$RRSET_ID"

        }

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import hcloud:index/zoneRrset:ZoneRrset example "$ZONE_ID_OR_NAME/$RRSET_NAME/$RRSET_TYPE"
        ```

        ```sh
        $ pulumi import hcloud:index/zoneRrset:ZoneRrset example "$ZONE_ID_OR_NAME/$RRSET_ID"
        ```

        :param str resource_name: The name of the resource.
        :param ZoneRrsetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneRrsetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneRrsetRecordArgs', 'ZoneRrsetRecordArgsDict']]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneRrsetArgs.__new__(ZoneRrsetArgs)

            __props__.__dict__["change_protection"] = change_protection
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if records is None and not opts.urn:
                raise TypeError("Missing required property 'records'")
            __props__.__dict__["records"] = records
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
        super(ZoneRrset, __self__).__init__(
            'hcloud:index/zoneRrset:ZoneRrset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneRrsetRecordArgs', 'ZoneRrsetRecordArgsDict']]]]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZoneRrset':
        """
        Get an existing ZoneRrset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] change_protection: Whether change protection is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Zone RRSet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneRrsetRecordArgs', 'ZoneRrsetRecordArgsDict']]]] records: Records of the Zone RRSet.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) of the Zone RRSet.
        :param pulumi.Input[_builtins.str] type: Type of the Zone RRSet.
        :param pulumi.Input[_builtins.str] zone: ID or Name of the parent Zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneRrsetState.__new__(_ZoneRrsetState)

        __props__.__dict__["change_protection"] = change_protection
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["records"] = records
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return ZoneRrset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="changeProtection")
    def change_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether change protection is enabled.
        """
        return pulumi.get(self, "change_protection")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Zone RRSet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> pulumi.Output[Sequence['outputs.ZoneRrsetRecord']]:
        """
        Records of the Zone RRSet.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time To Live (TTL) of the Zone RRSet.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the Zone RRSet.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        ID or Name of the parent Zone.
        """
        return pulumi.get(self, "zone")

