# Copyright (c) 2025, Palo Alto Networks
#
# Licensed under the Polyform Internal Use License 1.0.0 (the "License");
# you may not use this file except in compliance with the License.
#
# You may obtain a copy of the License at:
#
# https://polyformproject.org/licenses/internal-use/1.0.0
# (or)
# https://github.com/polyformproject/polyform-licenses/blob/76a278c4/PolyForm-Internal-Use-1.0.0.md
#
# As far as the law allows, the software comes as is, without any warranty
# or condition, and the licensor will not be liable to you for any damages
# arising out of these terms or the use or nature of the software, under
# any kind of legal claim.

"""
AISec API service

OpenAPI Specification for the AI Runtime Security API service

The version of the OpenAPI document: 0.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from aisecurity.generated_openapi_client.models.agent_report_object import AgentReportObject
from aisecurity.generated_openapi_client.models.cg_report_object import CgReportObject
from aisecurity.generated_openapi_client.models.dbs_entry_object import DbsEntryObject
from aisecurity.generated_openapi_client.models.dlp_report_object import DlpReportObject
from aisecurity.generated_openapi_client.models.mc_report_object import McReportObject
from aisecurity.generated_openapi_client.models.tc_report_object import TcReportObject
from aisecurity.generated_openapi_client.models.tg_report_object import TgReportObject
from aisecurity.generated_openapi_client.models.urlf_entry_object import UrlfEntryObject
from typing import Optional, Set
from typing_extensions import Self


class DSDetailResultObject(BaseModel):
    """
    DSDetailResultObject
    """  # noqa: E501

    urlf_report: Optional[List[UrlfEntryObject]] = None
    dlp_report: Optional[DlpReportObject] = None
    dbs_report: Optional[List[DbsEntryObject]] = None
    tc_report: Optional[TcReportObject] = None
    mc_report: Optional[McReportObject] = None
    agent_report: Optional[AgentReportObject] = None
    topic_guardrails_report: Optional[TgReportObject] = None
    cg_report: Optional[CgReportObject] = None
    __properties: ClassVar[List[str]] = [
        "urlf_report",
        "dlp_report",
        "dbs_report",
        "tc_report",
        "mc_report",
        "agent_report",
        "topic_guardrails_report",
        "cg_report",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DSDetailResultObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in urlf_report (list)
        _items = []
        if self.urlf_report:
            for _item_urlf_report in self.urlf_report:
                if _item_urlf_report:
                    _items.append(_item_urlf_report.to_dict())
            _dict["urlf_report"] = _items
        # override the default output from pydantic by calling `to_dict()` of dlp_report
        if self.dlp_report:
            _dict["dlp_report"] = self.dlp_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dbs_report (list)
        _items = []
        if self.dbs_report:
            for _item_dbs_report in self.dbs_report:
                if _item_dbs_report:
                    _items.append(_item_dbs_report.to_dict())
            _dict["dbs_report"] = _items
        # override the default output from pydantic by calling `to_dict()` of tc_report
        if self.tc_report:
            _dict["tc_report"] = self.tc_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mc_report
        if self.mc_report:
            _dict["mc_report"] = self.mc_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of agent_report
        if self.agent_report:
            _dict["agent_report"] = self.agent_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of topic_guardrails_report
        if self.topic_guardrails_report:
            _dict["topic_guardrails_report"] = self.topic_guardrails_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cg_report
        if self.cg_report:
            _dict["cg_report"] = self.cg_report.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DSDetailResultObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "urlf_report": [UrlfEntryObject.from_dict(_item) for _item in obj["urlf_report"]]
            if obj.get("urlf_report") is not None
            else None,
            "dlp_report": DlpReportObject.from_dict(obj["dlp_report"]) if obj.get("dlp_report") is not None else None,
            "dbs_report": [DbsEntryObject.from_dict(_item) for _item in obj["dbs_report"]]
            if obj.get("dbs_report") is not None
            else None,
            "tc_report": TcReportObject.from_dict(obj["tc_report"]) if obj.get("tc_report") is not None else None,
            "mc_report": McReportObject.from_dict(obj["mc_report"]) if obj.get("mc_report") is not None else None,
            "agent_report": AgentReportObject.from_dict(obj["agent_report"])
            if obj.get("agent_report") is not None
            else None,
            "topic_guardrails_report": TgReportObject.from_dict(obj["topic_guardrails_report"])
            if obj.get("topic_guardrails_report") is not None
            else None,
            "cg_report": CgReportObject.from_dict(obj["cg_report"]) if obj.get("cg_report") is not None else None,
        })
        return _obj
