# Copyright (c) 2025, Palo Alto Networks
#
# Licensed under the Polyform Internal Use License 1.0.0 (the "License");
# you may not use this file except in compliance with the License.
#
# You may obtain a copy of the License at:
#
# https://polyformproject.org/licenses/internal-use/1.0.0
# (or)
# https://github.com/polyformproject/polyform-licenses/blob/76a278c4/PolyForm-Internal-Use-1.0.0.md
#
# As far as the law allows, the software comes as is, without any warranty
# or condition, and the licensor will not be liable to you for any damages
# arising out of these terms or the use or nature of the software, under
# any kind of legal claim.

"""
AISec API service

OpenAPI Specification for the AI Runtime Security API service

The version of the OpenAPI document: 0.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aisecurity.generated_openapi_client.models.mc_entry_object import McEntryObject
from typing import Optional, Set
from typing_extensions import Self


class McReportObject(BaseModel):
    """
    McReportObject
    """  # noqa: E501

    verdict: Optional[StrictStr] = Field(
        default=None, description='Detection service verdict such as "malicious" or "benign"'
    )
    code_analysis_by_type: Optional[List[McEntryObject]] = None
    all_code_blocks: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["verdict", "code_analysis_by_type", "all_code_blocks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of McReportObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in code_analysis_by_type (list)
        _items = []
        if self.code_analysis_by_type:
            for _item_code_analysis_by_type in self.code_analysis_by_type:
                if _item_code_analysis_by_type:
                    _items.append(_item_code_analysis_by_type.to_dict())
            _dict["code_analysis_by_type"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of McReportObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "verdict": obj.get("verdict"),
            "code_analysis_by_type": [McEntryObject.from_dict(_item) for _item in obj["code_analysis_by_type"]]
            if obj.get("code_analysis_by_type") is not None
            else None,
            "all_code_blocks": obj.get("all_code_blocks"),
        })
        return _obj
