# Copyright (c) 2025, Palo Alto Networks
#
# Licensed under the Polyform Internal Use License 1.0.0 (the "License");
# you may not use this file except in compliance with the License.
#
# You may obtain a copy of the License at:
#
# https://polyformproject.org/licenses/internal-use/1.0.0
# (or)
# https://github.com/polyformproject/polyform-licenses/blob/76a278c4/PolyForm-Internal-Use-1.0.0.md
#
# As far as the law allows, the software comes as is, without any warranty
# or condition, and the licensor will not be liable to you for any damages
# arising out of these terms or the use or nature of the software, under
# any kind of legal claim.

"""
AISec API service

OpenAPI Specification for the AI Runtime Security API service

The version of the OpenAPI document: 0.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aisecurity.generated_openapi_client.models.tool_event import ToolEvent
from typing import Optional, Set
from typing_extensions import Self


class ScanRequestContentsInner(BaseModel):
    """
    ScanRequestContentsInner
    """  # noqa: E501

    prompt: Optional[StrictStr] = Field(default=None, description="The prompt content that you want to scan")
    response: Optional[StrictStr] = Field(default=None, description="The response content that you want to scan")
    code_prompt: Optional[StrictStr] = Field(
        default=None, description="Code snippet extracted from Prompt content that you want to scan"
    )
    code_response: Optional[StrictStr] = Field(
        default=None, description="Code snippet extracted from Response content that you want to scan"
    )
    context: Optional[StrictStr] = Field(default=None, description="The data context for contextual grounding")
    tool_event: Optional[ToolEvent] = None
    __properties: ClassVar[List[str]] = ["prompt", "response", "code_prompt", "code_response", "context", "tool_event"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScanRequestContentsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tool_event
        if self.tool_event:
            _dict["tool_event"] = self.tool_event.to_dict()
        # set to None if tool_event (nullable) is None
        # and model_fields_set contains the field
        if self.tool_event is None and "tool_event" in self.model_fields_set:
            _dict["tool_event"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScanRequestContentsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prompt": obj.get("prompt"),
            "response": obj.get("response"),
            "code_prompt": obj.get("code_prompt"),
            "code_response": obj.get("code_response"),
            "context": obj.get("context"),
            "tool_event": ToolEvent.from_dict(obj["tool_event"]) if obj.get("tool_event") is not None else None,
        })
        return _obj
