# Generated by Django 5.0.9 on 2024-10-24 11:00

import django.contrib.postgres.fields
from django.db import migrations, models


def migrate_new_source(apps, schema_editor):
    from wbcore.contrib.io.models import (
        DataBackend,
        ImportSource,
        ParserHandler,
        Source,
    )

    parser_handler = ParserHandler.objects.get(parser="wbnews.import_export.parsers.rss.news")
    io_news_sources = Source.objects.filter(parser_handler=parser_handler)
    crontab = io_news_sources.last().crontab
    data_backend = DataBackend.objects.get(backend_class_path="wbnews.import_export.backends.news")
    default_news_source, created = Source.objects.get_or_create(
        data_backend=data_backend,
        defaults={
            "crontab": crontab,
            "title": "RSS Feeds -> News",
        },
    )
    default_news_source.parser_handler.set([parser_handler])
    ImportSource.objects.filter(source__in=io_news_sources).update(source=default_news_source)
    io_news_sources.exclude(id=default_news_source.id).delete()
    NewsSource = apps.get_model("wbnews", "NewsSource")
    NewsSource.objects.filter(title__icontains="Email").update(type="EMAIL")
    NewsSource.objects.filter(type="RSS").filter(url__isnull=True, identifier__isnull=False).update(
        url=models.F("identifier")
    )

    unvalid_rss_feeds = [
        "https://www.dailytelegraph.com.au/help-rss",
        "https://techcrunch.com/rssfeeds/",
        "https://www.bbc.co.uk/news/",
        "https://www.nytimes.com/section/technology",
        "http://online.wsj.com/page/2_0006.html",
        "http://online.wsj.com",
        "https://www.bbc.co.uk/news/technology",
        "https://www.bbc.co.uk/news/world",
        "https://www.bbc.co.uk/news/business",
        "https://www.techworld.com/news/rss",
    ]
    NewsSource.objects.filter(url__in=unvalid_rss_feeds).update(is_active=False)


class Migration(migrations.Migration):
    dependencies = [
        ("wbnews", "0008_alter_news_language"),
    ]

    operations = [
        migrations.AddField(
            model_name="newsrelationship",
            name="analysis",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="newsrelationship",
            name="sentiment",
            field=models.PositiveIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="newssource",
            name="clean_content",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="newssource",
            name="is_active",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="newssource",
            name="type",
            field=models.CharField(choices=[("RSS", "RSS"), ("EMAIL", "EMAIL")], default="RSS", max_length=6),
        ),
        migrations.AlterField(
            model_name="newssource",
            name="description",
            field=models.TextField(blank=True, default=""),
        ),
        migrations.AlterField(
            model_name="newssource",
            name="tags",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=16), blank=True, default=list, size=None
            ),
        ),
        migrations.RunPython(migrate_new_source),
    ]
