# Generated by Django 5.0.14 on 2025-05-06 14:44

from django.db import migrations, models
from django.db.models import Count
from tqdm import tqdm

def handle_duplicated_relationship(apps, schema_editor):
    NewsRelationship = apps.get_model("wbnews", "NewsRelationship")
    qs = NewsRelationship.objects.values('content_type', 'object_id', 'news').annotate(c=Count('*')).filter(c__gt=1)
    for row in tqdm(qs, total=qs.count()):
        for rel in NewsRelationship.objects.filter(content_type=row['content_type'], news=row['news'], object_id=row["object_id"])[1:]:
            rel.delete()

class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('wbnews', '0013_alter_news_datetime'),
    ]

    operations = [
        migrations.RunPython(handle_duplicated_relationship),
        migrations.AddConstraint(
            model_name='newsrelationship',
            constraint=models.UniqueConstraint(fields=('content_type', 'object_id', 'news'), name='unique_news_relationship'),
        ),
    ]
