"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
function arnForApplication(applicationName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                "at least one CloudWatch alarm with the Deployment Group");
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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