from __future__ import annotations

from typing_extensions import Literal

from abqpy.decorators import abaqus_class_doc, abaqus_method_doc

from ..UtilityAndView.abaqusConstants import DEFAULT_MODEL, SymbolicConstant
from ..UtilityAndView.abaqusConstants import abaqusConstants as C
from .Leaf import Leaf


@abaqus_class_doc
class LeafFromConstraintNames(Leaf):
    """The LeafFromConstraintNames object can be used whenever a Leaf object is expected as an argument. A Leaf
    object is used used to specify the items in a display group. Leaf objects are constructed as temporary
    objects that are used as arguments to DisplayGroup (DisplayGroup object) commands. The
    LeafFromConstraintNames object is derived from the Leaf object.

    .. note::
        This object can be accessed by::

            import displayGroupOdbToolset

    .. versionadded:: 2019
        The ``LeafFromConstraintNames`` class was added.
    """

    #: A SymbolicConstant specifying the leaf type. Possible values are TIE,
    #: SHELL_TO_SOLID_COUPLING, DISTRIBUTING_COUPLING, KINEMATIC_COUPLING, RIGID_BODY, and MPC.
    leafType: SymbolicConstant

    @abaqus_method_doc
    def __init__(
        self,
        name: tuple,
        type: Literal[
            C.DISTRIBUTING_COUPLING, C.TIE, C.RIGID_BODY, C.MPC, C.SHELL_TO_SOLID_COUPLING, C.KINEMATIC_COUPLING
        ],
    ):
        """This method creates a Leaf object from a sequence of constraint objects. Leaf objects specify the
        items in a display group.

        .. note::
            This function can be accessed by::

                LeafFromConstraintNames

        Parameters
        ----------
        name
            A sequence of tuples of name objects.
        type
            A SymbolicConstant specifying the Leaf type. Possible values are TIE,
            SHELL_TO_SOLID_COUPLING, DISTRIBUTING_COUPLING, KINEMATIC_COUPLING, RIGID_BODY, and MPC.

        Returns
        -------
            A LeafFromConstraintNames object.
        """
        super().__init__(DEFAULT_MODEL)
