workload = {
    0: {  # conv1, stride 2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 64,
            "C": 3,
            "OY": 112,
            "OX": 112,
            "FY": 7,
            "FX": 7,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": []},
        "constant_operands": ["I", "W"],
    },
    1: {  # max pool, stride 2
        "operator_type": "Pooling",
        "equation": "O[b][g][oy][ox]+=W[fx][fy]*I[b][g][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {"B": 1, "G": 64, "OY": 56, "OX": 56, "FX": 3, "FY": 3},
        "operand_precision": {"O": 16, "O_final": 8, "I": 8, "W": 0},
        "operand_source": {"W": [], "I": [0]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "G": "K"}},
    },
    2: {  # conv2_1
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 64,
            "C": 64,
            "OY": 56,
            "OX": 56,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [1]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    3: {  # conv2_2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 64,
            "C": 64,
            "OY": 56,
            "OX": 56,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [2]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    4: {  # Addition of layer 1 (residual path) and layer 3 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 64, "OY": 56, "OX": 56},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [1], "Y": [3]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "K"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    5: {  # conv2_3
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 64,
            "C": 64,
            "OY": 56,
            "OX": 56,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [4]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    6: {  # conv2_4
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 64,
            "C": 64,
            "OY": 56,
            "OX": 56,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [5]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    7: {  # Addition of layer 4 (residual connection) and layer 6 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 64, "OY": 56, "OX": 56},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [4], "Y": [6]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "G"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    8: {  # conv3_1, stride 2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 128,
            "C": 64,
            "OY": 28,
            "OX": 28,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [7]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    9: {  # conv3_2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 128,
            "C": 128,
            "OY": 28,
            "OX": 28,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [8]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    10: {  # conv downsample of layer 7
        "operator_type": "Conv_downsample",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 128,
            "C": 64,
            "OY": 28,
            "OX": 28,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [7]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    11: {  # Addition of layer 10 (residual connection) and layer 9 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 128, "OY": 28, "OX": 28},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [10], "Y": [9]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "K"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    12: {  # conv3_3
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 128,
            "C": 128,
            "OY": 28,
            "OX": 28,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [11]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    13: {  # conv3_4
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 128,
            "C": 128,
            "OY": 28,
            "OX": 28,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [12]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    14: {  # Addition of layer 11 (residual connection) and layer 13 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 128, "OY": 28, "OX": 28},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [11], "Y": [13]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "G"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    15: {  # conv4_1, stride 2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 256,
            "C": 128,
            "OY": 14,
            "OX": 14,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [14]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    16: {  # conv4_2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 256,
            "C": 256,
            "OY": 14,
            "OX": 14,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [15]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    17: {  # conv downsample of layer 14
        "operator_type": "Conv_downsample",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 256,
            "C": 128,
            "OY": 14,
            "OX": 14,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [14]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    18: {  # Addition of layer 17 (residual connection) and layer 16 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 256, "OY": 14, "OX": 14},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [17], "Y": [16]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "K"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    19: {  # conv4_3
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 256,
            "C": 256,
            "OY": 14,
            "OX": 14,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [18]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    20: {  # conv4_4
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 256,
            "C": 256,
            "OY": 14,
            "OX": 14,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [19]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    21: {  # Addition of layer 18 (residual connection) and layer 20 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 256, "OY": 14, "OX": 14},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [18], "Y": [20]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "G"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    22: {  # conv5_1, stride 2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 512,
            "C": 256,
            "OY": 7,
            "OX": 7,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [21]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    23: {  # conv5_2
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 512,
            "C": 512,
            "OY": 7,
            "OX": 7,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [22]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    24: {  # conv downsample of layer 21
        "operator_type": "Conv_downsample",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=2*ox+1*fx", "iy=2*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 512,
            "C": 256,
            "OY": 7,
            "OX": 7,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [21]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    25: {  # Addition of layer 24 (residual connection) and layer 23 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 512, "OY": 7, "OX": 7},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [24], "Y": [23]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "G"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    26: {  # conv5_3
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 512,
            "C": 512,
            "OY": 7,
            "OX": 7,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [25]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
    27: {  # conv4_4
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 512,
            "C": 512,
            "OY": 7,
            "OX": 7,
            "FY": 3,
            "FX": 3,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [26]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "K"}},
    },
    28: {  # Addition of layer 25 (residual connection) and layer 27 (main path)
        "operator_type": "Add",
        "equation": "O[b][g][oy][ox]=X[b][g][oy][ox]+Y[b][g][oy][ox]",
        "dimension_relations": [],
        "loop_dim_size": {"B": 1, "G": 512, "OY": 7, "OX": 7},
        "operand_precision": {"O": 16, "O_final": 8, "X": 8, "Y": 8},
        "operand_source": {"X": [25], "Y": [27]},
        "constant_operands": [],
        "operand_source_dimension_mapping": {
            "X": {"OX": "OX", "OY": "OY", "G": "G"},
            "Y": {"OX": "OX", "OY": "OY", "G": "K"},
        },
    },
    29: {  # aver pool
        "operator_type": "Pooling",
        "equation": "O[b][g][oy][ox]+=W[fx][fy]*I[b][g][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {"B": 1, "G": 512, "OY": 1, "OX": 1, "FX": 7, "FY": 7},
        "operand_precision": {"O": 16, "O_final": 8, "I": 8, "W": 0},
        "operand_source": {"W": [], "I": [28]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "G": "K"}},
    },
    30: {  # fc
        "operator_type": "Conv",
        "equation": "O[b][k][oy][ox]+=W[k][c][fy][fx]*I[b][c][iy][ix]",
        "dimension_relations": ["ix=1*ox+1*fx", "iy=1*oy+1*fy"],
        "loop_dim_size": {
            "B": 1,
            "K": 1000,
            "C": 512,
            "OY": 1,
            "OX": 1,
            "FY": 1,
            "FX": 1,
        },
        "operand_precision": {"O": 16, "O_final": 8, "W": 8, "I": 8},
        "operand_source": {"W": [], "I": [29]},
        "constant_operands": ["W"],
        "operand_source_dimension_mapping": {"I": {"IX": "OX", "IY": "OY", "C": "G"}},
    },
}
