# Generated by Django 4.2.21 on 2025-06-04 02:22

from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Incident',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('priority', models.IntegerField(db_index=True, default=0)),
                ('state', models.IntegerField(db_index=True, default=0)),
                ('category', models.CharField(db_index=True, max_length=124)),
                ('title', models.TextField(default=None, null=True)),
                ('details', models.TextField(default=None, null=True)),
                ('model_name', models.TextField(db_index=True, default=None, null=True)),
                ('model_id', models.IntegerField(db_index=True, default=0)),
                ('source_ip', models.CharField(blank=True, db_index=True, default=None, max_length=16, null=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='RuleSet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('priority', models.IntegerField(db_index=True, default=0)),
                ('category', models.CharField(db_index=True, max_length=124)),
                ('name', models.TextField(default=None, null=True)),
                ('bundle', models.IntegerField(default=0)),
                ('bundle_by', models.IntegerField(default=3)),
                ('match_by', models.IntegerField(default=0)),
                ('handler', models.TextField(default=None, null=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('name', models.TextField(default=None, null=True)),
                ('index', models.IntegerField(db_index=True, default=0)),
                ('comparator', models.CharField(default='==', max_length=32)),
                ('field_name', models.CharField(default=None, max_length=124, null=True)),
                ('value', models.CharField(default='', max_length=124)),
                ('value_type', models.CharField(default='int', max_length=10)),
                ('is_required', models.IntegerField(default=0)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='rules', to='incident.ruleset')),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('level', models.IntegerField(db_index=True, default=0)),
                ('category', models.CharField(db_index=True, max_length=124)),
                ('title', models.TextField(default=None, null=True)),
                ('details', models.TextField(default=None, null=True)),
                ('model_name', models.TextField(db_index=True, default=None, null=True)),
                ('model_id', models.IntegerField(db_index=True, default=0)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('incident', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='events', to='incident.incident')),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
