# FitTrackee
**A simple self-hosted workout/activity tracker.**  


[![Python Version](https://img.shields.io/pypi/pyversions/fittrackee.svg)](https://python.org)
[![Flask Version](https://img.shields.io/badge/flask-3.1-brightgreen.svg)](http://flask.pocoo.org/) 
[![code formatter: ruff](https://img.shields.io/badge/code%20formatter-ruff-d7ff64)](https://docs.astral.sh/ruff/) 
[![type check: mypy](https://img.shields.io/badge/type%20check-mypy-blue)](http://mypy-lang.org/)  
[![Vue Version](https://img.shields.io/badge/vue-3.5-brightgreen.svg)](https://v3.vuejs.org/) 
[![code formatter: prettier](https://img.shields.io/badge/code%20formatter-prettier-ff69b4.svg)](https://github.com/prettier/prettier) 
[![Typescript Version](https://img.shields.io/npm/types/typescript)](https://www.typescriptlang.org/)  
[![PyPI version](https://img.shields.io/pypi/v/fittrackee?logo=pypi)](https://pypi.org/project/fittrackee/) [![docker image version](https://img.shields.io/docker/v/fittrackee/fittrackee?logo=docker)](https://hub.docker.com/r/fittrackee/fittrackee)  
[![pipeline status](https://github.com/SamR1/FitTrackee/actions/workflows/.tests-and-publish-python.yml/badge.svg)](https://github.com/SamR1/FitTrackee/actions/workflows/.tests-and-publish-python.yml)
[![pipeline status](https://github.com/SamR1/FitTrackee/actions/workflows/.tests-javascript.yml/badge.svg)](https://github.com/SamR1/FitTrackee/actions/workflows/.tests-javascript.yml)  
[![translation status](https://hosted.weblate.org/widgets/fittrackee/-/svg-badge.svg)](https://hosted.weblate.org/engage/fittrackee/)
[![translation languages](https://hosted.weblate.org/widget/fittrackee/language-badge.svg)](https://hosted.weblate.org/engage/fittrackee/)   
[![Matrix](https://img.shields.io/matrix/fittrackee%3Amatrix.org?logo=matrix)](https://matrix.to/#/#fittrackee:matrix.org)
[![Mastodon Follow](https://img.shields.io/mastodon/follow/109270806934115805?domain=fosstodon.org)](https://fosstodon.org/@FitTrackee)  
---

Web application allowing tracking of outdoor activities (workouts) from files, \
with data on your own server.  

Several mobile apps or devices can store workouts data locally and export them into a file.  
Examples for Android (non-exhaustive list):  
* [Runner Up](https://github.com/jonasoreland/runnerup) (GPLv3)  
* [OpenTracks](https://github.com/OpenTracksApp/OpenTracks) (Apache License)  
* [FitoTrack](https://codeberg.org/jannis/FitoTrack) (GPLv3)  

It is also possible to add a workout without a file.

Map data from [OpenStreetMap](https://www.openstreetmap.org).  

## Documentation

- [Features](https://docs.fittrackee.org/en/features.html)
- [Installation instructions](https://docs.fittrackee.org/en/installation.html)
- [Changelog](https://docs.fittrackee.org/en/changelog.html)
- [Contributing](CONTRIBUTING.md)

**Under heavy development (some features may be unstable).**  
(see [issues](https://github.com/SamR1/FitTrackee/issues) and [documentation](https://docs.fittrackee.org) for more info.)  

![FitTrackee Dashboard Screenshot](https://docs.fittrackee.org/en/_images/dashboard.png)

## Translations

FitTrackee uses [Weblate](https://hosted.weblate.org/engage/fittrackee/) for translation management.

Status (on development branch, may differ from the released version):

[![Translation status](https://hosted.weblate.org/widget/fittrackee/multi-auto.svg)](https://hosted.weblate.org/engage/fittrackee/)
