"""Update Nullable after sqlalchemy upgrade

Revision ID: 070bd31919c3
Revises: d3c5338bedff
Create Date: 2025-01-26 08:52:44.942137

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '070bd31919c3'
down_revision = 'd3c5338bedff'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('blocked_users', schema=None) as batch_op:
        batch_op.alter_column('user_id',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('by_user_id',
               existing_type=sa.INTEGER(),
               nullable=False)

    with op.batch_alter_table('comments', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=False)

    with op.batch_alter_table('equipments', schema=None) as batch_op:
        batch_op.alter_column('equipment_type_id',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('creation_date',
               existing_type=postgresql.TIMESTAMP(),
               nullable=False)
        batch_op.alter_column('total_distance',
               existing_type=sa.NUMERIC(precision=10, scale=3),
               nullable=False,
               existing_server_default=sa.text('0.0'))

    with op.batch_alter_table('notifications', schema=None) as batch_op:
        batch_op.alter_column('from_user_id',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('to_user_id',
               existing_type=sa.INTEGER(),
               nullable=False)

    with op.batch_alter_table('records', schema=None) as batch_op:
        batch_op.alter_column('record_type',
               existing_type=postgresql.ENUM('AS', 'FD', 'LD', 'MS', 'HA', name='record_types'),
               nullable=False)

    with op.batch_alter_table('report_actions', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=False)

    with op.batch_alter_table('report_comments', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=False)

    with op.batch_alter_table('reports', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=False)

    with op.batch_alter_table('users_data_export', schema=None) as batch_op:
        batch_op.alter_column('user_id',
               existing_type=sa.INTEGER(),
               nullable=False)

    with op.batch_alter_table('workouts', schema=None) as batch_op:
        batch_op.alter_column('creation_date',
               existing_type=postgresql.TIMESTAMP(),
               nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('workouts', schema=None) as batch_op:
        batch_op.alter_column('creation_date',
               existing_type=postgresql.TIMESTAMP(),
               nullable=True)

    with op.batch_alter_table('users_data_export', schema=None) as batch_op:
        batch_op.alter_column('user_id',
               existing_type=sa.INTEGER(),
               nullable=True)

    with op.batch_alter_table('reports', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=True)

    with op.batch_alter_table('report_comments', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=True)

    with op.batch_alter_table('report_actions', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=True)

    with op.batch_alter_table('records', schema=None) as batch_op:
        batch_op.alter_column('record_type',
               existing_type=postgresql.ENUM('AS', 'FD', 'LD', 'MS', 'HA', name='record_types'),
               nullable=True)

    with op.batch_alter_table('notifications', schema=None) as batch_op:
        batch_op.alter_column('to_user_id',
               existing_type=sa.INTEGER(),
               nullable=True)
        batch_op.alter_column('from_user_id',
               existing_type=sa.INTEGER(),
               nullable=True)

    with op.batch_alter_table('equipments', schema=None) as batch_op:
        batch_op.alter_column('total_distance',
               existing_type=sa.NUMERIC(precision=10, scale=3),
               nullable=True,
               existing_server_default=sa.text('0.0'))
        batch_op.alter_column('creation_date',
               existing_type=postgresql.TIMESTAMP(),
               nullable=True)
        batch_op.alter_column('equipment_type_id',
               existing_type=sa.INTEGER(),
               nullable=True)

    with op.batch_alter_table('comments', schema=None) as batch_op:
        batch_op.alter_column('created_at',
               existing_type=postgresql.TIMESTAMP(),
               nullable=True)

    with op.batch_alter_table('blocked_users', schema=None) as batch_op:
        batch_op.alter_column('by_user_id',
               existing_type=sa.INTEGER(),
               nullable=True)
        batch_op.alter_column('user_id',
               existing_type=sa.INTEGER(),
               nullable=True)

    # ### end Alembic commands ###
