# Release 0.8.20

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.11` to `0.8.20`


### General
The `cloud_watch` AWS log aggregator, is now officially awesome. It provides a fairly sophisticated way of both doing broad scanning and deep dives on individual streams. Please see our [Cloud Watch](../../cloudwatch/index.md) documentation.

The View classes have finished their refactoring. The 'read' class `View()` can be constructed either directly or with the `ds/fs.view("display")` methods. See [Views](../../api_classes/views.md) for more details. There also a set of classes for constructing views, please see [View Overview](../../core_classes/views/overview.md)

### API Changes

- **Table Name attribute**
    
    The `table_name` attribute/property has been replaced with just `table`

	```
	ds.table_name -> ds.table
	fs.table_name -> fs.table
	view.table_name -> view.table
	```
	
- **Endpoint Confusion Matrix**
    
    The `endpoint` class had a method called `confusion_matrix()` this has been renamed to the more descriptive `generate_confusion_matrix()`. **Note:** The model method, of the same name, has NOT changed.
    
    ```
    end.confusion_matrix() -> end.generate_confusion_matrix()
    model.confusion_matrix() == no change
    ``` 
	
### Bug Fixes
**Fixed:** There was a corner case where if you had the following sequence:

- New FeatureSet without a training view
- Created a traiing view (like with `set_training_holdouts()` 
- Immediately query/pull from the FS training view

The corner case was a race-condition where the FeatureSet would not 'know' that a training view was already there and would create a default training view.
 
### Improvements
The log messages that you receive on a plugin validation failure should now be more distinguishable and more informative. They will look like this and in some cases even tell you the line to look at.

```
ERROR Plugin 'MyPlugin' failed validation:
ERROR 	 File: ../workbench_plugins/components/my_plugin.py
ERROR 	 Class: MyPlugin
ERROR 	 Details: my_plugin.py (line 35): Incorrect return type for update_properties (expected list, got Figure)
```

### Internal API Changes
In theory these API should not affect end user of the Workbench API but are documented here for completeness.

- **Artifact Name Validation**
  
   The internal method used by Artifact subclasses has changed names from `ensure_valid_name` to `is_name_valid`, we've also introduced an optional argument to turn on/off lowercase enforcement, this will be used later when we support uppercase for models, endpoints, and graphs.

## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


