# Release 0.8.29

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.27` to `0.8.29`


### General
**Locking AWS Model Training Image:** AWS will randomly update the images associated with training and model registration. In particular the SKLearn Estimator has been updated into a non-working state for our use cases. So for both training and registration we're now explicitly specifying the image that we want to use.

   ```
    self.estimator = SKLearn(
        ...
        framework_version="1.2-1",
        image_uri=image,  # New
    )
   ```


### API Changes

- **delete() --> class.delete(name)**
    
    We've changed the API for deleting artifacts in AWS (DataSource, FeatureSet, etc). This is part of our efforts to minimize race-conditions when objects are deleted. 
    
    ```
    my_model = Model("xyz")  # Creating object
    my_model.delete()        # just to delete
    
    <Now just one line>
    Model.delete("xyz")      # Delete
    ```
	
### Minor Improvements
**Bulk Delete:**
Added a Bulk Delete utility

```
from workbench.utils.bulk_utils import bulk_delete

delete_list = [("DataSource", "abc"), ("FeatureSet", "abc_features")]
bulk_delete(delete_list)
```

## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


