# Release 0.8.36

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.35` to `0.8.36`


### General
**Fast Inference:** The current inference method for endpoints provides error handling, metrics calculations and capture mechanics. There are use cases where the inference needs to happen as fast as possible without all the additional features. So we've added a `fast_inference()` method that streamlines the calls to the endpoint.

```
end = Endpoint("my_endpoint")
end.inference(df)  # Metrics, Capture, Error Handling
Wall time: 5.07 s

end.fast_inference(df)  # No frills, but Fast!
Wall time: 308 ms
```

### API Changes
None
	
### Improvements/Fixes
**Version Update Check:**
Added functionality that checks the current Workbench version against the latest released and gives a log message for update available.

**ROCAUC modifications:** Functionality now includes 'per label' rocauc calculation along with label order and alignment from previous versions.

## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.35...v0.8.36" target="_blank">Code Diff v0.8.35 --> v0.8.36</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***What’s a cow’s best subject in school?
    ......Cow-culus.***

## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


