# Release 0.8.42

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.39` to `0.8.42`


## General
Artifact deletion got a substantial overhaul. The 4 main classes received internal code changes for how they get deleted. Specifically deletion is now handled via a class method that allows an artifact to be delteed without instantiating an object. The API for deletion is actually more flexible now, please see API Changes below.

## API Changes
**Artifact Deletion**

The API for Artifact deletion is more flexible, if you already have an instantiated object, you can simply call `delete()` on it. If you're deleting an object in bulk/batch mode, you can call the class method `managed_delete()`, see code example below.

```
fs = FeatureSet("my_fs")
fs.delete()                        # Used for notebooks, scripts, etc.. 
OR
FeatureSet.managed_delete("my_fs") # Bulk/batch/internal use

<Same API for DataSources, Models, and Endpoints>
```
**Note:** Internally these use the **same** functionality, the dual API is simply for ease-of-use.

	
## Improvements/Fixes
**Race Conditions**

In theory, the changes to a **class** based delete will reduce race conditions where an object would try to create itself (just to be deleted) and the AWS Service Broker was encountering partially created (or partially deleted objects) and would barf error messages.

**Slightly Better Throttling Logic**

The AWS Throttles have been 'tuned' a bit to back off a bit faster and also not retry the list_tags request when the ARN isn't found.

## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.39...v0.8.42" target="_blank">Code Diff v0.8.39 --> v0.8.42</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***That feeling like you’ve done this before?
      .... Deja-moo***

## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


