# Release 0.8.6

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines. We've also fixed various corner cases mostly around 'half constructed' AWS artifacts (models/endpoints).



### Additional Functionality
- View Support (phase 1)
- CloudWatch (phase 1)
- Exception Log Forwarding [Exception Handling](../../glue/index.md#exception-log-forwarding)
- Lambda Layers [Workbench Lambda Layers](../../lambda_layer/index.md)
- Better Docs for Deploying Plugins [Deploying Plugins](../../admin/dashboard_s3_plugins.md)

### Issues Addressed
- **Model to Endpoint under AWS Throttle**

    A corner case where the `to_endpoint()` method would fail when not 'knowing' the model input. This happened when AWS was throttling responses and the `get_input()` of the Endpoint returned `unknown` which caused a `NoneType` error when using the 'unknown' model.
  
- **Empty Model Package Groups**

    There are cases where customers might construct a Model Package Group (MPG) container and not put any Model Packages in that Group. Workbench has assumed that all MPGs would have at least one model package. The current 'support' for empty MPGs treats it as an error condition but the API tries to accommodate the condition and will properly display the model group. The group will indicate that it's 'empty' and provides an alert health icons.
    
## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


