# Contributing to Brahe

Thank you for your interest in contributing to Brahe! We welcome contributions from everyone—whether you're improving documentation, fixing bugs, or adding new features. We are building software to help everyone on this planet explore the universe. We encourage you to bring your unique perspective to help make us stronger. We appreciate contributions from everyone, no prior space experience is needed to participate.

Checkout the main documentation for the [Contributing Guidelines](https://duncaneddy.github.io/brahe/contributing.html) and [Code of Conduct](https://duncaneddy.github.io/brahe/code_of_conduct.html).

## How you can contribute  

You can contribute in many ways, including:  
- Reporting bugs or issues.  
- Suggesting enhancements or new features.  
- Writing or improving documentation or tutorials.  
- Adding or improving tests.  
- Reviewing other contributors’ pull requests.

## Getting Started

First, check out the development guidelines in the [developer guidelines](https://duncaneddy.github.io/brahe/developer_guidelines.html) for setting up your development environment, running tests, and the development workflow for implementing new features or fixing bugs.

### Workflow

1. Fork the repository on GitHub.
2. Clone your fork locally: `git clone https://github.com/YOUR_USERNAME/brahe.git`
3. Create a new branch for your changes: `git checkout -b feature/your-feature-name`
4. Make your changes and commit them with clear, descriptive messages.
5. Push your changes to your fork: `git push origin feature/your-feature-name`
6. Open a pull request against the main branch of the upstream repository.
7. A maintainer will review your contribution; you may be asked to make changes.
8. After approval and CI passing, your pull request will be merged.

## Code Style & Testing

- Follow the project’s style guidelines (e.g., linting, formatting).
- Include tests for new functionality, and ensure existing tests pass.
- Ensure that your changes do not break existing behaviour unless they are intentional, documented, well-motivated, complete, and reviewed. We don't break things without a solution.

## Communication & Etiquette

- Please review the [Code of Conduct](https://duncaneddy.github.io/brahe/code_of_conduct.html) to understand the expected behaviour in our community.
- If you’re planning a large or complex change, consider opening an issue first to discuss design and get early feedback.
- Be responsive to review comments. If you need time, it’s okay to say so.
- Respect the maintainers’ decision. If they decline your change, you’re free to discuss politely or move on.

## License & Rights

By submitting a pull request, you agree that your contribution will be available under the project's [MIT License](https://duncaneddy.github.io/brahe/license.html) and you grant the maintainers the right to apply any necessary changes (e.g., rebase, squash) before merging.

## Thank You

We appreciate your interest and contribution. Together we build something better!