"use strict";(self.webpackChunk_mlflow_mlflow=self.webpackChunk_mlflow_mlflow||[]).push([[4862],{51499:function(e,t,o){var a=o(90260),i=o(5153)({editType:"none",description:"Sets the default hover label font used by all traces on the graph."});i.family.dflt=a.HOVERFONT,i.size.dflt=a.HOVERFONTSIZE,e.exports={clickmode:{valType:"flaglist",flags:["event","select"],dflt:"event",editType:"plot",extras:["none"],description:["Determines the mode of single click interactions.","*event* is the default value and emits the `plotly_click`","event. In addition this mode emits the `plotly_selected` event","in drag modes *lasso* and *select*, but with no event data attached","(kept for compatibility reasons).","The *select* flag enables selecting single","data points via click. This mode also supports persistent selections,","meaning that pressing Shift while clicking, adds to / subtracts from an","existing selection. *select* with `hovermode`: *x* can be confusing, consider","explicitly setting `hovermode`: *closest* when using this feature.","Selection events are sent accordingly as long as *event* flag is set as well.","When the *event* flag is missing, `plotly_click` and `plotly_selected`","events are not fired."].join(" ")},dragmode:{valType:"enumerated",values:["zoom","pan","select","lasso","drawclosedpath","drawopenpath","drawline","drawrect","drawcircle","orbit","turntable",!1],dflt:"zoom",editType:"modebar",description:["Determines the mode of drag interactions.","*select* and *lasso* apply only to scatter traces with","markers or text. *orbit* and *turntable* apply only to","3D scenes."].join(" ")},hovermode:{valType:"enumerated",values:["x","y","closest",!1,"x unified","y unified"],dflt:"closest",editType:"modebar",description:["Determines the mode of hover interactions.","If *closest*, a single hoverlabel will appear","for the *closest* point within the `hoverdistance`.","If *x* (or *y*), multiple hoverlabels will appear for multiple points","at the *closest* x- (or y-) coordinate within the `hoverdistance`,","with the caveat that no more than one hoverlabel will appear per trace.","If *x unified* (or *y unified*), a single hoverlabel will appear","multiple points at the closest x- (or y-) coordinate within the `hoverdistance`","with the caveat that no more than one hoverlabel will appear per trace.","In this mode, spikelines are enabled by default perpendicular to the specified axis.","If false, hover interactions are disabled."].join(" ")},hoverdistance:{valType:"integer",min:-1,dflt:20,editType:"none",description:["Sets the default distance (in pixels) to look for data","to add hover labels (-1 means no cutoff, 0 means no looking for data).","This is only a real distance for hovering on point-like objects,","like scatter points. For area-like objects (bars, scatter fills, etc)","hovering is on inside the area and off outside, but these objects","will not supersede hover on point-like objects in case of conflict."].join(" ")},spikedistance:{valType:"integer",min:-1,dflt:-1,editType:"none",description:["Sets the default distance (in pixels) to look for data to draw","spikelines to (-1 means no cutoff, 0 means no looking for data).","As with hoverdistance, distance does not apply to area-like objects.","In addition, some objects can be hovered on but will not generate","spikelines, such as scatter fills."].join(" ")},hoverlabel:{bgcolor:{valType:"color",editType:"none",description:["Sets the background color of all hover labels on graph"].join(" ")},bordercolor:{valType:"color",editType:"none",description:["Sets the border color of all hover labels on graph."].join(" ")},font:i,align:{valType:"enumerated",values:["left","right","auto"],dflt:"auto",editType:"none",description:["Sets the horizontal alignment of the text content within hover label box.","Has an effect only if the hover label text spans more two or more lines"].join(" ")},namelength:{valType:"integer",min:-1,dflt:15,editType:"none",description:["Sets the default length (in number of characters) of the trace name in","the hover labels for all traces. -1 shows the whole name","regardless of length. 0-3 shows the first 0-3 characters, and","an integer >3 will show the whole name if it is less than that","many characters, but if it is longer, will truncate to","`namelength - 3` characters and add an ellipsis."].join(" ")},editType:"none"},selectdirection:{valType:"enumerated",values:["h","v","d","any"],dflt:"any",description:["When `dragmode` is set to *select*, this limits the selection of the drag to","horizontal, vertical or diagonal. *h* only allows horizontal selection,","*v* only vertical, *d* only diagonal and *any* sets no limit."].join(" "),editType:"none"}}},49580:function(e,t,o){var a=o(47401),i=o(51499),r=o(30337),n=o(94158);e.exports=function(e,t){function o(o,r){return a.coerce(e,t,i,o,r)}r(e,t)&&(o("hoverdistance"),o("spikedistance")),"select"===o("dragmode")&&o("selectdirection");var l=t._has("mapbox"),s=t._has("geo"),d=t._basePlotModules.length;"zoom"===t.dragmode&&((l||s)&&1===d||l&&s&&2===d)&&(t.dragmode="pan"),n(e,t,o)}},51134:function(e,t,o){var a=o(47401),i=o(94158),r=o(51499);e.exports=function(e,t){i(e,t,(function(o,i){return a.coerce(e,t,r,o,i)}))}},85883:function(e,t,o){var a=o(47401),i=o(44790).counter,r=o(16688).u,n=o(56890).idRegex,l=o(92704),s={rows:{valType:"integer",min:1,editType:"plot",description:["The number of rows in the grid. If you provide a 2D `subplots`","array or a `yaxes` array, its length is used as the default.","But it's also possible to have a different length, if you","want to leave a row at the end for non-cartesian subplots."].join(" ")},roworder:{valType:"enumerated",values:["top to bottom","bottom to top"],dflt:"top to bottom",editType:"plot",description:["Is the first row the top or the bottom? Note that columns","are always enumerated from left to right."].join(" ")},columns:{valType:"integer",min:1,editType:"plot",description:["The number of columns in the grid. If you provide a 2D `subplots`","array, the length of its longest row is used as the default.","If you give an `xaxes` array, its length is used as the default.","But it's also possible to have a different length, if you","want to leave a row at the end for non-cartesian subplots."].join(" ")},subplots:{valType:"info_array",freeLength:!0,dimensions:2,items:{valType:"enumerated",values:[i("xy").toString(),""],editType:"plot"},editType:"plot",description:["Used for freeform grids, where some axes may be shared across subplots","but others are not. Each entry should be a cartesian subplot id, like","*xy* or *x3y2*, or ** to leave that cell empty. You may reuse x axes","within the same column, and y axes within the same row.","Non-cartesian subplots and traces that support `domain` can place themselves","in this grid separately using the `gridcell` attribute."].join(" ")},xaxes:{valType:"info_array",freeLength:!0,items:{valType:"enumerated",values:[n.x.toString(),""],editType:"plot"},editType:"plot",description:["Used with `yaxes` when the x and y axes are shared across columns and rows.","Each entry should be an x axis id like *x*, *x2*, etc., or ** to","not put an x axis in that column. Entries other than ** must be unique.","Ignored if `subplots` is present. If missing but `yaxes` is present,","will generate consecutive IDs."].join(" ")},yaxes:{valType:"info_array",freeLength:!0,items:{valType:"enumerated",values:[n.y.toString(),""],editType:"plot"},editType:"plot",description:["Used with `yaxes` when the x and y axes are shared across columns and rows.","Each entry should be an y axis id like *y*, *y2*, etc., or ** to","not put a y axis in that row. Entries other than ** must be unique.","Ignored if `subplots` is present. If missing but `xaxes` is present,","will generate consecutive IDs."].join(" ")},pattern:{valType:"enumerated",values:["independent","coupled"],dflt:"coupled",editType:"plot",description:["If no `subplots`, `xaxes`, or `yaxes` are given but we do have `rows` and `columns`,","we can generate defaults using consecutive axis IDs, in two ways:","*coupled* gives one x axis per column and one y axis per row.","*independent* uses a new xy pair for each cell, left-to-right across each row","then iterating rows according to `roworder`."].join(" ")},xgap:{valType:"number",min:0,max:1,editType:"plot",description:["Horizontal space between grid cells, expressed as a fraction","of the total width available to one cell. Defaults to 0.1","for coupled-axes grids and 0.2 for independent grids."].join(" ")},ygap:{valType:"number",min:0,max:1,editType:"plot",description:["Vertical space between grid cells, expressed as a fraction","of the total height available to one cell. Defaults to 0.1","for coupled-axes grids and 0.3 for independent grids."].join(" ")},domain:r({name:"grid",editType:"plot",noGridCell:!0},{description:["The first and last cells end exactly at the domain","edges, with no grout around the edges."].join(" ")}),xside:{valType:"enumerated",values:["bottom","bottom plot","top plot","top"],dflt:"bottom plot",editType:"plot",description:["Sets where the x axis labels and titles go. *bottom* means","the very bottom of the grid. *bottom plot* is the lowest plot","that each x axis is used in. *top* and *top plot* are similar."].join(" ")},yside:{valType:"enumerated",values:["left","left plot","right plot","right"],dflt:"left plot",editType:"plot",description:["Sets where the y axis labels and titles go. *left* means","the very left edge of the grid. *left plot* is the leftmost plot","that each y axis is used in. *right* and *right plot* are similar."].join(" ")},editType:"plot"};function d(e,t,o){var a=t[o+"axes"],i=Object.keys((e._splomAxes||{})[o]||{});return Array.isArray(a)?a:i.length?i:void 0}function c(e,t,o,a,i,r){var n=t(e+"gap",o),l=t("domain."+e);t(e+"side",a);for(var s=new Array(i),d=l[0],c=(l[1]-d)/(i-n),h=c*(1-n),u=0;u<i;u++){var p=d+c*u;s[r?i-1-u:u]=[p,p+h]}return s}function h(e,t,o,a,i){var r,n=new Array(o);function l(e,o){-1!==t.indexOf(o)&&void 0===a[o]?(n[e]=o,a[o]=e):n[e]=""}if(Array.isArray(e))for(r=0;r<o;r++)l(r,e[r]);else for(l(0,i),r=1;r<o;r++)l(r,i+(r+1));return n}e.exports={moduleType:"component",name:"grid",schema:{layout:{grid:s}},layoutAttributes:s,sizeDefaults:function(e,t){var o=e.grid||{},i=d(t,o,"x"),r=d(t,o,"y");if(e.grid||i||r){var n,h,u=Array.isArray(o.subplots)&&Array.isArray(o.subplots[0]),p=Array.isArray(i),f=Array.isArray(r),g=p&&i!==o.xaxes&&f&&r!==o.yaxes;u?(n=o.subplots.length,h=o.subplots[0].length):(f&&(n=r.length),p&&(h=i.length));var m=l.newContainer(t,"grid"),v=k("rows",n),y=k("columns",h);if(v*y>1){if(!u&&!p&&!f)"independent"===k("pattern")&&(u=!0);m._hasSubplotGrid=u;var b,x,w="top to bottom"===k("roworder"),_=u?.2:.1,T=u?.3:.1;g&&t._splomGridDflt&&(b=t._splomGridDflt.xside,x=t._splomGridDflt.yside),m._domains={x:c("x",k,_,b,y),y:c("y",k,T,x,v,w)}}else delete t.grid}function k(e,t){return a.coerce(o,m,s,e,t)}},contentDefaults:function(e,t){var o=t.grid;if(o&&o._domains){var a,i,r,n,l,s,c,u=e.grid||{},p=t._subplots,f=o._hasSubplotGrid,g=o.rows,m=o.columns,v="independent"===o.pattern,y=o._axisMap={};if(f){var b=u.subplots||[];s=o.subplots=new Array(g);var x=1;for(a=0;a<g;a++){var w=s[a]=new Array(m),_=b[a]||[];for(i=0;i<m;i++)if(v?(l=1===x?"xy":"x"+x+"y"+x,x++):l=_[i],w[i]="",-1!==p.cartesian.indexOf(l)){if(c=l.indexOf("y"),r=l.slice(0,c),n=l.slice(c),void 0!==y[r]&&y[r]!==i||void 0!==y[n]&&y[n]!==a)continue;w[i]=l,y[r]=i,y[n]=a}}}else{var T=d(t,u,"x"),k=d(t,u,"y");o.xaxes=h(T,p.xaxis,m,y,"x"),o.yaxes=h(k,p.yaxis,g,y,"y")}var A=o._anchors={},z="top to bottom"===o.roworder;for(var S in y){var M,C,I,L=S.charAt(0),D=o[L+"side"];if(D.length<8)A[S]="free";else if("x"===L){if("t"===D.charAt(0)===z?(M=0,C=1,I=g):(M=g-1,C=-1,I=-1),f){var B=y[S];for(a=M;a!==I;a+=C)if((l=s[a][B])&&(c=l.indexOf("y"),l.slice(0,c)===S)){A[S]=l.slice(c);break}}else for(a=M;a!==I;a+=C)if(n=o.yaxes[a],-1!==p.cartesian.indexOf(S+n)){A[S]=n;break}}else if("l"===D.charAt(0)?(M=0,C=1,I=m):(M=m-1,C=-1,I=-1),f){var H=y[S];for(a=M;a!==I;a+=C)if((l=s[H][a])&&(c=l.indexOf("y"),l.slice(c)===S)){A[S]=l.slice(0,c);break}}else for(a=M;a!==I;a+=C)if(r=o.xaxes[a],-1!==p.cartesian.indexOf(r+S)){A[S]=r;break}}}}}},4860:function(e,t,o){var a=o(56890),i=o(92704).templatedArray,r=o(24729);e.exports=i("image",{visible:{valType:"boolean",dflt:!0,editType:"arraydraw",description:["Determines whether or not this image is visible."].join(" ")},source:{valType:"string",editType:"arraydraw",description:["Specifies the URL of the image to be used.","The URL must be accessible from the domain where the","plot code is run, and can be either relative or absolute."].join(" ")},layer:{valType:"enumerated",values:["below","above"],dflt:"above",editType:"arraydraw",description:["Specifies whether images are drawn below or above traces.","When `xref` and `yref` are both set to `paper`,","image is drawn below the entire plot area."].join(" ")},sizex:{valType:"number",dflt:0,editType:"arraydraw",description:["Sets the image container size horizontally.","The image will be sized based on the `position` value.","When `xref` is set to `paper`, units are sized relative","to the plot width.","When `xref` ends with ` domain`, units are sized relative","to the axis width."].join(" ")},sizey:{valType:"number",dflt:0,editType:"arraydraw",description:["Sets the image container size vertically.","The image will be sized based on the `position` value.","When `yref` is set to `paper`, units are sized relative","to the plot height.","When `yref` ends with ` domain`, units are sized relative","to the axis height."].join(" ")},sizing:{valType:"enumerated",values:["fill","contain","stretch"],dflt:"contain",editType:"arraydraw",description:["Specifies which dimension of the image to constrain."].join(" ")},opacity:{valType:"number",min:0,max:1,dflt:1,editType:"arraydraw",description:"Sets the opacity of the image."},x:{valType:"any",dflt:0,editType:"arraydraw",description:["Sets the image's x position.","When `xref` is set to `paper`, units are sized relative","to the plot height.","See `xref` for more info"].join(" ")},y:{valType:"any",dflt:0,editType:"arraydraw",description:["Sets the image's y position.","When `yref` is set to `paper`, units are sized relative","to the plot height.","See `yref` for more info"].join(" ")},xanchor:{valType:"enumerated",values:["left","center","right"],dflt:"left",editType:"arraydraw",description:"Sets the anchor for the x position"},yanchor:{valType:"enumerated",values:["top","middle","bottom"],dflt:"top",editType:"arraydraw",description:"Sets the anchor for the y position."},xref:{valType:"enumerated",values:["paper",a.idRegex.x.toString()],dflt:"paper",editType:"arraydraw",description:["Sets the images's x coordinate axis.",r.axisRefDescription("x","left","right")].join(" ")},yref:{valType:"enumerated",values:["paper",a.idRegex.y.toString()],dflt:"paper",editType:"arraydraw",description:["Sets the images's y coordinate axis.",r.axisRefDescription("y","bottom","top")].join(" ")},editType:"arraydraw"})},92979:function(e,t,o){var a=o(83491),i=o(1379);e.exports=function(e,t,o,r){t=t||{};var n="log"===o&&"linear"===t.type,l="linear"===o&&"log"===t.type;if(n||l)for(var s,d,c=e._fullLayout.images,h=t._id.charAt(0),u=0;u<c.length;u++)if(d="images["+u+"].",(s=c[u])[h+"ref"]===t._id){var p=s[h],f=s["size"+h],g=null,m=null;if(n){g=i(p,t.range);var v=f/Math.pow(10,g)/2;m=2*Math.log(v+Math.sqrt(1+v*v))/Math.LN10}else m=(g=Math.pow(10,p))*(Math.pow(10,f/2)-Math.pow(10,-f/2));a(g)?a(m)||(m=null):(g=null,m=null),r(d+h,g),r(d+"size"+h,m)}}},71179:function(e,t,o){var a=o(47401),i=o(37762),r=o(26800),n=o(4860);function l(e,t,o){function r(o,i){return a.coerce(e,t,n,o,i)}var l=r("source");if(!r("visible",!!l))return t;r("layer"),r("xanchor"),r("yanchor"),r("sizex"),r("sizey"),r("sizing"),r("opacity");for(var s={_fullLayout:o},d=["x","y"],c=0;c<2;c++){var h=d[c],u=i.coerceRef(e,t,s,h,"paper",void 0);if("paper"!==u)i.getFromId(s,u)._imgIndices.push(t._index);i.coercePosition(t,s,r,u,h,0)}return t}e.exports=function(e,t){r(e,t,{name:"images",handleItemDefaults:l})}},63459:function(e,t,o){var a=o(62258),i=o(41707),r=o(37762),n=o(77063),l=o(6412);e.exports=function(e){var t,o,s=e._fullLayout,d=[],c={},h=[];for(o=0;o<s.images.length;o++){var u=s.images[o];if(u.visible)if("below"===u.layer&&"paper"!==u.xref&&"paper"!==u.yref){t=n.ref2id(u.xref)+n.ref2id(u.yref);var p=s._plots[t];if(!p){h.push(u);continue}p.mainplot&&(t=p.mainplot.id),c[t]||(c[t]=[]),c[t].push(u)}else"above"===u.layer?d.push(u):h.push(u)}var f={left:{sizing:"xMin",offset:0},center:{sizing:"xMid",offset:-.5},right:{sizing:"xMax",offset:-1}},g={top:{sizing:"YMin",offset:0},middle:{sizing:"YMid",offset:-.5},bottom:{sizing:"YMax",offset:-1}};function m(t){var o=a.select(this);if(this._imgSrc!==t.source)if(o.attr("xmlns",l.svg),t.source&&"data:"===t.source.slice(0,5))o.attr("xlink:href",t.source),this._imgSrc=t.source;else{var i=new Promise(function(e){var a=new Image;function i(){o.remove(),e()}this.img=a,a.setAttribute("crossOrigin","anonymous"),a.onerror=i,a.onload=function(){var t=document.createElement("canvas");t.width=this.width,t.height=this.height,t.getContext("2d").drawImage(this,0,0);var a=t.toDataURL("image/png");o.attr("xlink:href",a),e()},o.on("error",i),a.src=t.source,this._imgSrc=t.source}.bind(this));e._promises.push(i)}}function v(t){var o,n,l=a.select(this),d=r.getFromId(e,t.xref),c=r.getFromId(e,t.yref),h="domain"===r.getRefType(t.xref),u="domain"===r.getRefType(t.yref),p=s._size;o=void 0!==d?"string"===typeof t.xref&&h?d._length*t.sizex:Math.abs(d.l2p(t.sizex)-d.l2p(0)):t.sizex*p.w,n=void 0!==c?"string"===typeof t.yref&&u?c._length*t.sizey:Math.abs(c.l2p(t.sizey)-c.l2p(0)):t.sizey*p.h;var m,v,y=o*f[t.xanchor].offset,b=n*g[t.yanchor].offset,x=f[t.xanchor].sizing+g[t.yanchor].sizing;switch(m=void 0!==d?"string"===typeof t.xref&&h?d._length*t.x+d._offset:d.r2p(t.x)+d._offset:t.x*p.w+p.l,m+=y,v=void 0!==c?"string"===typeof t.yref&&u?c._length*(1-t.y)+c._offset:c.r2p(t.y)+c._offset:p.h-t.y*p.h+p.t,v+=b,t.sizing){case"fill":x+=" slice";break;case"stretch":x="none"}l.attr({x:m,y:v,width:o,height:n,preserveAspectRatio:x,opacity:t.opacity});var w=(d&&"domain"!==r.getRefType(t.xref)?d._id:"")+(c&&"domain"!==r.getRefType(t.yref)?c._id:"");i.setClipUrl(l,w?"clip"+s._uid+w:null,e)}var y=s._imageLowerLayer.selectAll("image").data(h),b=s._imageUpperLayer.selectAll("image").data(d);y.enter().append("image"),b.enter().append("image"),y.exit().remove(),b.exit().remove(),y.each((function(e){m.bind(this)(e),v.bind(this)(e)})),b.each((function(e){m.bind(this)(e),v.bind(this)(e)}));var x=Object.keys(s._plots);for(o=0;o<x.length;o++){t=x[o];var w=s._plots[t];if(w.imagelayer){var _=w.imagelayer.selectAll("image").data(c[t]||[]);_.enter().append("image"),_.exit().remove(),_.each((function(e){m.bind(this)(e),v.bind(this)(e)}))}}}},13041:function(e,t,o){e.exports={moduleType:"component",name:"images",layoutAttributes:o(4860),supplyLayoutDefaults:o(71179),includeBasePlot:o(11698)("images"),draw:o(63459),convertCoords:o(92979)}},29941:function(e,t,o){var a=o(5153),i=o(62405);e.exports={bgcolor:{valType:"color",editType:"legend",description:["Sets the legend background color.","Defaults to `layout.paper_bgcolor`."].join(" ")},bordercolor:{valType:"color",dflt:i.defaultLine,editType:"legend",description:"Sets the color of the border enclosing the legend."},borderwidth:{valType:"number",min:0,dflt:0,editType:"legend",description:"Sets the width (in px) of the border enclosing the legend."},font:a({editType:"legend",description:"Sets the font used to text the legend items."}),orientation:{valType:"enumerated",values:["v","h"],dflt:"v",editType:"legend",description:"Sets the orientation of the legend."},traceorder:{valType:"flaglist",flags:["reversed","grouped"],extras:["normal"],editType:"legend",description:["Determines the order at which the legend items are displayed.","If *normal*, the items are displayed top-to-bottom in the same","order as the input data.","If *reversed*, the items are displayed in the opposite order","as *normal*.","If *grouped*, the items are displayed in groups","(when a trace `legendgroup` is provided).","if *grouped+reversed*, the items are displayed in the opposite order","as *grouped*."].join(" ")},tracegroupgap:{valType:"number",min:0,dflt:10,editType:"legend",description:["Sets the amount of vertical space (in px) between legend groups."].join(" ")},itemsizing:{valType:"enumerated",values:["trace","constant"],dflt:"trace",editType:"legend",description:["Determines if the legend items symbols scale with their corresponding *trace* attributes","or remain *constant* independent of the symbol size on the graph."].join(" ")},itemwidth:{valType:"number",min:30,dflt:30,editType:"legend",description:"Sets the width (in px) of the legend item symbols (the part other than the title.text)."},itemclick:{valType:"enumerated",values:["toggle","toggleothers",!1],dflt:"toggle",editType:"legend",description:["Determines the behavior on legend item click.","*toggle* toggles the visibility of the item clicked on the graph.","*toggleothers* makes the clicked item the sole visible item on the graph.","*false* disables legend item click interactions."].join(" ")},itemdoubleclick:{valType:"enumerated",values:["toggle","toggleothers",!1],dflt:"toggleothers",editType:"legend",description:["Determines the behavior on legend item double-click.","*toggle* toggles the visibility of the item clicked on the graph.","*toggleothers* makes the clicked item the sole visible item on the graph.","*false* disables legend item double-click interactions."].join(" ")},groupclick:{valType:"enumerated",values:["toggleitem","togglegroup"],dflt:"togglegroup",editType:"legend",description:["Determines the behavior on legend group item click.","*toggleitem* toggles the visibility of the individual item clicked on the graph.","*togglegroup* toggles the visibility of all items in the same legendgroup as the item clicked on the graph."].join(" ")},x:{valType:"number",min:-2,max:3,editType:"legend",description:["Sets the x position (in normalized coordinates) of the legend.","Defaults to *1.02* for vertical legends and","defaults to *0* for horizontal legends."].join(" ")},xanchor:{valType:"enumerated",values:["auto","left","center","right"],dflt:"left",editType:"legend",description:["Sets the legend's horizontal position anchor.","This anchor binds the `x` position to the *left*, *center*","or *right* of the legend.","Value *auto* anchors legends to the right for `x` values greater than or equal to 2/3,","anchors legends to the left for `x` values less than or equal to 1/3 and","anchors legends with respect to their center otherwise."].join(" ")},y:{valType:"number",min:-2,max:3,editType:"legend",description:["Sets the y position (in normalized coordinates) of the legend.","Defaults to *1* for vertical legends,","defaults to *-0.1* for horizontal legends on graphs w/o range sliders and","defaults to *1.1* for horizontal legends on graph with one or multiple range sliders."].join(" ")},yanchor:{valType:"enumerated",values:["auto","top","middle","bottom"],editType:"legend",description:["Sets the legend's vertical position anchor","This anchor binds the `y` position to the *top*, *middle*","or *bottom* of the legend.","Value *auto* anchors legends at their bottom for `y` values less than or equal to 1/3,","anchors legends to at their top for `y` values greater than or equal to 2/3 and","anchors legends with respect to their middle otherwise."].join(" ")},uirevision:{valType:"any",editType:"none",description:["Controls persistence of legend-driven changes in trace and pie label","visibility. Defaults to `layout.uirevision`."].join(" ")},valign:{valType:"enumerated",values:["top","middle","bottom"],dflt:"middle",editType:"legend",description:["Sets the vertical alignment of the symbols with respect to their associated text."].join(" ")},title:{text:{valType:"string",dflt:"",editType:"legend",description:["Sets the title of the legend."].join(" ")},font:a({editType:"legend",description:["Sets this legend's title font.","Defaults to `legend.font` with its size increased about 20%."].join(" ")}),side:{valType:"enumerated",values:["top","left","top left"],editType:"legend",description:["Determines the location of legend's title","with respect to the legend items.","Defaulted to *top* with `orientation` is *h*.","Defaulted to *left* with `orientation` is *v*.","The *top left* options could be used to expand","legend area in both x and y sides."].join(" ")},editType:"legend"},editType:"legend"}},9663:function(e){e.exports={scrollBarWidth:6,scrollBarMinHeight:20,scrollBarColor:"#808BA4",scrollBarMargin:4,scrollBarEnterAttrs:{rx:20,ry:3,width:0,height:0},titlePad:2,itemGap:5}},52738:function(e,t,o){var a=o(62282),i=o(47401),r=o(92704),n=o(29941),l=o(19744),s=o(91535);e.exports=function(e,t,o){for(var d=e.legend||{},c=0,h=!1,u="normal",p=0;p<o.length;p++){var f=o[p];f.visible&&((f.showlegend||f._dfltShowLegend&&!(f._module&&f._module.attributes&&f._module.attributes.showlegend&&!1===f._module.attributes.showlegend.dflt))&&(c++,f.showlegend&&(h=!0,(a.traceIs(f,"pie-like")||!0===f._input.showlegend)&&c++)),(a.traceIs(f,"bar")&&"stack"===t.barmode||-1!==["tonextx","tonexty"].indexOf(f.fill))&&(u=s.isGrouped({traceorder:u})?"grouped+reversed":"reversed"),void 0!==f.legendgroup&&""!==f.legendgroup&&(u=s.isReversed({traceorder:u})?"reversed+grouped":"grouped"))}var g=i.coerce(e,t,l,"showlegend",h&&c>1);if(!1!==g||d.uirevision){var m=r.newContainer(t,"legend");if(T("uirevision",t.uirevision),!1!==g){T("bgcolor",t.paper_bgcolor),T("bordercolor"),T("borderwidth");var v,y,b,x=i.coerceFont(T,"font",t.font),w="h"===T("orientation");if(w?(v=0,a.getComponentMethod("rangeslider","isVisible")(e.xaxis)?(y=1.1,b="bottom"):(y=-.1,b="top")):(v=1.02,y=1,b="auto"),T("traceorder",u),s.isGrouped(t.legend)&&T("tracegroupgap"),T("itemsizing"),T("itemwidth"),T("itemclick"),T("itemdoubleclick"),T("groupclick"),T("x",v),T("xanchor"),T("y",y),T("yanchor",b),T("valign"),i.noneOrAll(d,m,["x","y"]),T("title.text")){T("title.side",w?"left":"top");var _=i.extendFlat({},x,{size:i.bigFont(x.size)});i.coerceFont(T,"title.font",_)}}}function T(e,t){return i.coerce(d,m,n,e,t)}}},97990:function(e,t,o){var a=o(62258),i=o(47401),r=o(35722),n=o(62282),l=o(19428),s=o(52783),d=o(41707),c=o(31454),h=o(43995),u=o(95749),p=o(9663),f=o(60482),g=f.LINE_SPACING,m=f.FROM_TL,v=f.FROM_BR,y=o(34179),b=o(27799),x=o(91535),w=1;function _(e,t,o,a,i){var r=o.data()[0][0].trace,s={event:i,node:o.node(),curveNumber:r.index,expandedIndex:r._expandedIndex,data:e.data,layout:e.layout,frames:e._transitionData._frames,config:e._context,fullData:e._fullData,fullLayout:e._fullLayout};if(r._group&&(s.group=r._group),n.traceIs(r,"pie-like")&&(s.label=o.datum()[0].label),!1!==l.triggerHandler(e,"plotly_legendclick",s))if(1===a)t._clickTimeout=setTimeout((function(){e._fullLayout&&u(o,e,a)}),e._context.doubleClickDelay);else if(2===a){t._clickTimeout&&clearTimeout(t._clickTimeout),e._legendMouseDownTime=0,!1!==l.triggerHandler(e,"plotly_legenddoubleclick",s)&&u(o,e,a)}}function T(e,t,o){var a,r,l=e.data()[0][0],s=l.trace,c=n.traceIs(s,"pie-like"),u=!o._inHover&&t._context.edits.legendText&&!c,f=o._maxNameLength;l.groupTitle?(a=l.groupTitle.text,r=l.groupTitle.font):(r=o.font,o.entries?a=l.text:(a=c?l.label:s.name,s._meta&&(a=i.templateString(a,s._meta))));var g=i.ensureSingle(e,"text","legendtext");g.attr("text-anchor","start").call(d.font,r).text(u?k(a,f):a);var m=o.itemwidth+2*p.itemGap;h.positionText(g,m,0),u?g.call(h.makeEditable,{gd:t,text:a}).call(z,e,t,o).on("edit",(function(a){this.text(k(a,f)).call(z,e,t,o);var r=l.trace._fullInput||{},d={};if(n.hasTransform(r,"groupby")){var c=n.getTransformIndices(r,"groupby"),h=c[c.length-1],u=i.keyedContainer(r,"transforms["+h+"].styles","target","value.name");u.set(l.trace._group,a),d=u.constructUpdate()}else d.name=a;return n.call("_guiRestyle",t,d,s.index)})):z(g,e,t,o)}function k(e,t){var o=Math.max(4,t);if(e&&e.trim().length>=o/2)return e;for(var a=o-(e=e||"").length;a>0;a--)e+=" ";return e}function A(e,t){var o,r=t._context.doubleClickDelay,n=1,l=i.ensureSingle(e,"rect","legendtoggle",(function(e){t._context.staticPlot||e.style("cursor","pointer").attr("pointer-events","all"),e.call(c.fill,"rgba(0,0,0,0)")}));t._context.staticPlot||(l.on("mousedown",(function(){(o=(new Date).getTime())-t._legendMouseDownTime<r?n+=1:(n=1,t._legendMouseDownTime=o)})),l.on("mouseup",(function(){if(!t._dragged&&!t._editing){var o=t._fullLayout.legend;(new Date).getTime()-t._legendMouseDownTime>r&&(n=Math.max(n-1,1)),_(t,o,e,n,a.event)}})))}function z(e,t,o,a,i){a._inHover&&e.attr("data-notex",!0),h.convertToTspans(e,o,(function(){!function(e,t,o,a){var i=e.data()[0][0];if(!o._inHover&&i&&!i.trace.showlegend)return void e.remove();var r=e.select("g[class*=math-group]"),n=r.node();o||(o=t._fullLayout.legend);var l,s=o.borderwidth;l=a===w?o.title.font:i.groupTitle?i.groupTitle.font:o.font;var c,u,f=l.size*g;if(n){var m=d.bBox(n);c=m.height,u=m.width,a===w?d.setTranslate(r,s,s+.75*c):d.setTranslate(r,0,.25*c)}else{var v=e.select(a===w?".legendtitletext":".legendtext"),y=h.lineCount(v),b=v.node();if(c=f*y,u=b?d.bBox(b).width:0,a===w)"left"===o.title.side&&(u+=2*p.itemGap),h.positionText(v,s+p.titlePad,s+f);else{var x=2*p.itemGap+o.itemwidth;i.groupTitle&&(x=p.itemGap,u-=o.itemwidth),h.positionText(v,x,-f*((y-1)/2-.3))}}a===w?(o._titleWidth=u,o._titleHeight=c):(i.lineHeight=f,i.height=Math.max(c,16)+3,i.width=u)}(t,o,a,i)}))}function S(e){return i.isRightAnchor(e)?"right":i.isCenterAnchor(e)?"center":"left"}function M(e){return i.isBottomAnchor(e)?"bottom":i.isMiddleAnchor(e)?"middle":"top"}e.exports=function(e,t){return t||(t=e._fullLayout.legend||{}),function(e,t){var o,l,h=e._fullLayout,u="legend"+h._uid,f=t._inHover;f?(o=t.layer,u+="-hover"):o=h._infolayer;if(!o)return;e._legendMouseDownTime||(e._legendMouseDownTime=0);if(f){if(!t.entries)return;l=y(t.entries,t)}else{if(!e.calcdata)return;l=h.showlegend&&y(e.calcdata,t)}var g=h.hiddenlabels||[];if(!f&&(!h.showlegend||!l.length))return o.selectAll(".legend").remove(),h._topdefs.select("#"+u).remove(),r.autoMargin(e,"legend");var k=i.ensureSingle(o,"g","legend",(function(e){f||e.attr("pointer-events","all")})),C=i.ensureSingleById(h._topdefs,"clipPath",u,(function(e){e.append("rect")})),I=i.ensureSingle(k,"rect","bg",(function(e){e.attr("shape-rendering","crispEdges")}));I.call(c.stroke,t.bordercolor).call(c.fill,t.bgcolor).style("stroke-width",t.borderwidth+"px");var L=i.ensureSingle(k,"g","scrollbox"),D=t.title;if(t._titleWidth=0,t._titleHeight=0,D.text){var B=i.ensureSingle(L,"text","legendtitletext");B.attr("text-anchor","start").call(d.font,D.font).text(D.text),z(B,L,e,t,w)}else L.selectAll(".legendtitletext").remove();var H=i.ensureSingle(k,"rect","scrollbar",(function(e){e.attr(p.scrollBarEnterAttrs).call(c.fill,p.scrollBarColor)})),R=L.selectAll("g.groups").data(l);R.enter().append("g").attr("class","groups"),R.exit().remove();var j=R.selectAll("g.traces").data(i.identity);j.enter().append("g").attr("class","traces"),j.exit().remove(),j.style("opacity",(function(e){var t=e[0].trace;return n.traceIs(t,"pie-like")?-1!==g.indexOf(e[0].label)?.5:1:"legendonly"===t.visible?.5:1})).each((function(){a.select(this).call(T,e,t)})).call(b,e,t).each((function(){f||a.select(this).call(A,e)})),i.syncOrAsync([r.previousPromises,function(){return function(e,t,o,i){var r=e._fullLayout;i||(i=r.legend);var n=r._size,l=x.isVertical(i),s=x.isGrouped(i),c=i.borderwidth,h=2*c,u=p.itemGap,f=i.itemwidth+2*u,g=2*(c+u),m=M(i),v=i.y<0||0===i.y&&"top"===m,y=i.y>1||1===i.y&&"bottom"===m,b=i.tracegroupgap;i._maxHeight=Math.max(v||y?r.height/2:n.h,30);var w=0;i._width=0,i._height=0;var _=function(e){var t=0,o=0,a=e.title.side;a&&(-1!==a.indexOf("left")&&(t=e._titleWidth),-1!==a.indexOf("top")&&(o=e._titleHeight));return[t,o]}(i);if(l)o.each((function(e){var t=e[0].height;d.setTranslate(this,c+_[0],c+_[1]+i._height+t/2+u),i._height+=t,i._width=Math.max(i._width,e[0].width)})),w=f+i._width,i._width+=u+f+h,i._height+=g,s&&(t.each((function(e,t){d.setTranslate(this,0,t*i.tracegroupgap)})),i._height+=(i._lgroupsLength-1)*i.tracegroupgap);else{var T=S(i),k=i.x<0||0===i.x&&"right"===T,A=i.x>1||1===i.x&&"left"===T,z=y||v,C=r.width/2;i._maxWidth=Math.max(k?z&&"left"===T?n.l+n.w:C:A?z&&"right"===T?n.r+n.w:C:n.w,2*f);var I=0,L=0;o.each((function(e){var t=e[0].width+f;I=Math.max(I,t),L+=t})),w=null;var D=0;if(s){var B=0,H=0,R=0;t.each((function(){var e=0,t=0;a.select(this).selectAll("g.traces").each((function(o){var a=o[0].height;d.setTranslate(this,_[0],_[1]+c+u+a/2+t),t+=a,e=Math.max(e,f+o[0].width)})),B=Math.max(B,t);var o=e+u;o+c+H>i._maxWidth&&(D=Math.max(D,H),H=0,R+=B+b,B=t),d.setTranslate(this,H,R),H+=o})),i._width=Math.max(D,H)+c,i._height=R+B+g}else{var j=o.size(),E=L+h+(j-1)*u<i._maxWidth,O=0,G=0,V=0,Z=0;o.each((function(e){var t=e[0].height,o=f+e[0].width,a=(E?o:I)+u;a+c+G-u>=i._maxWidth&&(D=Math.max(D,Z),G=0,V+=O,i._height+=O,O=0),d.setTranslate(this,_[0]+c+G,_[1]+c+V+t/2+u),Z=G+o+u,G+=a,O=Math.max(O,t)})),E?(i._width=G+h,i._height=O+g):(i._width=Math.max(D,Z)+h,i._height+=O+g)}}i._width=Math.ceil(Math.max(i._width+_[0],i._titleWidth+2*(c+p.titlePad))),i._height=Math.ceil(Math.max(i._height+_[1],i._titleHeight+2*(c+p.itemGap))),i._effHeight=Math.min(i._height,i._maxHeight);var P=e._context.edits,N=P.legendText||P.legendPosition;o.each((function(e){var t=a.select(this).select(".legendtoggle"),o=e[0].height,i=N?f:w||f+e[0].width;l||(i+=u/2),d.setRect(t,0,-o/2,i,o)}))}(e,R,j,t)},function(){if(f||!function(e){var t=e._fullLayout,o=t.legend,a=S(o),i=M(o);return r.autoMargin(e,"legend",{x:o.x,y:o.y,l:o._width*m[a],r:o._width*v[a],b:o._effHeight*v[i],t:o._effHeight*m[i]})}(e)){var l,c,g,y,b=h._size,x=t.borderwidth,w=b.l+b.w*t.x-m[S(t)]*t._width,T=b.t+b.h*(1-t.y)-m[M(t)]*t._effHeight;if(!f&&h.margin.autoexpand){var A=w,z=T;w=i.constrain(w,0,h.width-t._width),T=i.constrain(T,0,h.height-t._effHeight),w!==A&&i.log("Constrain legend.x to make legend fit inside graph"),T!==z&&i.log("Constrain legend.y to make legend fit inside graph")}if(f||d.setTranslate(k,w,T),H.on(".drag",null),k.on("wheel",null),f||t._height<=t._maxHeight||e._context.staticPlot){var D=t._effHeight;f&&(D=t._height),I.attr({width:t._width-x,height:D-x,x:x/2,y:x/2}),d.setTranslate(L,0,0),C.select("rect").attr({width:t._width-2*x,height:D-2*x,x:x,y:x}),d.setClipUrl(L,u,e),d.setRect(H,0,0,0,0),delete t._scrollY}else{var B,R,j,E=Math.max(p.scrollBarMinHeight,t._effHeight*t._effHeight/t._height),O=t._effHeight-E-2*p.scrollBarMargin,G=t._height-t._effHeight,V=O/G,Z=Math.min(t._scrollY||0,G);I.attr({width:t._width-2*x+p.scrollBarWidth+p.scrollBarMargin,height:t._effHeight-x,x:x/2,y:x/2}),C.select("rect").attr({width:t._width-2*x+p.scrollBarWidth+p.scrollBarMargin,height:t._effHeight-2*x,x:x,y:x+Z}),d.setClipUrl(L,u,e),Y(Z,E,V),k.on("wheel",(function(){Y(Z=i.constrain(t._scrollY+a.event.deltaY/O*G,0,G),E,V),0!==Z&&Z!==G&&a.event.preventDefault()}));var P=function(e,t,o){var a=(o-t)/V+e;return i.constrain(a,0,G)},N=function(e,t,o){var a=(t-o)/V+e;return i.constrain(a,0,G)},F=a.behavior.drag().on("dragstart",(function(){var e=a.event.sourceEvent;B="touchstart"===e.type?e.changedTouches[0].clientY:e.clientY,j=Z})).on("drag",(function(){var e=a.event.sourceEvent;2===e.buttons||e.ctrlKey||(R="touchmove"===e.type?e.changedTouches[0].clientY:e.clientY,Y(Z=P(j,B,R),E,V))}));H.call(F);var W=a.behavior.drag().on("dragstart",(function(){var e=a.event.sourceEvent;"touchstart"===e.type&&(B=e.changedTouches[0].clientY,j=Z)})).on("drag",(function(){var e=a.event.sourceEvent;"touchmove"===e.type&&(R=e.changedTouches[0].clientY,Y(Z=N(j,B,R),E,V))}));L.call(W)}if(e._context.edits.legendPosition)k.classed("cursor-move",!0),s.init({element:k.node(),gd:e,prepFn:function(){var e=d.getTranslate(k);g=e.x,y=e.y},moveFn:function(e,o){var a=g+e,i=y+o;d.setTranslate(k,a,i),l=s.align(a,0,b.l,b.l+b.w,t.xanchor),c=s.align(i,0,b.t+b.h,b.t,t.yanchor)},doneFn:function(){void 0!==l&&void 0!==c&&n.call("_guiRelayout",e,{"legend.x":l,"legend.y":c})},clickFn:function(t,a){var i=o.selectAll("g.traces").filter((function(){var e=this.getBoundingClientRect();return a.clientX>=e.left&&a.clientX<=e.right&&a.clientY>=e.top&&a.clientY<=e.bottom}));i.size()>0&&_(e,k,i,t,a)}})}function Y(o,a,i){t._scrollY=e._fullLayout.legend._scrollY=o,d.setTranslate(L,0,-o),d.setRect(H,t._width,p.scrollBarMargin+o*i,p.scrollBarWidth,a),C.select("rect").attr("y",x+o)}}],e)}(e,t)}},34179:function(e,t,o){var a=o(62282),i=o(91535);e.exports=function(e,t){var o,r,n=t._inHover,l=i.isGrouped(t),s=i.isReversed(t),d={},c=[],h=!1,u={},p=0,f=0;function g(e,o){if(""!==e&&i.isGrouped(t))-1===c.indexOf(e)?(c.push(e),h=!0,d[e]=[o]):d[e].push(o);else{var a="~~i"+p;c.push(a),d[a]=[o],p++}}for(o=0;o<e.length;o++){var m=e[o],v=m[0],y=v.trace,b=y.legendgroup;if(n||y.visible&&y.showlegend)if(a.traceIs(y,"pie-like"))for(u[b]||(u[b]={}),r=0;r<m.length;r++){var x=m[r].label;u[b][x]||(g(b,{label:x,color:m[r].color,i:m[r].i,trace:y,pts:m[r].pts}),u[b][x]=!0,f=Math.max(f,(x||"").length))}else g(b,v),f=Math.max(f,(y.name||"").length)}if(!c.length)return[];var w=!h||!l,_=[];for(o=0;o<c.length;o++){var T=d[c[o]];w?_.push(T[0]):_.push(T)}for(w&&(_=[_]),o=0;o<_.length;o++){var k=1/0;for(r=0;r<_[o].length;r++){var A=_[o][r].trace.legendrank;k>A&&(k=A)}_[o][0]._groupMinRank=k,_[o][0]._preGroupSort=o}var z=function(e,t){return e.trace.legendrank-t.trace.legendrank||e._preSort-t._preSort};for(_.forEach((function(e,t){e[0]._preGroupSort=t})),_.sort((function(e,t){return e[0]._groupMinRank-t[0]._groupMinRank||e[0]._preGroupSort-t[0]._preGroupSort})),o=0;o<_.length;o++){_[o].forEach((function(e,t){e._preSort=t})),_[o].sort(z);var S=_[o][0].trace,M=null;for(r=0;r<_[o].length;r++){var C=_[o][r].trace.legendgrouptitle;if(C&&C.text){M=C,n&&(C.font=t._groupTitleFont);break}}if(s&&_[o].reverse(),M){var I=!1;for(r=0;r<_[o].length;r++)if(a.traceIs(_[o][r].trace,"pie-like")){I=!0;break}_[o].unshift({i:-1,groupTitle:M,noClick:I,trace:{showlegend:S.showlegend,legendgroup:S.legendgroup,visible:"toggleitem"===t.groupclick||S.visible}})}for(r=0;r<_[o].length;r++)_[o][r]=[_[o][r]]}return t._lgroupsLength=_.length,t._maxNameLength=f,_}},95749:function(e,t,o){var a=o(47401),i=o(62282),r=!0;e.exports=function(e,t,o){var n=t._fullLayout;if(!t._dragged&&!t._editing){var l,s=n.legend.itemclick,d=n.legend.itemdoubleclick,c=n.legend.groupclick;if(1===o&&"toggle"===s&&"toggleothers"===d&&r&&t.data&&t._context.showTips?(a.notifier(a._(t,"Double-click on legend to isolate one trace"),"long"),r=!1):r=!1,1===o?l=s:2===o&&(l=d),l){var h="togglegroup"===c,u=n.hiddenlabels?n.hiddenlabels.slice():[],p=e.data()[0][0];if(!p.groupTitle||!p.noClick){var f,g,m,v,y,b=t._fullData,x=p.trace,w=x.legendgroup,_={},T=[],k=[],A=[];if(i.traceIs(x,"pie-like")){var z=p.label,S=u.indexOf(z);"toggle"===l?-1===S?u.push(z):u.splice(S,1):"toggleothers"===l&&(u=[],t.calcdata[0].forEach((function(e){z!==e.label&&u.push(e.label)})),t._fullLayout.hiddenlabels&&t._fullLayout.hiddenlabels.length===u.length&&-1===S&&(u=[])),i.call("_guiRelayout",t,"hiddenlabels",u)}else{var M,C=w&&w.length,I=[];if(C)for(f=0;f<b.length;f++)(M=b[f]).visible&&M.legendgroup===w&&I.push(f);if("toggle"===l){var L;switch(x.visible){case!0:L="legendonly";break;case!1:L=!1;break;case"legendonly":L=!0}if(C)if(h)for(f=0;f<b.length;f++)!1!==b[f].visible&&b[f].legendgroup===w&&V(b[f],L);else V(x,L);else V(x,L)}else if("toggleothers"===l){var D,B,H,R,j=!0;for(f=0;f<b.length;f++)if(D=b[f]===x,H=!0!==b[f].showlegend,!D&&!H&&!(B=C&&b[f].legendgroup===w)&&!0===b[f].visible&&!i.traceIs(b[f],"notLegendIsolatable")){j=!1;break}for(f=0;f<b.length;f++)if(!1!==b[f].visible&&!i.traceIs(b[f],"notLegendIsolatable"))switch(x.visible){case"legendonly":V(b[f],!0);break;case!0:R=!!j||"legendonly",D=b[f]===x,H=!0!==b[f].showlegend&&!b[f].legendgroup,B=D||C&&b[f].legendgroup===w,V(b[f],!(!B&&!H)||R)}}for(f=0;f<k.length;f++)if(m=k[f]){var E=m.constructUpdate(),O=Object.keys(E);for(g=0;g<O.length;g++)v=O[g],(_[v]=_[v]||[])[A[f]]=E[v]}for(y=Object.keys(_),f=0;f<y.length;f++)for(v=y[f],g=0;g<T.length;g++)_[v].hasOwnProperty(g)||(_[v][g]=void 0);i.call("_guiRestyle",t,_,T)}}}}function G(e,t,o){var a=T.indexOf(e),i=_[t];return i||(i=_[t]=[]),-1===T.indexOf(e)&&(T.push(e),a=T.length-1),i[a]=o,a}function V(e,t){if(!p.groupTitle||h){var o=e._fullInput;if(i.hasTransform(o,"groupby")){var r=k[o.index];if(!r){var n=i.getTransformIndices(o,"groupby"),l=n[n.length-1];r=a.keyedContainer(o,"transforms["+l+"].styles","target","value.visible"),k[o.index]=r}var s=r.get(e._group);void 0===s&&(s=!0),!1!==s&&r.set(e._group,t),A[o.index]=G(o.index,"visible",!1!==o.visible)}else{var d=!1!==o.visible&&t;G(o.index,"visible",d)}}}}},91535:function(e,t){t.isGrouped=function(e){return-1!==(e.traceorder||"").indexOf("grouped")},t.isVertical=function(e){return"h"!==e.orientation},t.isReversed=function(e){return-1!==(e.traceorder||"").indexOf("reversed")}},22382:function(e,t,o){e.exports={moduleType:"component",name:"legend",layoutAttributes:o(29941),supplyLayoutDefaults:o(52738),draw:o(97990),style:o(27799)}},27799:function(e,t,o){var a=o(62258),i=o(62282),r=o(47401),n=r.strTranslate,l=o(41707),s=o(31454),d=o(8757).extractOpts,c=o(77638),h=o(59371),u=o(80084).castOption,p=o(9663);function f(e,t){return(t?"radial":"horizontal")+(e?"":"reversed")}function g(e){var t=e[0].trace,o=t.contours,a=c.hasLines(t),i=c.hasMarkers(t),r=t.visible&&t.fill&&"none"!==t.fill,n=!1,l=!1;if(o){var s=o.coloring;"lines"===s?n=!0:a="none"===s||"heatmap"===s||o.showlines,"constraint"===o.type?r="="!==o._operation:"fill"!==s&&"heatmap"!==s||(l=!0)}return{showMarker:i,showLine:a,showFill:r,showGradientLine:n,showGradientFill:l,anyLine:a||n,anyFill:r||l}}function m(e,t,o){return e&&r.isArrayOrTypedArray(e)?t:e>o?o:e}e.exports=function(e,t,o){var v=t._fullLayout;o||(o=v.legend);var y="constant"===o.itemsizing,b=o.itemwidth,x=(b+2*p.itemGap)/2,w=n(x,0),_=function(e,t,o,a){var i;if(e+1)i=e;else{if(!(t&&t.width>0))return 0;i=t.width}return y?a:Math.min(i,o)};function T(e,r,n){var c=e[0].trace,h=c.marker||{},u=h.line||{},p=n?c.visible&&c.type===n:i.traceIs(c,"bar"),f=a.select(r).select("g.legendpoints").selectAll("path.legend"+n).data(p?[e]:[]);f.enter().append("path").classed("legend"+n,!0).attr("d","M6,6H-6V-6H6Z").attr("transform",w),f.exit().remove(),f.each((function(e){var i=a.select(this),r=e[0],n=_(r.mlw,h.line,5,2);i.style("stroke-width",n+"px");var p=r.mcc;if(!o._inHover&&"mc"in r){var f=d(h),g=f.mid;void 0===g&&(g=(f.max+f.min)/2),p=l.tryColorscale(h,"")(g)}var v=p||r.mc||h.color,y=h.pattern,b=y&&l.getPatternAttr(y.shape,0,"");if(b){var x=l.getPatternAttr(y.bgcolor,0,null),w=l.getPatternAttr(y.fgcolor,0,null),T=y.fgopacity,k=m(y.size,8,10),A=m(y.solidity,.5,1),z="legend-"+c.uid;i.call(l.pattern,"legend",t,z,b,k,A,p,y.fillmode,x,w,T)}else i.call(s.fill,v);n&&s.stroke(i,r.mlc||u.color)}))}function k(e,t,o){var n=e[0],l=n.trace,s=o?l.visible&&l.type===o:i.traceIs(l,o),d=a.select(t).select("g.legendpoints").selectAll("path.legend"+o).data(s?[e]:[]);if(d.enter().append("path").classed("legend"+o,!0).attr("d","M6,6H-6V-6H6Z").attr("transform",w),d.exit().remove(),d.size()){var c=(l.marker||{}).line,p=_(u(c.width,n.pts),c,5,2),f=r.minExtend(l,{marker:{line:{width:p}}});f.marker.line.color=c.color;var g=r.minExtend(n,{trace:f});h(d,g,f)}}e.each((function(e){var t=a.select(this),i=r.ensureSingle(t,"g","layers");i.style("opacity",e[0].trace.opacity);var l=o.valign,s=e[0].lineHeight,d=e[0].height;if("middle"!==l&&s&&d){var c={top:1,bottom:-1}[l]*(.5*(s-d+3));i.attr("transform",n(0,c))}else i.attr("transform",null);i.selectAll("g.legendfill").data([e]).enter().append("g").classed("legendfill",!0),i.selectAll("g.legendlines").data([e]).enter().append("g").classed("legendlines",!0);var h=i.selectAll("g.legendsymbols").data([e]);h.enter().append("g").classed("legendsymbols",!0),h.selectAll("g.legendpoints").data([e]).enter().append("g").classed("legendpoints",!0)})).each((function(e){var o,i=e[0].trace,n=[];if(i.visible)switch(i.type){case"histogram2d":case"heatmap":n=[["M-15,-2V4H15V-2Z"]],o=!0;break;case"choropleth":case"choroplethmapbox":n=[["M-6,-6V6H6V-6Z"]],o=!0;break;case"densitymapbox":n=[["M-6,0 a6,6 0 1,0 12,0 a 6,6 0 1,0 -12,0"]],o="radial";break;case"cone":n=[["M-6,2 A2,2 0 0,0 -6,6 V6L6,4Z"],["M-6,-6 A2,2 0 0,0 -6,-2 L6,-4Z"],["M-6,-2 A2,2 0 0,0 -6,2 L6,0Z"]],o=!1;break;case"streamtube":n=[["M-6,2 A2,2 0 0,0 -6,6 H6 A2,2 0 0,1 6,2 Z"],["M-6,-6 A2,2 0 0,0 -6,-2 H6 A2,2 0 0,1 6,-6 Z"],["M-6,-2 A2,2 0 0,0 -6,2 H6 A2,2 0 0,1 6,-2 Z"]],o=!1;break;case"surface":n=[["M-6,-6 A2,3 0 0,0 -6,0 H6 A2,3 0 0,1 6,-6 Z"],["M-6,1 A2,3 0 0,1 -6,6 H6 A2,3 0 0,0 6,0 Z"]],o=!0;break;case"mesh3d":n=[["M-6,6H0L-6,-6Z"],["M6,6H0L6,-6Z"],["M-6,-6H6L0,6Z"]],o=!1;break;case"volume":n=[["M-6,6H0L-6,-6Z"],["M6,6H0L6,-6Z"],["M-6,-6H6L0,6Z"]],o=!0;break;case"isosurface":n=[["M-6,6H0L-6,-6Z"],["M6,6H0L6,-6Z"],["M-6,-6 A12,24 0 0,0 6,-6 L0,6Z"]],o=!1}var c=a.select(this).select("g.legendpoints").selectAll("path.legend3dandfriends").data(n);c.enter().append("path").classed("legend3dandfriends",!0).attr("transform",w).style("stroke-miterlimit",1),c.exit().remove(),c.each((function(e,n){var c,h=a.select(this),u=d(i),p=u.colorscale,g=u.reversescale;if(p){if(!o){var m=p.length;c=0===n?p[g?m-1:0][1]:1===n?p[g?0:m-1][1]:p[Math.floor((m-1)/2)][1]}}else{var v=i.vertexcolor||i.facecolor||i.color;c=r.isArrayOrTypedArray(v)?v[n]||v[0]:v}h.attr("d",e[0]),c?h.call(s.fill,c):h.call((function(e){if(e.size()){var a="legendfill-"+i.uid;l.gradient(e,t,a,f(g,"radial"===o),p,"fill")}}))}))})).each((function(e){var t=e[0].trace,o="waterfall"===t.type;if(e[0]._distinct&&o){var i=e[0].trace[e[0].dir].marker;return e[0].mc=i.color,e[0].mlw=i.line.width,e[0].mlc=i.line.color,T(e,this,"waterfall")}var r=[];t.visible&&o&&(r=e[0].hasTotals?[["increasing","M-6,-6V6H0Z"],["totals","M6,6H0L-6,-6H-0Z"],["decreasing","M6,6V-6H0Z"]]:[["increasing","M-6,-6V6H6Z"],["decreasing","M6,6V-6H-6Z"]]);var n=a.select(this).select("g.legendpoints").selectAll("path.legendwaterfall").data(r);n.enter().append("path").classed("legendwaterfall",!0).attr("transform",w).style("stroke-miterlimit",1),n.exit().remove(),n.each((function(e){var o=a.select(this),i=t[e[0]].marker,r=_(void 0,i.line,5,2);o.attr("d",e[1]).style("stroke-width",r+"px").call(s.fill,i.color),r&&o.call(s.stroke,i.line.color)}))})).each((function(e){T(e,this,"funnel")})).each((function(e){T(e,this)})).each((function(e){var o=e[0].trace,n=a.select(this).select("g.legendpoints").selectAll("path.legendbox").data(o.visible&&i.traceIs(o,"box-violin")?[e]:[]);n.enter().append("path").classed("legendbox",!0).attr("d","M6,6H-6V-6H6Z").attr("transform",w),n.exit().remove(),n.each((function(){var e=a.select(this);if("all"!==o.boxpoints&&"all"!==o.points||0!==s.opacity(o.fillcolor)||0!==s.opacity((o.line||{}).color)){var i=_(void 0,o.line,5,2);e.style("stroke-width",i+"px").call(s.fill,o.fillcolor),i&&s.stroke(e,o.line.color)}else{var d=r.minExtend(o,{marker:{size:y?12:r.constrain(o.marker.size,2,16),sizeref:1,sizemin:1,sizemode:"diameter"}});n.call(l.pointStyle,d,t)}}))})).each((function(e){k(e,this,"funnelarea")})).each((function(e){k(e,this,"pie")})).each((function(e){var o,i,n=g(e),s=n.showFill,h=n.showLine,u=n.showGradientLine,p=n.showGradientFill,m=n.anyFill,v=n.anyLine,y=e[0],x=y.trace,w=d(x),T=w.colorscale,k=w.reversescale,A=c.hasMarkers(x)||!m?"M5,0":v?"M5,-2":"M5,-3",z=a.select(this),S=z.select(".legendfill").selectAll("path").data(s||p?[e]:[]);if(S.enter().append("path").classed("js-fill",!0),S.exit().remove(),S.attr("d",A+"h"+b+"v6h-"+b+"z").call(s?l.fillGroupStyle:function(e){if(e.size()){var o="legendfill-"+x.uid;l.gradient(e,t,o,f(k),T,"fill")}}),h||u){var M=_(void 0,x.line,10,5);i=r.minExtend(x,{line:{width:M}}),o=[r.minExtend(y,{trace:i})]}var C=z.select(".legendlines").selectAll("path").data(h||u?[o]:[]);C.enter().append("path").classed("js-line",!0),C.exit().remove(),C.attr("d",A+(u?"l"+b+",0.0001":"h"+b)).call(h?l.lineGroupStyle:function(e){if(e.size()){var o="legendline-"+x.uid;l.lineGroupStyle(e),l.gradient(e,t,o,f(k),T,"stroke")}})})).each((function(e){var o,i,n=g(e),s=n.anyFill,d=n.anyLine,h=n.showLine,u=n.showMarker,p=e[0],f=p.trace,m=!u&&!d&&!s&&c.hasText(f);function v(e,t,o,a){var i=r.nestedProperty(f,e).get(),n=r.isArrayOrTypedArray(i)&&t?t(i):i;if(y&&n&&void 0!==a&&(n=a),o){if(n<o[0])return o[0];if(n>o[1])return o[1]}return n}function b(e){return p._distinct&&p.index&&e[p.index]?e[p.index]:e[0]}if(u||m||h){var x={},_={};if(u){x.mc=v("marker.color",b),x.mx=v("marker.symbol",b),x.mo=v("marker.opacity",r.mean,[.2,1]),x.mlc=v("marker.line.color",b),x.mlw=v("marker.line.width",r.mean,[0,5],2),_.marker={sizeref:1,sizemin:1,sizemode:"diameter"};var T=v("marker.size",r.mean,[2,16],12);x.ms=T,_.marker.size=T}h&&(_.line={width:v("line.width",b,[0,10],5)}),m&&(x.tx="Aa",x.tp=v("textposition",b),x.ts=10,x.tc=v("textfont.color",b),x.tf=v("textfont.family",b)),o=[r.minExtend(p,x)],(i=r.minExtend(f,_)).selectedpoints=null,i.texttemplate=null}var k=a.select(this).select("g.legendpoints"),A=k.selectAll("path.scatterpts").data(u?o:[]);A.enter().insert("path",":first-child").classed("scatterpts",!0).attr("transform",w),A.exit().remove(),A.call(l.pointStyle,i,t),u&&(o[0].mrc=3);var z=k.selectAll("g.pointtext").data(m?o:[]);z.enter().append("g").classed("pointtext",!0).append("text").attr("transform",w),z.exit().remove(),z.selectAll("text").call(l.textPointStyle,i,t)})).each((function(e){var t=e[0].trace,o=a.select(this).select("g.legendpoints").selectAll("path.legendcandle").data(t.visible&&"candlestick"===t.type?[e,e]:[]);o.enter().append("path").classed("legendcandle",!0).attr("d",(function(e,t){return t?"M-15,0H-8M-8,6V-6H8Z":"M15,0H8M8,-6V6H-8Z"})).attr("transform",w).style("stroke-miterlimit",1),o.exit().remove(),o.each((function(e,o){var i=a.select(this),r=t[o?"increasing":"decreasing"],n=_(void 0,r.line,5,2);i.style("stroke-width",n+"px").call(s.fill,r.fillcolor),n&&s.stroke(i,r.line.color)}))})).each((function(e){var t=e[0].trace,o=a.select(this).select("g.legendpoints").selectAll("path.legendohlc").data(t.visible&&"ohlc"===t.type?[e,e]:[]);o.enter().append("path").classed("legendohlc",!0).attr("d",(function(e,t){return t?"M-15,0H0M-8,-6V0":"M15,0H0M8,6V0"})).attr("transform",w).style("stroke-miterlimit",1),o.exit().remove(),o.each((function(e,o){var i=a.select(this),r=t[o?"increasing":"decreasing"],n=_(void 0,r.line,5,2);i.style("fill","none").call(l.dashLine,r.line.dash,n),n&&s.stroke(i,r.line.color)}))}))}},84948:function(e,t,o){var a=o(48544);e.exports={editType:"modebar",orientation:{valType:"enumerated",values:["v","h"],dflt:"h",editType:"modebar",description:"Sets the orientation of the modebar."},bgcolor:{valType:"color",editType:"modebar",description:"Sets the background color of the modebar."},color:{valType:"color",editType:"modebar",description:"Sets the color of the icons in the modebar."},activecolor:{valType:"color",editType:"modebar",description:"Sets the color of the active or hovered on icons in the modebar."},uirevision:{valType:"any",editType:"none",description:["Controls persistence of user-driven changes related to the modebar,","including `hovermode`, `dragmode`, and `showspikes` at both the","root level and inside subplots. Defaults to `layout.uirevision`."].join(" ")},add:{valType:"string",arrayOk:!0,dflt:"",editType:"modebar",description:["Determines which predefined modebar buttons to add.","Please note that these buttons will only be shown if they are","compatible with all trace types used in a graph.","Similar to `config.modeBarButtonsToAdd` option.","This may include *"+a.backButtons.join("*, *")+"*."].join(" ")},remove:{valType:"string",arrayOk:!0,dflt:"",editType:"modebar",description:["Determines which predefined modebar buttons to remove.","Similar to `config.modeBarButtonsToRemove` option.","This may include *"+a.foreButtons.join("*, *")+"*."].join(" ")}}},72952:function(e,t,o){var a=o(62282),i=o(35722),r=o(77063),n=o(68516),l=o(80535).eraseActiveShape,s=o(47401),d=s._,c=e.exports={};function h(e,t){var o,i,n=t.currentTarget,l=n.getAttribute("data-attr"),s=n.getAttribute("data-val")||!0,d=e._fullLayout,c={},h=r.list(e,null,!0),u=d._cartesianSpikesEnabled;if("zoom"===l){var p,f="in"===s?.5:2,g=(1+f)/2,m=(1-f)/2;for(i=0;i<h.length;i++)if(!(o=h[i]).fixedrange)if(p=o._name,"auto"===s)c[p+".autorange"]=!0;else if("reset"===s){if(void 0===o._rangeInitial)c[p+".autorange"]=!0;else{var v=o._rangeInitial.slice();c[p+".range[0]"]=v[0],c[p+".range[1]"]=v[1]}void 0!==o._showSpikeInitial&&(c[p+".showspikes"]=o._showSpikeInitial,"on"!==u||o._showSpikeInitial||(u="off"))}else{var y=[o.r2l(o.range[0]),o.r2l(o.range[1])],b=[g*y[0]+m*y[1],g*y[1]+m*y[0]];c[p+".range[0]"]=o.l2r(b[0]),c[p+".range[1]"]=o.l2r(b[1])}}else"hovermode"!==l||"x"!==s&&"y"!==s||(s=d._isHoriz?"y":"x",n.setAttribute("data-val",s)),c[l]=s;d._cartesianSpikesEnabled=u,a.call("_guiRelayout",e,c)}function u(e,t){for(var o=t.currentTarget,i=o.getAttribute("data-attr"),r=o.getAttribute("data-val")||!0,n=e._fullLayout._subplots.gl3d||[],l={},s=i.split("."),d=0;d<n.length;d++)l[n[d]+"."+s[1]]=r;var c="pan"===r?r:"zoom";l.dragmode=c,a.call("_guiRelayout",e,l)}function p(e,t){for(var o=t.currentTarget.getAttribute("data-attr"),i="resetLastSave"===o,r="resetDefault"===o,n=e._fullLayout,l=n._subplots.gl3d||[],s={},d=0;d<l.length;d++){var c,h=l[d],u=h+".camera",p=h+".aspectratio",f=h+".aspectmode",g=n[h]._scene;i?(s[u+".up"]=g.viewInitial.up,s[u+".eye"]=g.viewInitial.eye,s[u+".center"]=g.viewInitial.center,c=!0):r&&(s[u+".up"]=null,s[u+".eye"]=null,s[u+".center"]=null,c=!0),c&&(s[p+".x"]=g.viewInitial.aspectratio.x,s[p+".y"]=g.viewInitial.aspectratio.y,s[p+".z"]=g.viewInitial.aspectratio.z,s[f]=g.viewInitial.aspectmode)}a.call("_guiRelayout",e,s)}function f(e,t){var o=t.currentTarget,a=o._previousVal,i=e._fullLayout,r=i._subplots.gl3d||[],n=["xaxis","yaxis","zaxis"],l={},s={};if(a)s=a,o._previousVal=null;else{for(var d=0;d<r.length;d++){var c=r[d],h=i[c],u=c+".hovermode";l[u]=h.hovermode,s[u]=!1;for(var p=0;p<3;p++){var f=n[p],g=c+"."+f+".showspikes";s[g]=!1,l[g]=h[f].showspikes}}o._previousVal=l}return s}function g(e,t){for(var o=t.currentTarget,i=o.getAttribute("data-attr"),r=o.getAttribute("data-val")||!0,n=e._fullLayout,l=n._subplots.geo||[],s=0;s<l.length;s++){var d=l[s],c=n[d];if("zoom"===i){var h=c.projection.scale,u="in"===r?2*h:.5*h;a.call("_guiRelayout",e,d+".projection.scale",u)}}"reset"===i&&b(e,"geo")}function m(e){var t=e._fullLayout;return!t.hovermode&&(t._has("cartesian")?t._isHoriz?"y":"x":"closest")}function v(e){var t=m(e);a.call("_guiRelayout",e,"hovermode",t)}function y(e,t){for(var o=t.currentTarget.getAttribute("data-val"),i=e._fullLayout,r=i._subplots.mapbox||[],n={},l=0;l<r.length;l++){var s=r[l],d=i[s].zoom,c="in"===o?1.05*d:d/1.05;n[s+".zoom"]=c}a.call("_guiRelayout",e,n)}function b(e,t){for(var o=e._fullLayout,i=o._subplots[t]||[],r={},n=0;n<i.length;n++)for(var l=i[n],s=o[l]._subplot.viewInitial,d=Object.keys(s),c=0;c<d.length;c++){var h=d[c];r[l+"."+h]=s[h]}a.call("_guiRelayout",e,r)}c.toImage={name:"toImage",title:function(e){var t=(e._context.toImageButtonOptions||{}).format||"png";return d(e,"png"===t?"Download plot as a png":"Download plot")},icon:n.camera,click:function(e){var t=e._context.toImageButtonOptions,o={format:t.format||"png"};s.notifier(d(e,"Taking snapshot - this may take a few seconds"),"long"),"svg"!==o.format&&s.isIE()&&(s.notifier(d(e,"IE only supports svg.  Changing format to svg."),"long"),o.format="svg"),["filename","width","height","scale"].forEach((function(e){e in t&&(o[e]=t[e])})),a.call("downloadImage",e,o).then((function(t){s.notifier(d(e,"Snapshot succeeded")+" - "+t,"long")})).catch((function(){s.notifier(d(e,"Sorry, there was a problem downloading your snapshot!"),"long")}))}},c.sendDataToCloud={name:"sendDataToCloud",title:function(e){return d(e,"Edit in Chart Studio")},icon:n.disk,click:function(e){i.sendDataToCloud(e)}},c.editInChartStudio={name:"editInChartStudio",title:function(e){return d(e,"Edit in Chart Studio")},icon:n.pencil,click:function(e){i.sendDataToCloud(e)}},c.zoom2d={name:"zoom2d",_cat:"zoom",title:function(e){return d(e,"Zoom")},attr:"dragmode",val:"zoom",icon:n.zoombox,click:h},c.pan2d={name:"pan2d",_cat:"pan",title:function(e){return d(e,"Pan")},attr:"dragmode",val:"pan",icon:n.pan,click:h},c.select2d={name:"select2d",_cat:"select",title:function(e){return d(e,"Box Select")},attr:"dragmode",val:"select",icon:n.selectbox,click:h},c.lasso2d={name:"lasso2d",_cat:"lasso",title:function(e){return d(e,"Lasso Select")},attr:"dragmode",val:"lasso",icon:n.lasso,click:h},c.drawclosedpath={name:"drawclosedpath",title:function(e){return d(e,"Draw closed freeform")},attr:"dragmode",val:"drawclosedpath",icon:n.drawclosedpath,click:h},c.drawopenpath={name:"drawopenpath",title:function(e){return d(e,"Draw open freeform")},attr:"dragmode",val:"drawopenpath",icon:n.drawopenpath,click:h},c.drawline={name:"drawline",title:function(e){return d(e,"Draw line")},attr:"dragmode",val:"drawline",icon:n.drawline,click:h},c.drawrect={name:"drawrect",title:function(e){return d(e,"Draw rectangle")},attr:"dragmode",val:"drawrect",icon:n.drawrect,click:h},c.drawcircle={name:"drawcircle",title:function(e){return d(e,"Draw circle")},attr:"dragmode",val:"drawcircle",icon:n.drawcircle,click:h},c.eraseshape={name:"eraseshape",title:function(e){return d(e,"Erase active shape")},icon:n.eraseshape,click:l},c.zoomIn2d={name:"zoomIn2d",_cat:"zoomin",title:function(e){return d(e,"Zoom in")},attr:"zoom",val:"in",icon:n.zoom_plus,click:h},c.zoomOut2d={name:"zoomOut2d",_cat:"zoomout",title:function(e){return d(e,"Zoom out")},attr:"zoom",val:"out",icon:n.zoom_minus,click:h},c.autoScale2d={name:"autoScale2d",_cat:"autoscale",title:function(e){return d(e,"Autoscale")},attr:"zoom",val:"auto",icon:n.autoscale,click:h},c.resetScale2d={name:"resetScale2d",_cat:"resetscale",title:function(e){return d(e,"Reset axes")},attr:"zoom",val:"reset",icon:n.home,click:h},c.hoverClosestCartesian={name:"hoverClosestCartesian",_cat:"hoverclosest",title:function(e){return d(e,"Show closest data on hover")},attr:"hovermode",val:"closest",icon:n.tooltip_basic,gravity:"ne",click:h},c.hoverCompareCartesian={name:"hoverCompareCartesian",_cat:"hoverCompare",title:function(e){return d(e,"Compare data on hover")},attr:"hovermode",val:function(e){return e._fullLayout._isHoriz?"y":"x"},icon:n.tooltip_compare,gravity:"ne",click:h},c.zoom3d={name:"zoom3d",_cat:"zoom",title:function(e){return d(e,"Zoom")},attr:"scene.dragmode",val:"zoom",icon:n.zoombox,click:u},c.pan3d={name:"pan3d",_cat:"pan",title:function(e){return d(e,"Pan")},attr:"scene.dragmode",val:"pan",icon:n.pan,click:u},c.orbitRotation={name:"orbitRotation",title:function(e){return d(e,"Orbital rotation")},attr:"scene.dragmode",val:"orbit",icon:n["3d_rotate"],click:u},c.tableRotation={name:"tableRotation",title:function(e){return d(e,"Turntable rotation")},attr:"scene.dragmode",val:"turntable",icon:n["z-axis"],click:u},c.resetCameraDefault3d={name:"resetCameraDefault3d",_cat:"resetCameraDefault",title:function(e){return d(e,"Reset camera to default")},attr:"resetDefault",icon:n.home,click:p},c.resetCameraLastSave3d={name:"resetCameraLastSave3d",_cat:"resetCameraLastSave",title:function(e){return d(e,"Reset camera to last save")},attr:"resetLastSave",icon:n.movie,click:p},c.hoverClosest3d={name:"hoverClosest3d",_cat:"hoverclosest",title:function(e){return d(e,"Toggle show closest data on hover")},attr:"hovermode",val:null,toggle:!0,icon:n.tooltip_basic,gravity:"ne",click:function(e,t){var o=f(e,t);a.call("_guiRelayout",e,o)}},c.zoomInGeo={name:"zoomInGeo",_cat:"zoomin",title:function(e){return d(e,"Zoom in")},attr:"zoom",val:"in",icon:n.zoom_plus,click:g},c.zoomOutGeo={name:"zoomOutGeo",_cat:"zoomout",title:function(e){return d(e,"Zoom out")},attr:"zoom",val:"out",icon:n.zoom_minus,click:g},c.resetGeo={name:"resetGeo",_cat:"reset",title:function(e){return d(e,"Reset")},attr:"reset",val:null,icon:n.autoscale,click:g},c.hoverClosestGeo={name:"hoverClosestGeo",_cat:"hoverclosest",title:function(e){return d(e,"Toggle show closest data on hover")},attr:"hovermode",val:null,toggle:!0,icon:n.tooltip_basic,gravity:"ne",click:v},c.hoverClosestGl2d={name:"hoverClosestGl2d",_cat:"hoverclosest",title:function(e){return d(e,"Toggle show closest data on hover")},attr:"hovermode",val:null,toggle:!0,icon:n.tooltip_basic,gravity:"ne",click:v},c.hoverClosestPie={name:"hoverClosestPie",_cat:"hoverclosest",title:function(e){return d(e,"Toggle show closest data on hover")},attr:"hovermode",val:"closest",icon:n.tooltip_basic,gravity:"ne",click:v},c.resetViewSankey={name:"resetSankeyGroup",title:function(e){return d(e,"Reset view")},icon:n.home,click:function(e){for(var t={"node.groups":[],"node.x":[],"node.y":[]},o=0;o<e._fullData.length;o++){var i=e._fullData[o]._viewInitial;t["node.groups"].push(i.node.groups.slice()),t["node.x"].push(i.node.x.slice()),t["node.y"].push(i.node.y.slice())}a.call("restyle",e,t)}},c.toggleHover={name:"toggleHover",title:function(e){return d(e,"Toggle show closest data on hover")},attr:"hovermode",val:null,toggle:!0,icon:n.tooltip_basic,gravity:"ne",click:function(e,t){var o=f(e,t);o.hovermode=m(e),a.call("_guiRelayout",e,o)}},c.resetViews={name:"resetViews",title:function(e){return d(e,"Reset views")},icon:n.home,click:function(e,t){var o=t.currentTarget;o.setAttribute("data-attr","zoom"),o.setAttribute("data-val","reset"),h(e,t),o.setAttribute("data-attr","resetLastSave"),p(e,t),b(e,"geo"),b(e,"mapbox")}},c.toggleSpikelines={name:"toggleSpikelines",title:function(e){return d(e,"Toggle Spike Lines")},icon:n.spikeline,attr:"_cartesianSpikesEnabled",val:"on",click:function(e){var t=e._fullLayout,o=t._cartesianSpikesEnabled;t._cartesianSpikesEnabled="on"===o?"off":"on",a.call("_guiRelayout",e,function(e){for(var t="on"===e._fullLayout._cartesianSpikesEnabled,o=r.list(e,null,!0),a={},i=0;i<o.length;i++){var n=o[i];a[n._name+".showspikes"]=!!t||n._showSpikeInitial}return a}(e))}},c.resetViewMapbox={name:"resetViewMapbox",_cat:"resetView",title:function(e){return d(e,"Reset view")},attr:"reset",icon:n.home,click:function(e){b(e,"mapbox")}},c.zoomInMapbox={name:"zoomInMapbox",_cat:"zoomin",title:function(e){return d(e,"Zoom in")},attr:"zoom",val:"in",icon:n.zoom_plus,click:y},c.zoomOutMapbox={name:"zoomOutMapbox",_cat:"zoomout",title:function(e){return d(e,"Zoom out")},attr:"zoom",val:"out",icon:n.zoom_minus,click:y}},48544:function(e,t,o){var a=o(72952),i=Object.keys(a),r=["drawline","drawopenpath","drawclosedpath","drawcircle","drawrect","eraseshape"],n=["v1hovermode","hoverclosest","hovercompare","togglehover","togglespikelines"].concat(r),l=[];i.forEach((function(e){!function(e){if(-1===n.indexOf(e._cat||e.name)){var t=e.name,o=(e._cat||e.name).toLowerCase();-1===l.indexOf(t)&&l.push(t),-1===l.indexOf(o)&&l.push(o)}}(a[e])})),l.sort(),e.exports={DRAW_MODES:r,backButtons:n,foreButtons:l}},17379:function(e,t,o){var a=o(47401),i=o(31454),r=o(92704),n=o(84948);e.exports=function(e,t){var o=e.modebar||{},l=r.newContainer(t,"modebar");function s(e,t){return a.coerce(o,l,n,e,t)}s("orientation"),s("bgcolor",i.addOpacity(t.paper_bgcolor,.5));var d=i.contrast(i.rgb(t.modebar.bgcolor));s("color",i.addOpacity(d,.3)),s("activecolor",i.addOpacity(d,.7)),s("uirevision",t.uirevision),s("add"),s("remove")}},18905:function(e,t,o){e.exports={moduleType:"component",name:"modebar",layoutAttributes:o(84948),supplyLayoutDefaults:o(17379),manage:o(16450)}},16450:function(e,t,o){var a=o(77063),i=o(77638),r=o(62282),n=o(14904).isUnifiedHover,l=o(83777),s=o(72952),d=o(48544).DRAW_MODES;e.exports=function(e){var t=e._fullLayout,o=e._context,c=t._modeBar;if(o.displayModeBar||o.watermark){if(!Array.isArray(o.modeBarButtonsToRemove))throw new Error(["*modeBarButtonsToRemove* configuration options","must be an array."].join(" "));if(!Array.isArray(o.modeBarButtonsToAdd))throw new Error(["*modeBarButtonsToAdd* configuration options","must be an array."].join(" "));var h,u=o.modeBarButtons;h=Array.isArray(u)&&u.length?function(e){for(var t=0;t<e.length;t++)for(var o=e[t],a=0;a<o.length;a++){var i=o[a];if("string"===typeof i){if(void 0===s[i])throw new Error(["*modeBarButtons* configuration options","invalid button name"].join(" "));e[t][a]=s[i]}}return e}(u):!o.displayModeBar&&o.watermark?[]:function(e){var t=e._fullLayout,o=e._fullData,l=e._context;function c(e,t){if("string"===typeof t){if(t.toLowerCase()===e.toLowerCase())return!0}else{var o=t.name,a=t._cat||t.name;if(o===e||a===e.toLowerCase())return!0}return!1}var h=t.modebar.add;"string"===typeof h&&(h=[h]);var u=t.modebar.remove;"string"===typeof u&&(u=[u]);var p=l.modeBarButtonsToAdd.concat(h.filter((function(e){for(var t=0;t<l.modeBarButtonsToRemove.length;t++)if(c(e,l.modeBarButtonsToRemove[t]))return!1;return!0}))),f=l.modeBarButtonsToRemove.concat(u.filter((function(e){for(var t=0;t<l.modeBarButtonsToAdd.length;t++)if(c(e,l.modeBarButtonsToAdd[t]))return!1;return!0}))),g=t._has("cartesian"),m=t._has("gl3d"),v=t._has("geo"),y=t._has("pie"),b=t._has("funnelarea"),x=t._has("gl2d"),w=t._has("ternary"),_=t._has("mapbox"),T=t._has("polar"),k=t._has("sankey"),A=function(e){for(var t=a.list({_fullLayout:e},null,!0),o=0;o<t.length;o++)if(!t[o].fixedrange)return!1;return!0}(t),z=n(t.hovermode),S=[];function M(e){if(e.length){for(var t=[],o=0;o<e.length;o++){for(var a=e[o],i=s[a],r=i.name.toLowerCase(),n=(i._cat||i.name).toLowerCase(),l=!1,d=0;d<f.length;d++){var c=f[d].toLowerCase();if(c===r||c===n){l=!0;break}}l||t.push(s[a])}S.push(t)}}var C=["toImage"];l.showEditInChartStudio?C.push("editInChartStudio"):l.showSendToCloud&&C.push("sendDataToCloud");M(C);var I=[],L=[],D=[],B=[];(g||x||y||b||w)+v+m+_+T>1?(L=["toggleHover"],D=["resetViews"]):v?(I=["zoomInGeo","zoomOutGeo"],L=["hoverClosestGeo"],D=["resetGeo"]):m?(L=["hoverClosest3d"],D=["resetCameraDefault3d","resetCameraLastSave3d"]):_?(I=["zoomInMapbox","zoomOutMapbox"],L=["toggleHover"],D=["resetViewMapbox"]):x?L=["hoverClosestGl2d"]:y?L=["hoverClosestPie"]:k?(L=["hoverClosestCartesian","hoverCompareCartesian"],D=["resetViewSankey"]):L=["toggleHover"];g&&(L=["toggleSpikelines","hoverClosestCartesian","hoverCompareCartesian"]);(function(e){for(var t=0;t<e.length;t++)if(!r.traceIs(e[t],"noHover"))return!1;return!0}(o)||z)&&(L=[]);!g&&!x||A||(I=["zoomIn2d","zoomOut2d","autoScale2d"],"resetViews"!==D[0]&&(D=["resetScale2d"]));m?B=["zoom3d","pan3d","orbitRotation","tableRotation"]:(g||x)&&!A||w?B=["zoom2d","pan2d"]:_||v?B=["pan2d"]:T&&(B=["zoom2d"]);(function(e){for(var t=!1,o=0;o<e.length&&!t;o++){var a=e[o];a._module&&a._module.selectPoints&&(r.traceIs(a,"scatter-like")?(i.hasMarkers(a)||i.hasText(a))&&(t=!0):r.traceIs(a,"box-violin")&&"all"!==a.boxpoints&&"all"!==a.points||(t=!0))}return t})(o)&&B.push("select2d","lasso2d");var H=[],R=function(e){-1===H.indexOf(e)&&-1!==L.indexOf(e)&&H.push(e)};if(Array.isArray(p)){for(var j=[],E=0;E<p.length;E++){var O=p[E];"string"===typeof O?(O=O.toLowerCase(),-1!==d.indexOf(O)?(t._has("mapbox")||t._has("cartesian"))&&B.push(O):"togglespikelines"===O?R("toggleSpikelines"):"togglehover"===O?R("toggleHover"):"hovercompare"===O?R("hoverCompareCartesian"):"hoverclosest"===O?(R("hoverClosestCartesian"),R("hoverClosestGeo"),R("hoverClosest3d"),R("hoverClosestGl2d"),R("hoverClosestPie")):"v1hovermode"===O&&(R("toggleHover"),R("hoverClosestCartesian"),R("hoverCompareCartesian"),R("hoverClosestGeo"),R("hoverClosest3d"),R("hoverClosestGl2d"),R("hoverClosestPie"))):j.push(O)}p=j}return M(B),M(I.concat(D)),M(H),function(e,t){if(t.length)if(Array.isArray(t[0]))for(var o=0;o<t.length;o++)e.push(t[o]);else e.push(t);return e}(S,p)}(e),c?c.update(e,h):t._modeBar=l(e,h)}else c&&(c.destroy(),delete t._modeBar)}},83777:function(e,t,o){var a=o(62258),i=o(83491),r=o(47401),n=o(68516),l=new DOMParser;function s(e){this.container=e.container,this.element=document.createElement("div"),this.update(e.graphInfo,e.buttons),this.container.appendChild(this.element)}var d=s.prototype;d.update=function(e,t){this.graphInfo=e;var o=this.graphInfo._context,a=this.graphInfo._fullLayout,i="modebar-"+a._uid;this.element.setAttribute("id",i),this._uid=i,this.element.className="modebar","hover"===o.displayModeBar&&(this.element.className+=" modebar--hover ease-bg"),"v"===a.modebar.orientation&&(this.element.className+=" vertical",t=t.reverse());var n=a.modebar,l="hover"===o.displayModeBar?".js-plotly-plot .plotly:hover ":"";r.deleteRelatedStyleRule(i),r.addRelatedStyleRule(i,l+"#"+i+" .modebar-group","background-color: "+n.bgcolor),r.addRelatedStyleRule(i,"#"+i+" .modebar-btn .icon path","fill: "+n.color),r.addRelatedStyleRule(i,"#"+i+" .modebar-btn:hover .icon path","fill: "+n.activecolor),r.addRelatedStyleRule(i,"#"+i+" .modebar-btn.active .icon path","fill: "+n.activecolor);var s=!this.hasButtons(t),d=this.hasLogo!==o.displaylogo,c=this.locale!==o.locale;if(this.locale=o.locale,(s||d||c)&&(this.removeAllButtons(),this.updateButtons(t),o.watermark||o.displaylogo)){var h=this.getLogo();o.watermark&&(h.className=h.className+" watermark"),"v"===a.modebar.orientation?this.element.insertBefore(h,this.element.childNodes[0]):this.element.appendChild(h),this.hasLogo=!0}this.updateActiveButton()},d.updateButtons=function(e){var t=this;this.buttons=e,this.buttonElements=[],this.buttonsNames=[],this.buttons.forEach((function(e){var o=t.createGroup();e.forEach((function(e){var a=e.name;if(!a)throw new Error("must provide button 'name' in button config");if(-1!==t.buttonsNames.indexOf(a))throw new Error("button name '"+a+"' is taken");t.buttonsNames.push(a);var i=t.createButton(e);t.buttonElements.push(i),o.appendChild(i)})),t.element.appendChild(o)}))},d.createGroup=function(){var e=document.createElement("div");return e.className="modebar-group",e},d.createButton=function(e){var t=this,o=document.createElement("a");o.setAttribute("rel","tooltip"),o.className="modebar-btn";var i=e.title;void 0===i?i=e.name:"function"===typeof i&&(i=i(this.graphInfo)),(i||0===i)&&o.setAttribute("data-title",i),void 0!==e.attr&&o.setAttribute("data-attr",e.attr);var r=e.val;if(void 0!==r&&("function"===typeof r&&(r=r(this.graphInfo)),o.setAttribute("data-val",r)),"function"!==typeof e.click)throw new Error("must provide button 'click' function in button config");o.addEventListener("click",(function(o){e.click(t.graphInfo,o),t.updateActiveButton(o.currentTarget)})),o.setAttribute("data-toggle",e.toggle||!1),e.toggle&&a.select(o).classed("active",!0);var l=e.icon;return"function"===typeof l?o.appendChild(l()):o.appendChild(this.createIcon(l||n.question)),o.setAttribute("data-gravity",e.gravity||"n"),o},d.createIcon=function(e){var t,o=i(e.height)?Number(e.height):e.ascent-e.descent,a="http://www.w3.org/2000/svg";if(e.path){(t=document.createElementNS(a,"svg")).setAttribute("viewBox",[0,0,e.width,o].join(" ")),t.setAttribute("class","icon");var r=document.createElementNS(a,"path");r.setAttribute("d",e.path),e.transform?r.setAttribute("transform",e.transform):void 0!==e.ascent&&r.setAttribute("transform","matrix(1 0 0 -1 0 "+e.ascent+")"),t.appendChild(r)}e.svg&&(t=l.parseFromString(e.svg,"application/xml").childNodes[0]);return t.setAttribute("height","1em"),t.setAttribute("width","1em"),t},d.updateActiveButton=function(e){var t=this.graphInfo._fullLayout,o=void 0!==e?e.getAttribute("data-attr"):null;this.buttonElements.forEach((function(e){var i=e.getAttribute("data-val")||!0,n=e.getAttribute("data-attr"),l="true"===e.getAttribute("data-toggle"),s=a.select(e);if(l)n===o&&s.classed("active",!s.classed("active"));else{var d=null===n?n:r.nestedProperty(t,n).get();s.classed("active",d===i)}}))},d.hasButtons=function(e){var t=this.buttons;if(!t)return!1;if(e.length!==t.length)return!1;for(var o=0;o<e.length;++o){if(e[o].length!==t[o].length)return!1;for(var a=0;a<e[o].length;a++)if(e[o][a].name!==t[o][a].name)return!1}return!0},d.getLogo=function(){var e=this.createGroup(),t=document.createElement("a");return t.href="https://plotly.com/",t.target="_blank",t.setAttribute("data-title",r._(this.graphInfo,"Produced with Plotly")),t.className="modebar-btn plotlyjsicon modebar-btn--logo",t.appendChild(this.createIcon(n.newplotlylogo)),e.appendChild(t),e},d.removeAllButtons=function(){for(;this.element.firstChild;)this.element.removeChild(this.element.firstChild);this.hasLogo=!1},d.destroy=function(){r.removeElement(this.container.querySelector(".modebar")),r.deleteRelatedStyleRule(this._uid)},e.exports=function(e,t){var o=e._fullLayout,i=new s({graphInfo:e,container:o._modebardiv.node(),buttons:t});return o._privateplot&&a.select(i.element).append("span").classed("badge-private float--left",!0).text("PRIVATE"),i}}}]);