## Machine Learning Books

### 2015 Grus: _Learning Data Science from Scratch_ [O'Reilly $34](http://shop.oreilly.com/product/0636920033400.do)

- Ch 1: Ascendance of Data
- Ch 2: Python
- Ch 3: Visualizations (matplotlib)
- Ch 4: Linear Algebra
- Ch 5: Stats
    - Quartiles, Mean, Variance, Std
    - Correlation & Simpson's Paradox
    - Correlation & Causation
- Ch 6: Probability
    - Dependence vs Independence, Conditional Probability
    - Bayes Theorem
    - Distributions
    - Normal Distribution (Gaussian)
    - Central Limit Theorem
- Ch 7: Hypothesis and Inference
    - Confidence intervals
    - P-value and P-hacking
- Ch 8: Gradient Descent (Optimization)
    - Estimating the Gradient
    - Stochastic
- Ch 9: Data Input (with Python)
    - stdin
    - files
    - web scraping
    - twitter API
- Ch 10: Data Munging
    - data schemas
    - cleaning
    - rescaling
    - dimension reduction
- Ch 11: Machine Learning
    - Overfitting and Underfitting
    - Correctness
    - Bias-Variance Trade-Off
    - Feature Engineering (extraction & selection)
- Ch 12: Classification with KNN
    - Curse of Dimensionality
- Ch 13: Naive Bayes
- Ch 14: Linear Regression
- Ch 15: Multivariate Linear Regression
- Ch 16: Logistic Regression
- Ch 17: Decision Trees
    - Entropy
    - Random Forest
- Ch 18: Neural Nets
- Ch 19: Clustering
    - K-Means and KNN
    - Hierarchical Clustering
- Ch 20: NLP
    - Word Clouds
    - N-Grams
    - Topic Modeling (LSI)
- Ch 21: Network Analysis (Graph Theory)
    - Betweenness Centrality
    - Eigenvector Centrality
    - Directed Graphs (PageRank)
- Ch 22: Recommenders
    - User-Based Collaborative Filtering
    - Item-Based Collaborative Filtering
- Ch 23: Databases and SQL
    - SELECT, JOIN, GROUP BY, ORDER BY
    - Indexes
    - Query Optimization
    - NoSQL
- Ch 24: Map Reduce
    - Why?
    - Matrix Multiplication example
    - NLP example
    - Combiners

### 2015 Raschka: _Python Machine Learning_, [Packt $36](https://www.packtpub.com/big-data-and-business-intelligence/python-machine-learning)

- Ch 1: Learning from Data
    - 3 ways to transform data into knowledge
        - Supervised learning to predict the future
        - Reinforcement learning to "solve" interactive problems
        - Unsupervised learning (clustering) to find hidden structure
    - terminology and notation
    - pipeline elements
        - preprocessing data
        - selecting a model
        - training a model
        - evaluating model performance
        - prediction
    - python

### 2016 VanderPlas: _Python Data Science Handbook -- Tools and Techniques for Developers_ [O'Reilly $60](http://shop.oreilly.com/product/0636920034919.do)

Not scheduled for print release till later in 2016, but most chapters are available electronically now and it looks like a good resource for students that are new to Python.

- Ch 1: Whirlwind Tour of the Python Language
- Ch 2: IPython Beyond Normal Python
- Ch 3: Introduction to Numpy
- Ch 4: Introduction to Pandas
- Ch 5: Introduction to Matplotlib
- Ch 6: TBD 
- Ch 7: Machine Learning

### 2013 Russel: _Mining the Social Web 2nd Ed_, [O'Reilly $38](http://shop.oreilly.com/product/0636920030195.do)

Fun machine learning projects and a [github repo](https://github.com/ptwobrussell/Mining-the-Social-Web-2nd-Edition) with code. Uses industry-standard data science packages (pandas, scikit-learn, etc) as well as practical tools for aquiring and manipulating data, like json, web apis, unstructured text processing, etc.

- Ch 1: Twitter
    - Twitter API
    - NLP
- Ch 2: Facebook
    - Social Graph API
- Ch 3: Google +
- Ch 4: Linked-In
- Ch 5: Web Page Scraping
- Ch 6: E-Mail
- Ch 7: GitHub
- Ch 8: Semantic Web
- Ch 9: Twitter Cookbook

### 2015 Bowles: _Machine Learning in Python_

- Ch 1: Introduction
    - Penalized Regression (Regularization) and Ensemble Methods
- Ch 2:

### 2015 Coelho: _Building Machine Learning Systems with Python 2nd Ed_

- Ch 1: Python Tools and Explanation of "Modeling"
    - SciPy and matplotlib
    - numpy (efficiency, indexing, missing values)
    - introduction to "modeling" (i.e. simulation)
- Ch 2: Classification Example
    - Datasets: Iris (flower), Seeds (wheat seeds)
    - Experiment design (DOE, DOX or cross-validation)
    - Features and Feature Engineering

### 2014 Janssens: _Data Science at the Command Line_, [website](http://datascienceatthecommandline.com/), [O'Reilly $34](http://shop.oreilly.com/product/0636920032823.do?cmp=af-strata-books-videos-product_cj_9781491947852_%25zp)

- Ch 1: Intro
    - Real world use cases
- Ch 2: Setting up a DS Toolbox
- Ch 3: Getting Data
    - Files (reading, deompressing)
    - Excel
    - DBs
    - Web APIs
- Ch 4: Reusable Command-Line Tools
    - Oneliners -> shell scripts
    - Python and R
- Ch 5: Cleaning Data
    - CSV, HTML/XML, JSON
- Ch 6: Data Workflow/Pipeline
    - Drake
    - example: mining Project Gutenburg
- Ch 7: Exploring Data
    - Stats and Visualization
- Ch 8: Parallel Pipelines
- Ch 9: Modeling Data
    - Weka, SciKit-Learn, Tapkee, BigML
- Ch 10: Lessons Learned
- Appendix: List of Command Line Tools 
    - alias, awk, aws, bash, bc, bigmler, body, cat, cd, chmod, cols, cowsay, cp, csvcut, csvgrep, csvjoin, csvlook, csvsort, csvsql, csvstack, csvstat, curl, curlicue, cut, display, drake, dseq, echo, env, export, feedgnuplot, fieldsplit, find, for, git, grep, head, header, in2csv, jq, json2csv, less, ls, man, mkdir, mv, parallel, paste, pbc, pip, pwd, python, R, Rio, Rio-scatter, rm, run_experiment, sample, scp, scrape, sed, seq, shuf, sort, split, sql2csv, ssh, sudo, tail, tapkee, tar, tee, tr, tree, type, uniq, unpack, unrar, unzip, wc, weka, which, xml2json

## 2011 Witten: _Data Mining - Practical Machine Learning Tools and Techniques, 3rd Ed_

- Ch 1. Data Mining & Machine Learning
    - Examples with data and code
        - Weather prediction
        - Iris
        - CPU performance
    - Web Applications
        - Web scraping/mining
        - Inference/judgement
    - Search
    - Ethics
    - Statistics
- Ch 2. Concepts, Instances, Attributes
    - Relation examples
    - Attribute examples
    - Preprocessing data
    - ARFF format
    - Sparse data structures
    - Imputing missing values
    - Correcting errors
- Ch 3. Knowledge Representation (Modeling)
    - Linear models
    - Decision trees
    - Classification rules/heuristics
    - Clustering
- Ch 4. Algorithms
    - Easy inference problems (filling missing values)
    - Statistical Modeling
        - Naive Bayes document classification 

## Others

- 2013 Provost: _Machine Learning for Business_
    - Good for CTOs and startup product development leads
    - Nice simplified explanation of regression, classification, recommendation, unsupervised/supervised
- 2013 Massaron: _Python® for Data Science For Dummies by Luca Massaron & John Paul Mueller_
    - pretty basic 
- 2016 Domingos: _The Master Algorithm_
    - light on technical details and "actionable" insight
    - [reviewers say it's just disorganized self-promotion](https://www.goodreads.com/book/show/24612233-the-master-algorithm)

### Think Stats [iPython Notebooks](http://greenteapress.com/thinkstats2/)

Teaches stats with pandas and python. It has a github repo with notebooks to complete. Uses the author's libraries rather than more widely-used packages (e.g. scipy.stats).

### 2009: _Introduction to Machine Learning_, MIT Press

Information-theoretic approach with lots of math, theory, and no code. If you want to know the formal "set theory" and calculus notation for the algorithms your using, this is the book for you.

- Ch 1: What is ML
    - Solving problems with data instead of a hard-coded algorithm based on a-priori knowledge
- Ch 2: Supervised Learning
- Ch 3: Bayesian Decision Theory
- Ch 4: Parametric Methods
- Ch 5: Multivariate Methods
- Ch 6: Dimensionality Reduction
- Ch 7: Clustering
- Ch 8: Nonparametric Methods (Clustering, Decision Trees, NNs)
- Ch 9: Decision Trees
- Ch 10: Linear Discrimination
- Ch 11: Multilayer Perceptrons
- Ch 12: Local Models
- Ch 13: Kernel Machines
- Ch 14: Bayesian Estimation
- Ch 15: Hidden Markhov Models
- Ch 16: Graphical Models (Bayesian/Belief Networks)
- Ch 17: Combining Learners (Ensemble Learning)
- Ch 18: Reinforcement Learning
- Ch 19: Machine Learning Experiment Design (DOX)
