# Contributing to SKALE

Looking to contribute something to SKALE? **Here are instructions on how you can help.**

Before you start, please review the [README.md](https://github.com/skalenetwork/skale.py/blob/develop/README.md) and our [Code of Conduct](https://github.com/skalenetwork/skale.py/blob/develop/.github/CODE_OF_CONDUCT.md).

## Code Guidelines

**When contributing to this repository, please find an issue you would like to help with or first discuss the change you wish to make by opening an issue.**

### I don't want to read this whole thing - I just have a question!!!

> **Note:** Please don't file an issue to ask a question. You'll get faster results by simply [joining our Discord and asking our team there](http://skale.chat).

## Reporting bugs

Create a new issue and follow the issue template instructions to report the bug.

## Contribute

Follow these steps:

-   create an issue and describe what you would like to contribute.
-   fork this repository.
-   fix bugs, make enhancements, or implement features and propose a pull request.

## Pull Request Process

Patchsets should always be focused. For example, a pull request could add a feature, fix a bug, or refactor code; but not a mixture. Please also avoid super pull requests which attempt to do too much, are overly large, or overly complex as this makes review difficult.

In general, please adhere to the following:

-   code should conform to PEP8 and linting should be done by `ruff`.
-   include tests.
-   include any relevant documentation updates.

### Branch naming convention

Name your branches with one of the following prefixes (`bug/`, `feature/`, or `enhancement/`), add the issue number and add a description: `[type]/[issueNum]-[change-with-hyphens]`. Examples:

-   `bug/87-archives-crash-app`
-   `bug/92-font-size-update-not-immediate`
-   `feature/40-add-date-search`
-   `enhancement/56-refactor-unittests`
-   `enhancement/63-code-style-improvements`

### Testing

Please review the TravisCI build status and confirm that the tests are running and test results are what is expected.
