(function(undefined){"use strict";function defaultIfUndefined(value,defaultValue){return value!==undefined?value:defaultValue}var mushroom=window.mushroom;if(mushroom===undefined){mushroom=window.mushroom={}}mushroom.Exception=function(message){this.message=message};mushroom.Exception.prototype=new Error;mushroom.Exception.prototype.name="mushroom.Exception";mushroom.IllegalState=function(message){this.message=message};mushroom.IllegalState.prototype=new mushroom.Exception;mushroom.IllegalState.prototype.name="mushroom.IllegalState";mushroom.ConnectionError=function(message){this.message=message};mushroom.ConnectionError.prototype=new mushroom.Exception;mushroom.ConnectionError.prototype.name="mushroom.ConnectionError";mushroom.RequestFailed=function(request,response){this.message="Method call failed: "+request.method;this.request=request;this.response=response};mushroom.RequestFailed.prototype=new mushroom.Exception;mushroom.RequestFailed.prototype.name="mushroom.RequestFailed";mushroom.Signal=function Signal(){this.handlers=[]};mushroom.Signal.prototype.send=function(){var args=arguments;this.handlers.forEach(function(handler){handler.apply(this,args)}.bind(this))};mushroom.Signal.prototype.connect=function(handler){this.handlers.push(handler)};mushroom.Signal.prototype.disconnect=function(handler){var index=this.handlers.indexOf(handler);if(index!==-1){this.handlers.splice(index,1)}};mushroom.Signal.prototype.disconnectAll=function(){this.handlers.splice(0)};function createXHR(){try{return new window.XMLHttpRequest}catch(e){}try{return new window.ActiveXObject("Microsoft.XMLHTTP")}catch(e){}}var WEB_SOCKET_SUPPORT="WebSocket"in window;function post(url,data,callback,errorCallback){var xhr=createXHR();xhr.open("POST",url,true);xhr.onreadystatechange=function(){if(xhr.readyState===4){if(xhr.status==200){callback(xhr)}else{errorCallback(xhr)}}};if(data!==null){xhr.setRequestHeader("Content-Type","text/plain");xhr.send(JSON.stringify(data))}else{xhr.send(null)}}mushroom.Client=function(options){this.url=options.url;this.transports=options.transports||(WEB_SOCKET_SUPPORT?["ws","poll"]:["poll"]);this.transport=null;this.methods=options.methods||{};this.queue=new mushroom.MessageQueue;this.requests={};this.signals={error:new mushroom.Signal,connected:new mushroom.Signal,disconnected:new mushroom.Signal}};mushroom.Client.prototype.connect=function(auth){var request={transports:this.transports,auth:auth||null};post(this.url,request,function(xhr){var jsonResponse=JSON.parse(xhr.responseText);var TransportClass=mushroom.transports[jsonResponse.transport];if(TransportClass===undefined){this.signals.error.send(new mushroom.ConnectionError("Unsupported transport "+this.transport));return}this.transport=new TransportClass(this,jsonResponse);this.transport.start()}.bind(this),function(xhr){this.signals.error.send(new mushroom.ConnectionError("Transport negotiation failed. Status code="+xhr.status))}.bind(this))};mushroom.Client.prototype.disconnect=function(){this.sendMessage(new mushroom.Disconnect({client:this}))};mushroom.Client.prototype.method=function(name,callback){this.methods[name]=callback;return this};mushroom.Client.prototype.notify=function(method,data){var notification=new mushroom.Notification({client:this,method:method,data:data});this.queue.push(notification);this.sendMessage(notification)};mushroom.Client.prototype.popRequest=function(id){var request=this.requests[id];delete this.requests[id];return request};mushroom.Client.prototype.request=function(method,data,responseCallback,errorCallback){if(responseCallback===undefined){throw new Error("responseCallback is mandatory")}var request=new mushroom.Request({client:this,method:method,data:data,responseCallback:responseCallback,errorCallback:errorCallback});this.queue.push(request);this.requests[request.messageId]=request;this.sendMessage(request)};mushroom.Client.prototype.sendMessage=function(message){if(this.transport!==null&&this.transport.state==mushroom.STATE.CONNECTED){this.transport.sendMessage(message)}};mushroom.Client.prototype.handleNotification=function(notification){var method=this.methods[notification.method];if(method!==undefined){method.call(this,notification)}else{this.signals.error.send(new mushroom.Exception("No method for notification: "+notification.method))}};mushroom.ASYNC_RESPONSE={};mushroom.Client.prototype.handleRequest=function(request){var method=this.methods[request.method];if(method!==undefined){try{var response=method.call(this,request);if(response!==mushroom.ASYNC_RESPONSE){request.sendResponse(response)}}catch(e){request.sendError(e)}}else{this.signals.error.send(new mushroom.Exception("No method for request: "+request.method))}};mushroom.Client.prototype.handleResponse=function(response){var request=this.popRequest(response.requestMessageId);request.responseCallback(response.data)};mushroom.Client.prototype.handleError=function(error){var request=this.popRequest(error.requestMessageId);if(request.errorCallback===undefined){this.signals.error.send(new mushroom.RequestFailed(request,error))}else{request.errorCallback(error.data)}};mushroom.Client.prototype.handleDisconnect=function(){this.transport.stop();this.transport=null;this.signals.disconnected.send()};mushroom.MessageQueue=function(){this.nextMessageId=0;this.messages=[]};mushroom.MessageQueue.prototype.push=function(message){if(message.messageId!==null){throw new mushroom.Exception("Message does already have a message id")}message.messageId=this.nextMessageId;this.messages.push(message);this.nextMessageId+=1;return message.messageId};mushroom.MessageQueue.prototype.ack=function(messageId){if(messageId>=this.nextMessageId){throw new mushroom.Exception("Can not acknowledge a message id that was never part of this queue")}var i;for(i=0;i<this.messages.length;++i){var message=this.messages[i];if(message.messageId>messageId){break}}this.messages.splice(0,i)};mushroom.MessageQueue.prototype.forEach=function(f){var i;for(i=0;i<this.messages.length;++i){var message=this.messages[i];f(message)}};mushroom.STATE={DISCONNECTED:"DISCONNECTED",DISCONNECTING:"DISCONNECTING",CONNECTING:"CONNECTING",CONNECTED:"CONNECTED"};mushroom.PollTransport=function(client,options){this.client=client;this.url=options.url;this.lastMessageId=null;this.state=mushroom.STATE.DISCONNECTED};mushroom.PollTransport.prototype.start=function(){if(this.state!=mushroom.STATE.DISCONNECTED){throw new mushroom.IllegalState("Already started")}this.poll()};mushroom.PollTransport.prototype.stop=function(){if(this.state==mushroom.STATE.DISCONNECTED){throw new mushroom.IllegalState("Already stopped")}this.state=mushroom.STATE.DISCONNECTING};mushroom.PollTransport.prototype.poll=function(){this.state=mushroom.STATE.CONNECTED;this.client.signals.connected.send();this.client.queue.forEach(this.sendMessage.bind(this));var request=[[0,this.lastMessageId]];post(this.url,request,function(xhr){var data=JSON.parse(xhr.responseText);data.forEach(function(messageData){var message=mushroom.messageFromData(messageData,this.client);if("messageId"in message){if(message.messageId<=this.lastMessageId&&this.lastMessageId!==null){return}this.lastMessageId=message.messageId}var messageName=message.constructor.MESSAGE_NAME;var handler=this.client["handle"+messageName];handler.call(this.client,message)}.bind(this));if(this.state==mushroom.STATE.DISCONNECTING){this.state=mushroom.STATE.DISCONNECTED;this.client.signals.disconnected.send()}else{this.poll()}}.bind(this),function(){this.state=mushroom.STATE_DISCONNECTED;this.client.handleDisconnect()}.bind(this))};mushroom.PollTransport.prototype.sendMessage=function(message){var request=[message.toList()];post(this.url,request,function(){}.bind(this),function(){}.bind(this))};mushroom.WebSocketTransport=function(client,options){this.client=client;this.url=options.url;this.state=mushroom.STATE.DISCONNECTED};mushroom.WebSocketTransport.prototype.start=function(){this.ws=new WebSocket(this.url);this.ws.onopen=function(){this.state=mushroom.STATE.CONNECTED;this.client.queue.forEach(this.sendMessage.bind(this));this.client.signals.connected.send()}.bind(this);this.ws.onclose=function(){this.state=mushroom.STATE.DISCONNECTED;this.client.handleDisconnect()}.bind(this);this.ws.onmessage=function(event){var messageData=JSON.parse(event.data);var message=mushroom.messageFromData(messageData,this.client);if("messageId"in message){if(message.messageId<=this.lastMessageId&&this.lastMessageId!==null){return}this.lastMessageId=message.messageId}var messageName=message.constructor.MESSAGE_NAME;var handler=this.client["handle"+messageName];handler.call(this.client,message)}.bind(this)};mushroom.WebSocketTransport.prototype.stop=function(){if(this.ws!==null){this.ws.close();this.ws=null}};mushroom.WebSocketTransport.prototype.sendMessage=function(message){var data=message.toList();var frame=JSON.stringify(data);this.ws.send(frame)};mushroom.transports={poll:mushroom.PollTransport,ws:mushroom.WebSocketTransport};mushroom.Message=function(){};mushroom.Message.prototype.toList=function(){};mushroom.Heartbeat=function(options){this.client=options.client;this.lastMessageId=options.lastMessageId};mushroom.Heartbeat.MESSAGE_CODE=0;mushroom.Heartbeat.MESSAGE_NAME="Heartbeat";mushroom.Heartbeat.prototype.toList=function(){return[mushroom.Heartbeat.MESSAGE_CODE,this.lastMessageId]};mushroom.Notification=function(options){this.client=options.client;this.messageId=defaultIfUndefined(options.messageId,null);this.method=options.method;this.data=options.data};mushroom.Notification.MESSAGE_CODE=1;mushroom.Notification.MESSAGE_NAME="Notification";mushroom.Notification.prototype.toList=function(){return[mushroom.Notification.MESSAGE_CODE,this.messageId,this.method,this.data]};mushroom.Request=function(options){this.client=options.client;this.messageId=defaultIfUndefined(options.messageId,null);this.method=options.method;this.data=options.data||null;this.responseCallback=options.responseCallback;this.errorCallback=options.errorCallback};mushroom.Request.MESSAGE_CODE=2;mushroom.Request.MESSAGE_NAME="Request";mushroom.Request.prototype.toList=function(){return[mushroom.Request.MESSAGE_CODE,this.messageId,this.method,this.data]};mushroom.Request.prototype.sendResponse=function(data){var response=new mushroom.Response({client:this.client,requestMessageId:this.messageId,data:data});this.client.queue.push(response);this.client.sendMessage(response)};mushroom.Request.prototype.sendError=function(data){var error=new mushroom.Error({client:this.client,requestMessageId:this.messageId,data:data});this.client.queue.push(error);this.client.sendMessage(error)};mushroom.Response=function(options){this.client=options.client;this.messageId=defaultIfUndefined(options.messageId,null);this.requestMessageId=options.requestMessageId;this.data=options.data||null};mushroom.Response.MESSAGE_CODE=3;mushroom.Response.MESSAGE_NAME="Response";mushroom.Response.prototype.success=true;mushroom.Error=function(options){this.client=options.client;this.messageId=defaultIfUndefined(options.messageId,null);this.requestMessageId=options.requestMessageId;this.data=options.data||null};mushroom.Error.MESSAGE_CODE=4;mushroom.Error.MESSAGE_NAME="Error";mushroom.Error.prototype.success=false;mushroom.Error.prototype.toList=function(){return[mushroom.Error.MESSAGE_CODE,this.messageId,this.requestMessageId,this.data]};mushroom.Disconnect=function(options){this.client=options.client};mushroom.Disconnect.MESSAGE_CODE=-1;mushroom.Disconnect.MESSAGE_NAME="Disconnect";mushroom.Disconnect.prototype.toList=function(){return[mushroom.Disconnect.MESSAGE_CODE]};mushroom.messageFromData=function(data,client){switch(data[0]){case mushroom.Heartbeat.MESSAGE_CODE:return new mushroom.Heartbeat({client:client,lastMessageId:data[1]});case mushroom.Notification.MESSAGE_CODE:return new mushroom.Notification({client:client,messageId:data[1],method:data[2],data:data[3]});case mushroom.Request.MESSAGE_CODE:return new mushroom.Request({client:client,messageId:data[1],method:data[2],data:data[3]});case mushroom.Response.MESSAGE_CODE:return new mushroom.Response({client:client,messageId:data[1],requestMessageId:data[2],data:data[3]});case mushroom.Error.MESSAGE_CODE:return new mushroom.Error({client:client,messageId:data[1],requestMessageId:data[2],data:data[3]});case mushroom.Disconnect.MESSAGE_CODE:return new mushroom.Disconnect({client:client});default:throw new mushroom.Exception("Unsupported message code: "+data[0])}}})();