/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyser;
import infodynamics.demos.autoanalysis.AutoAnalyserChannelCalculator;
import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.measures.continuous.gaussian.TransferEntropyCalculatorGaussian;
import infodynamics.measures.continuous.kernel.TransferEntropyCalculatorKernel;
import infodynamics.measures.continuous.kraskov.TransferEntropyCalculatorKraskov;
import infodynamics.measures.discrete.TransferEntropyCalculatorDiscrete;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentListener;

public class AutoAnalyserTE
extends AutoAnalyserChannelCalculator
implements ActionListener,
DocumentListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected static final String DISCRETE_PROPNAME_K = "k_HISTORY";
    protected static final String DISCRETE_PROPNAME_K_TAU = "k_TAU";
    protected static final String DISCRETE_PROPNAME_L = "l_HISTORY";
    protected static final String DISCRETE_PROPNAME_L_TAU = "l_TAU";
    protected static final String DISCRETE_PROPNAME_DELAY = "DELAY";

    public AutoAnalyserTE() {
    }

    public AutoAnalyserTE(String string) {
        super(string);
    }

    @Override
    protected void makeSpecificInitialisations() {
        super.makeSpecificInitialisations();
        this.measureAcronym = "TE";
        this.appletTitle = "JIDT Transfer Entropy Auto-Analyser";
        this.calcTypes = new String[]{"Discrete", "Binned", "Gaussian", "Kraskov (KSG)", "Kernel"};
        this.unitsForEachCalc = new String[]{"bits", "bits", "nats", "nats", "bits"};
        this.discreteClass = TransferEntropyCalculatorDiscrete.class;
        this.discreteProperties = new String[]{"base", DISCRETE_PROPNAME_K, DISCRETE_PROPNAME_K_TAU, DISCRETE_PROPNAME_L, DISCRETE_PROPNAME_L_TAU, DISCRETE_PROPNAME_DELAY};
        this.discretePropertyDefaultValues = new String[]{"2", "1", "1", "1", "1", "1"};
        this.discretePropertyDescriptions = new String[]{"Number of discrete states available for each variable (i.e. 2 for binary)", "Destination history embedding length (k_HISTORY)", "Destination history embedding delay (k_TAU)", "Source history embedding length (l_HISTORY)", "Source history embeding delay (l_TAU)", "Delay from source to destination (in time steps)"};
        this.abstractContinuousClass = TransferEntropyCalculator.class;
        this.commonContPropertyNames = new String[]{DISCRETE_PROPNAME_K};
        this.commonContPropertiesFieldNames = new String[]{"K_PROP_NAME"};
        this.commonContPropertyDescriptions = new String[]{"Destination history embedding length (k_HISTORY)"};
        this.gaussianProperties = new String[]{DISCRETE_PROPNAME_K_TAU, DISCRETE_PROPNAME_L, DISCRETE_PROPNAME_L_TAU, DISCRETE_PROPNAME_DELAY};
        this.gaussianPropertiesFieldNames = new String[]{"TransferEntropyCalculator.K_TAU_PROP_NAME", "TransferEntropyCalculator.L_PROP_NAME", "TransferEntropyCalculator.L_TAU_PROP_NAME", "TransferEntropyCalculator.DELAY_PROP_NAME"};
        this.gaussianPropertyDescriptions = new String[]{"Destination history embedding delay (k_TAU)", "Source history embedding length (l_HISTORY)", "Source history embeding delay (l_TAU)", "Delay from source to destination (in time steps)"};
        this.kernelProperties = new String[]{"KERNEL_WIDTH", "DYN_CORR_EXCL", "NORMALISE"};
        this.kernelPropertiesFieldNames = new String[]{"KERNEL_WIDTH_PROP_NAME", "DYN_CORR_EXCL_TIME_NAME", "NORMALISE_PROP_NAME"};
        this.kernelPropertyDescriptions = new String[]{"Kernel width to be used in the calculation. <br/>If the property NORMALISE is set, then this is a number of standard deviations; otherwise it is an absolute value.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not  (recommended)"};
        this.kraskovProperties = new String[]{DISCRETE_PROPNAME_K_TAU, DISCRETE_PROPNAME_L, DISCRETE_PROPNAME_L_TAU, DISCRETE_PROPNAME_DELAY, "NORMALISE", "k", "NOISE_LEVEL_TO_ADD", "DYN_CORR_EXCL", "NORM_TYPE", "NUM_THREADS", "ALG_NUM", "AUTO_EMBED_METHOD", "AUTO_EMBED_K_SEARCH_MAX", "AUTO_EMBED_TAU_SEARCH_MAX", "AUTO_EMBED_RAGWITZ_NUM_NNS"};
        this.kraskovPropertiesFieldNames = new String[]{"TransferEntropyCalculator.K_TAU_PROP_NAME", "TransferEntropyCalculator.L_PROP_NAME", "TransferEntropyCalculator.L_TAU_PROP_NAME", "TransferEntropyCalculator.DELAY_PROP_NAME", "ConditionalMutualInfoMultiVariateCommon.PROP_NORMALISE", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_K", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_ADD_NOISE", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_DYN_CORR_EXCL_TIME", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_NORM_TYPE", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_NUM_THREADS", "PROP_KRASKOV_ALG_NUM", "PROP_AUTO_EMBED_METHOD", "PROP_K_SEARCH_MAX", "PROP_TAU_SEARCH_MAX", "PROP_RAGWITZ_NUM_NNS"};
        this.kraskovPropertyDescriptions = new String[]{"Destination history embedding delay (k_TAU)", "Source history embedding length (l)", "Source history embeding delay (l_TAU)", "Delay from source to destination (in time steps)", "(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not (recommended)", "Number of k nearest neighbours to use <br/>in the full joint kernel space in the KSG algorithm", "Standard deviation for an amount <br/>of random Gaussian noise to add to each variable, to avoid having neighbourhoods with artificially large counts. <br/>(\"false\" may be used to indicate \"0\".). The amount is added in after any normalisation.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "<br/>Norm type to use in KSG algorithm between the points in each marginal space. <br/>Options are: \"MAX_NORM\" (default), otherwise \"EUCLIDEAN\" or \"EUCLIDEAN_SQUARED\" (both equivalent here)", "Number of parallel threads to use <br/>in computation: an integer > 0 or \"USE_ALL\" (default, to indicate to use all available processors)", "Which KSG algorithm to use (1 or 2)", "Method to automatically determine embedding lengths (k_HISTORY,l_HISTORY)<br/> and delays (k_TAU, l_TAU) for destination and potentially source time-series. Default is \"NONE\" meaning values are set manually; other values include: <br/>  -- \"RAGWITZ\" for use of the Ragwitz criteria for both source and destination (searching up to \"AUTO_EMBED_K_SEARCH_MAX\" and \"AUTO_EMBED_TAU_SEARCH_MAX\"); <br/>  -- \"RAGWITZ_DEST_ONLY\" for use of the Ragwitz criteria for the destination only. <br/>  -- \"MAX_CORR_AIS\" for maximising the (bias corrected) Active Info Storage for both source and destination (searching up to \"AUTO_EMBED_K_SEARCH_MAX\" and \"AUTO_EMBED_TAU_SEARCH_MAX\"); <br/>  -- \"MAX_CORR_AIS_DEST_ONLY\" for maximising the (bias corrected) Active Info Storage for the destination only. <br/>Use of values other than \"NONE\" leads to any previous settings for embedding lengths and delays for the destination and perhaps source to be overwritten after observations are supplied", "Max. embedding length to search to <br/>if auto embedding (as determined by AUTO_EMBED_METHOD)", "Max. embedding delay to search to <br/>if auto embedding (as determined by AUTO_EMBED_METHOD)", "Number of k nearest neighbours for <br/>Ragwitz auto embedding (if used; defaults to match property \"k\")"};
    }

    @Override
    protected TransferEntropyCalculator assignCalcObjectContinuous(String string) throws Exception {
        if (string.equalsIgnoreCase("Gaussian")) {
            return new TransferEntropyCalculatorGaussian();
        }
        if (string.equalsIgnoreCase("Kraskov (KSG)")) {
            return new TransferEntropyCalculatorKraskov();
        }
        if (string.equalsIgnoreCase("Kernel")) {
            return new TransferEntropyCalculatorKernel();
        }
        throw new Exception("No recognised continuous calculator selected: " + string);
    }

    @Override
    protected AutoAnalyser.DiscreteCalcAndArguments assignCalcObjectDiscrete() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string;
        try {
            string = (String)this.propertyValues.get("base");
            n6 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property base");
            return null;
        }
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_K);
            n5 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property k_HISTORY");
            return null;
        }
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_K_TAU);
            n4 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property k_TAU");
            return null;
        }
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_L);
            n3 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property l_HISTORY");
            return null;
        }
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_L_TAU);
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property l_TAU");
            return null;
        }
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_DELAY);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property DELAY");
            return null;
        }
        return new AutoAnalyser.DiscreteCalcAndArguments(new TransferEntropyCalculatorDiscrete(n6, n5, n4, n3, n2, n), n6, n6 + ", " + n5 + ", " + n4 + ", " + n3 + ", " + n2 + ", " + n);
    }

    public static void main(String[] stringArray) {
        new AutoAnalyserTE();
    }
}

