/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.PredictiveInfoCalculator;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;

public class PredictiveInfoCalculatorViaMutualInfo
implements PredictiveInfoCalculator {
    protected MutualInfoCalculatorMultiVariate miCalc;
    protected int k = 1;
    protected int tau = 1;
    protected boolean debug = false;

    public PredictiveInfoCalculatorViaMutualInfo(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        MutualInfoCalculatorMultiVariate mutualInfoCalculatorMultiVariate = (MutualInfoCalculatorMultiVariate)clazz.newInstance();
        this.construct(mutualInfoCalculatorMultiVariate);
    }

    protected PredictiveInfoCalculatorViaMutualInfo(Class<MutualInfoCalculatorMultiVariate> clazz) throws InstantiationException, IllegalAccessException {
        MutualInfoCalculatorMultiVariate mutualInfoCalculatorMultiVariate = clazz.newInstance();
        this.construct(mutualInfoCalculatorMultiVariate);
    }

    protected PredictiveInfoCalculatorViaMutualInfo(MutualInfoCalculatorMultiVariate mutualInfoCalculatorMultiVariate) {
        this.construct(mutualInfoCalculatorMultiVariate);
    }

    protected void construct(MutualInfoCalculatorMultiVariate mutualInfoCalculatorMultiVariate) {
        this.miCalc = mutualInfoCalculatorMultiVariate;
    }

    @Override
    public void initialise() throws Exception {
        this.initialise(this.k, this.tau);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.tau);
    }

    @Override
    public void initialise(int n, int n2) throws Exception {
        this.k = n;
        this.tau = n2;
        this.miCalc.initialise(n, n);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        if (string.equalsIgnoreCase("TIME_DIFF")) {
            throw new Exception("Cannot set TIME_DIFF property on the PredictiveInfoCalculator");
        }
        boolean bl = true;
        if (string.equalsIgnoreCase("k_HISTORY") || string.equalsIgnoreCase("k_EMBEDDING")) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("TAU")) {
            this.tau = Integer.parseInt(string2);
        } else {
            this.miCalc.setProperty(string, string2);
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase("k_HISTORY") || string.equalsIgnoreCase("k_EMBEDDING")) {
            return Integer.toString(this.k);
        }
        if (string.equalsIgnoreCase("TAU")) {
            return Integer.toString(this.tau);
        }
        return this.miCalc.getProperty(string);
    }

    @Override
    public void setObservations(double[] dArray) throws Exception {
        if (dArray.length - 2 * (this.k - 1) * this.tau - 1 <= 0) {
            throw new Exception("Not enough observations to set here given k and tau");
        }
        double[][] dArray2 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.tau, (this.k - 1) * this.tau, dArray.length - 2 * (this.k - 1) * this.tau - 1);
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, 2 * (this.k - 1) * this.tau + 1, dArray.length - 2 * (this.k - 1) * this.tau - 1);
        this.miCalc.setObservations(dArray2, dArray3);
    }

    @Override
    public void startAddObservations() {
        this.miCalc.startAddObservations();
    }

    @Override
    public void addObservations(double[] dArray) throws Exception {
        if (dArray.length - 2 * (this.k - 1) * this.tau - 1 <= 0) {
            return;
        }
        double[][] dArray2 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.tau, (this.k - 1) * this.tau, dArray.length - 2 * (this.k - 1) * this.tau - 1);
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray, 1, 2 * (this.k - 1) * this.tau + 1, dArray.length - 2 * (this.k - 1) * this.tau - 1);
        this.miCalc.addObservations(dArray2, dArray3);
    }

    @Override
    public void addObservations(double[] dArray, int n, int n2) throws Exception {
        this.addObservations(MatrixUtils.select(dArray, n, n2));
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.miCalc.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[] dArray, boolean[] blArray) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    public Vector<int[]> computeStartAndEndTimePairs(boolean[] blArray) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < blArray.length; ++i) {
            if (bl) {
                if (blArray[i]) {
                    if (i - n < 2 * (this.k - 1) * this.tau + 1) continue;
                    n2 = i;
                    bl = false;
                    if (i != blArray.length - 1) continue;
                    int[] nArray = new int[]{n, n2};
                    vector.add(nArray);
                    continue;
                }
                n = i + 1;
                continue;
            }
            boolean bl2 = false;
            if (blArray[i]) {
                n2 = i;
            } else {
                bl2 = true;
            }
            if (i == blArray.length - 1) {
                bl2 = true;
            }
            if (!bl2) continue;
            int[] nArray = new int[]{n, n2};
            vector.add(nArray);
            bl = true;
            n = i + 1;
        }
        return vector;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        return this.miCalc.computeAverageLocalOfObservations();
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        double[] dArray = this.miCalc.computeLocalOfPreviousObservations();
        if (!this.miCalc.getAddedMoreThanOneObservationSet()) {
            double[] dArray2 = new double[dArray.length + 2 * (this.k - 1) * this.tau + 1];
            System.arraycopy(dArray, 0, dArray2, (this.k - 1) * this.tau + 1, dArray.length);
            return dArray2;
        }
        return dArray;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray) throws Exception {
        if (dArray.length - 2 * (this.k - 1) * this.tau - 1 <= 0) {
            return new double[dArray.length];
        }
        double[][] dArray2 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.tau, (this.k - 1) * this.tau, dArray.length - 2 * (this.k - 1) * this.tau - 1);
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray, 1, 2 * (this.k - 1) * this.tau + 1, dArray.length - 2 * (this.k - 1) * this.tau - 1);
        double[] dArray4 = this.miCalc.computeLocalUsingPreviousObservations(dArray2, dArray3);
        double[] dArray5 = new double[dArray4.length + 2 * (this.k - 1) * this.tau + 1];
        System.arraycopy(dArray4, 0, dArray5, (this.k - 1) * this.tau + 1, dArray4.length);
        return dArray5;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        return this.miCalc.computeSignificance(n);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        return this.miCalc.computeSignificance(nArray);
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
        this.miCalc.setDebug(bl);
    }

    @Override
    public double getLastAverage() {
        return this.miCalc.getLastAverage();
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.miCalc.getNumObservations();
    }
}

