/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.gaussian;

import infodynamics.measures.continuous.EntropyCalculatorMultiVariate;
import infodynamics.utils.MatrixUtils;

public class EntropyCalculatorMultiVariateGaussian
implements EntropyCalculatorMultiVariate,
Cloneable {
    protected double[][] L;
    protected double[] means;
    protected double[][] observations;
    protected int dimensions = 1;
    protected double detCovariance = 0.0;
    protected double lastAverage = 0.0;
    protected boolean debug = false;

    @Override
    public void initialise() throws Exception {
        this.initialise(this.dimensions);
    }

    @Override
    public void initialise(int n) {
        this.means = null;
        this.L = null;
        this.observations = null;
        this.dimensions = n;
        this.detCovariance = 0.0;
        this.lastAverage = 0.0;
    }

    @Override
    public void setObservations(double[][] dArray) throws Exception {
        if (dArray[0].length != this.dimensions) {
            this.means = null;
            this.L = null;
            throw new Exception("Supplied observations does not match initialised number of dimensions");
        }
        this.means = MatrixUtils.means(dArray);
        this.setCovariance(MatrixUtils.covarianceMatrix(dArray, this.means));
        this.observations = dArray;
    }

    public void setCovariance(double[][] dArray) throws Exception {
        this.detCovariance = 0.0;
        this.observations = null;
        int n = dArray.length;
        if (n != this.dimensions) {
            throw new Exception("Supplied covariance matrix does not match initialised number of dimensions");
        }
        this.L = MatrixUtils.CholeskyDecomposition(dArray);
    }

    public void setCovarianceAndMeans(double[][] dArray, double[] dArray2) throws Exception {
        this.setCovariance(dArray);
        if (dArray2.length != this.dimensions) {
            throw new Exception("Supplied mean matrix does not match initialised number of dimensions");
        }
        this.means = dArray2;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        this.detCovariance = MatrixUtils.determinantViaCholeskyResult(this.L);
        this.lastAverage = 0.5 * ((double)this.dimensions * (1.0 + Math.log(Math.PI * 2)) + Math.log(this.detCovariance));
        return this.lastAverage;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("NUM_DIMENSIONS")) {
            this.dimensions = Integer.parseInt(string2);
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase("NUM_DIMENSIONS")) {
            return Integer.toString(this.dimensions);
        }
        return null;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) throws Exception {
        if (this.means == null) {
            throw new Exception("Cannot compute local values without having means either supplied or computed via setObservations()");
        }
        if (this.detCovariance == 0.0) {
            this.detCovariance = MatrixUtils.determinantViaCholeskyResult(this.L);
            if (this.detCovariance == 0.0) {
                throw new Exception("Covariance matrix is not positive definite");
            }
        }
        double[][] dArray2 = MatrixUtils.solveViaCholeskyResult(this.L, MatrixUtils.identityMatrix(this.L.length));
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray4 = MatrixUtils.subtract(dArray[i], this.means);
            double d = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray4, dArray2), dArray4);
            double d2 = Math.pow(Math.PI * 2, -((double)this.dimensions) / 2.0) * Math.exp(-0.5 * d) / Math.sqrt(this.detCovariance);
            dArray3[i] = -Math.log(d2);
        }
        return dArray3;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        if (this.observations == null) {
            throw new Exception("Cannot compute local values since no observations were supplied");
        }
        return this.computeLocalUsingPreviousObservations(this.observations);
    }

    @Override
    public int getNumObservations() throws Exception {
        if (this.observations == null) {
            throw new Exception("Cannot return number of observations because either this calculator has not had observations supplied or the user supplied the covariance matrix instead of observations");
        }
        return this.observations.length;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

