/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.EntropyCalculator;
import infodynamics.measures.continuous.kernel.KernelEstimatorUniVariate;

public class EntropyCalculatorKernel
implements EntropyCalculator {
    protected KernelEstimatorUniVariate svke = new KernelEstimatorUniVariate();
    protected int totalObservations = 0;
    private double lastAverage;
    protected boolean debug = false;
    protected double[] observations;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    public static final double DEFAULT_EPSILON = 0.25;
    private double kernelWidth = 0.25;
    public static final String KERNEL_WIDTH_PROP_NAME = "KERNEL_WIDTH";
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public EntropyCalculatorKernel() {
        this.svke.setDebug(this.debug);
        this.svke.setNormalise(this.normalise);
        this.lastAverage = 0.0;
    }

    @Override
    public void initialise() {
        this.initialise(this.kernelWidth);
    }

    public void initialise(double d) {
        this.kernelWidth = d;
        this.lastAverage = 0.0;
        this.svke.initialise(d);
    }

    @Override
    public void setObservations(double[] dArray) {
        this.observations = dArray;
        this.svke.setObservations(dArray);
        this.totalObservations = dArray.length;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.observations.length; ++i) {
            double d2 = this.svke.getProbability(this.observations[i]);
            double d3 = Math.log(d2);
            d -= d3;
            if (!this.debug) continue;
            System.out.println(i + ": p(" + this.observations[i] + ")= " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
        if (this.svke != null) {
            this.svke.setDebug(bl);
        }
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.kernelWidth = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.svke.setNormalise(this.normalise);
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            return Double.toString(this.kernelWidth);
        }
        if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            return Boolean.toString(this.normalise);
        }
        return null;
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.totalObservations;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }
}

