/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.EntropyCalculatorMultiVariate;
import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;

public class EntropyCalculatorMultiVariateKernel
implements EntropyCalculatorMultiVariate {
    private KernelEstimatorMultiVariate mvke = new KernelEstimatorMultiVariate();
    private int totalObservations = 0;
    private boolean debug = false;
    private double[][] observations = null;
    private double lastEntropy;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    protected int dimensions = 1;
    private static final double DEFAULT_EPSILON = 0.25;
    private double kernelWidth = 0.25;
    public static final String KERNEL_WIDTH_PROP_NAME = "KERNEL_WIDTH";
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public EntropyCalculatorMultiVariateKernel() {
        this.mvke.setDebug(this.debug);
        this.mvke.setNormalise(this.normalise);
        this.lastEntropy = 0.0;
    }

    @Override
    public void initialise() throws Exception {
        this.initialise(this.dimensions);
    }

    @Override
    public void initialise(int n) {
        this.initialise(n, this.kernelWidth);
    }

    public void initialise(int n, double d) {
        this.kernelWidth = d;
        this.dimensions = n;
        this.mvke.initialise(n, d);
        this.lastEntropy = 0.0;
    }

    @Override
    public void setObservations(double[][] dArray) {
        this.mvke.setObservations(dArray);
        this.totalObservations = dArray.length;
        this.observations = dArray;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvke.getProbability(this.observations[i]);
            double d3 = Math.log(d2);
            d -= d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + -d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastEntropy = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastEntropy;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() {
        return this.computeLocalUsingPreviousObservations(true, this.observations);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) {
        return this.computeLocalUsingPreviousObservations(false, dArray);
    }

    protected double[] computeLocalUsingPreviousObservations(boolean bl, double[][] dArray) {
        double d = 0.0;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d2;
            double d3 = this.mvke.getProbability(dArray[i]);
            dArray2[i] = d2 = -Math.log(d3);
            d += d2;
            if (!this.debug) continue;
            System.out.println(i + ": " + d3 + " -> " + d2 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        d /= (double)this.totalObservations / Math.log(2.0);
        if (bl) {
            this.lastEntropy = d;
        }
        return dArray2;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
        this.mvke.setDebug(bl);
    }

    @Override
    public double getLastAverage() {
        return this.lastEntropy;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.kernelWidth = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.mvke.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase("NUM_DIMENSIONS")) {
            this.dimensions = Integer.parseInt(string2);
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            return Double.toString(this.kernelWidth);
        }
        if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            return Boolean.toString(this.normalise);
        }
        if (string.equalsIgnoreCase("NUM_DIMENSIONS")) {
            return Integer.toString(this.dimensions);
        }
        return null;
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.totalObservations;
    }
}

