/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.utils.MatrixUtils;
import java.util.Arrays;
import java.util.Vector;

public class KernelEstimatorUniVariate {
    private double suppliedKernelWidth = 0.1;
    private double kernelWidthInUse;
    private double min = 0.0;
    private double max = 0.0;
    private int bins = 0;
    private int totalObservations = 0;
    private TimeStampedObservation[][] sortedObservations = null;
    private boolean debug = false;
    private boolean normalise = true;
    private boolean excludeDynamicCorrelations = false;
    private int timeProximityForDynamicCorrelationExclusion = 100;

    public void initialise(double d) {
        this.suppliedKernelWidth = d;
        this.sortedObservations = null;
    }

    public void setObservations(double[] dArray) {
        this.setObservations(dArray, 0);
    }

    public void setObservations(double[] dArray, int n) {
        int n2;
        int n3;
        this.min = MatrixUtils.minStartFromIndex(dArray, n);
        this.max = MatrixUtils.maxStartFromIndex(dArray, n);
        this.totalObservations = dArray.length - n;
        if (this.normalise) {
            double d = MatrixUtils.stdDev(dArray);
            this.kernelWidthInUse = this.suppliedKernelWidth * d;
        } else {
            this.kernelWidthInUse = this.suppliedKernelWidth;
        }
        Vector[] vectorArray = null;
        this.bins = (int)Math.ceil((this.max - this.min) / this.kernelWidthInUse);
        if (this.bins == 0) {
            this.bins = 1;
        }
        if (this.debug) {
            System.out.println("Max: " + this.max + ", min: " + this.min + ", bins: " + this.bins);
        }
        vectorArray = new Vector[this.bins];
        for (n3 = 0; n3 < this.bins; ++n3) {
            vectorArray[n3] = new Vector();
        }
        for (n3 = n; n3 < dArray.length; ++n3) {
            n2 = this.getBinIndex(dArray[n3]);
            TimeStampedObservation timeStampedObservation = new TimeStampedObservation(n3, dArray[n3]);
            vectorArray[n2].add(timeStampedObservation);
        }
        this.sortedObservations = new TimeStampedObservation[this.bins][];
        n3 = 0;
        for (n2 = 0; n2 < this.bins; ++n2) {
            this.sortedObservations[n2] = new TimeStampedObservation[vectorArray[n2].size()];
            for (int i = 0; i < this.sortedObservations[n2].length; ++i) {
                this.sortedObservations[n2][i] = (TimeStampedObservation)vectorArray[n2].elementAt(i);
            }
            Arrays.sort(this.sortedObservations[n2]);
            n3 += this.sortedObservations[n2].length;
            if (!this.debug) continue;
            System.out.println("Num observations in bin " + n2 + ": " + this.sortedObservations[n2].length);
        }
        if (n3 != this.totalObservations) {
            throw new RuntimeException("We have not stored all observations");
        }
    }

    public double getProbability(double d) {
        return this.getProbability(d, 0, false);
    }

    public double getProbability(double d, int n) {
        return this.getProbability(d, n, this.excludeDynamicCorrelations);
    }

    private double getProbability(double d, int n, boolean bl) {
        int n2;
        int n3 = this.getBinIndex(d);
        int n4 = this.sortedObservations[n3].length;
        int n5 = this.totalObservations;
        if (bl) {
            n2 = n >= this.timeProximityForDynamicCorrelationExclusion ? this.timeProximityForDynamicCorrelationExclusion - 1 : n;
            n2 += this.totalObservations - n >= this.timeProximityForDynamicCorrelationExclusion ? this.timeProximityForDynamicCorrelationExclusion - 1 : this.totalObservations - n - 1;
            n5 -= ++n2;
            for (int i = 0; i < this.sortedObservations[n3].length; ++i) {
                if (Math.abs(this.sortedObservations[n3][i].timeStep - n) >= this.timeProximityForDynamicCorrelationExclusion) continue;
                --n4;
            }
        }
        if (this.debug) {
            System.out.println("Count from bin " + n3 + " = " + n4 + (bl ? "" : " no") + " dynamic correlation exclusion.");
        }
        if (n3 > 0) {
            for (n2 = this.sortedObservations[n3 - 1].length; n2 > 0 && this.sortedObservations[n3 - 1][n2 - 1].observation > d - this.kernelWidthInUse; --n2) {
                if (bl && Math.abs(this.sortedObservations[n3 - 1][n2 - 1].timeStep - n) >= this.timeProximityForDynamicCorrelationExclusion) continue;
                ++n4;
            }
        }
        if (this.debug) {
            System.out.println("Count after lower bin " + (n3 - 1) + " = " + n4);
        }
        if (n3 < this.bins - 1) {
            for (n2 = 0; n2 < this.sortedObservations[n3 + 1].length && this.sortedObservations[n3 + 1][n2].observation < d + this.kernelWidthInUse; ++n2) {
                if (bl && Math.abs(this.sortedObservations[n3 + 1][n2].timeStep - n) >= this.timeProximityForDynamicCorrelationExclusion) continue;
                ++n4;
            }
        }
        if (this.debug) {
            System.out.println("Count after upper bin " + (n3 + 1) + " = " + n4);
        }
        return (double)n4 / (double)n5 / (2.0 * this.kernelWidthInUse);
    }

    private int getBinIndex(double d) {
        int n = (int)Math.floor((d - this.min) / this.kernelWidthInUse);
        if (n >= this.bins) {
            n = this.bins - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isNormalise() {
        return this.normalise;
    }

    public void setNormalise(boolean bl) {
        this.normalise = bl;
    }

    public void setDynamicCorrelationExclusion(int n) {
        this.excludeDynamicCorrelations = true;
        this.timeProximityForDynamicCorrelationExclusion = n;
    }

    public void clearDynamicCorrelationExclusion() {
        this.excludeDynamicCorrelations = false;
    }

    public boolean isExcludeDynamicCorrelations() {
        return this.excludeDynamicCorrelations;
    }

    private class TimeStampedObservation
    implements Comparable {
        public int timeStep;
        public double observation;

        TimeStampedObservation(int n, double d) {
            this.timeStep = n;
            this.observation = d;
        }

        public int compareTo(Object object) {
            TimeStampedObservation timeStampedObservation = (TimeStampedObservation)object;
            if (this.observation < timeStampedObservation.observation) {
                return -1;
            }
            if (this.observation > timeStampedObservation.observation) {
                return 1;
            }
            return 0;
        }
    }
}

