/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.MutualInfoMultiVariateCommon;
import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;

public class MutualInfoCalculatorMultiVariateKernel
extends MutualInfoMultiVariateCommon
implements MutualInfoCalculatorMultiVariate,
Cloneable {
    protected KernelEstimatorMultiVariate mvkeSource = new KernelEstimatorMultiVariate();
    protected KernelEstimatorMultiVariate mvkeDest = new KernelEstimatorMultiVariate();
    protected KernelEstimatorMultiVariate mvkeJoint = new KernelEstimatorMultiVariate();
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean dynCorrExcl = false;
    private int dynCorrExclTime = 0;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    private boolean forceCompareToAll = false;
    public static final String FORCE_KERNEL_COMPARE_TO_ALL = "FORCE_KERNEL_COMPARE_TO_ALL";
    public static final double DEFAULT_KERNEL_WIDTH = 0.25;
    private double kernelWidth = 0.25;
    public static final String KERNEL_WIDTH_PROP_NAME = "KERNEL_WIDTH";
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public MutualInfoCalculatorMultiVariateKernel() {
        this.mvkeSource.setNormalise(this.normalise);
        this.mvkeDest.setNormalise(this.normalise);
        this.mvkeJoint.setNormalise(this.normalise);
    }

    @Override
    public void initialise(int n, int n2) {
        this.initialise(n, n2, this.kernelWidth);
    }

    public void initialise(int n, int n2, double d) {
        super.initialise(n, n2);
        this.kernelWidth = d;
        this.mvkeSource.initialise(n, d);
        this.mvkeDest.initialise(n2, d);
        this.mvkeJoint.initialise(n + n2, d);
    }

    @Override
    public void finaliseAddObservations() {
        try {
            super.finaliseAddObservations();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.mvkeSource.setObservations(this.sourceObservations);
        this.mvkeDest.setObservations(this.destObservations);
        try {
            this.mvkeJoint.setObservations(this.sourceObservations, this.destObservations);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unhandled exception from MultivariateKernelEstimator.setObservations(double[][], double[][])", exception);
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeSource.getProbability(this.sourceObservations[i], i);
            double d3 = this.mvkeDest.getProbability(this.destObservations[i], i);
            double d4 = this.mvkeJoint.getProbability(this.sourceObservations[i], this.destObservations[i], i);
            double d5 = 0.0;
            double d6 = 0.0;
            if (d4 > 0.0) {
                d5 = d4 / (d2 * d3);
                d6 = Math.log(d5);
            }
            d += d6;
            if (!this.debug) continue;
            System.out.printf("%d: (%.5f, %.5f, %.5f) %.5f -> %.5f -> %.5f\n", i, d2, d3, d4, d5, d6, d);
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        this.miComputed = true;
        return this.lastAverage;
    }

    public double computeAverageJointEntropy() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeJoint.getProbability(this.sourceObservations[i], this.destObservations[i], i);
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageEntropyOfObservation1() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeSource.getProbability(this.sourceObservations[i], i);
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageEntropyOfObservation2() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeDest.getProbability(this.destObservations[i], i);
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageInfoDistanceOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeSource.getProbability(this.sourceObservations[i], i);
            double d3 = this.mvkeDest.getProbability(this.destObservations[i], i);
            double d4 = this.mvkeJoint.getProbability(this.sourceObservations[i], this.destObservations[i], i);
            double d5 = 0.0;
            double d6 = 0.0;
            if (d4 > 0.0) {
                d5 = d2 * d3 / (d4 * d4);
                d6 = Math.log(d5);
            }
            d += d6;
            if (!this.debug) continue;
            System.out.println(i + ": " + d5 + " -> " + d6 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(this.sourceObservations, this.destObservations, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2) {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    protected double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2, boolean bl) {
        double d = 0.0;
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3;
            double d4;
            if (bl) {
                d4 = this.mvkeSource.getProbability(dArray[i], i);
                d3 = this.mvkeDest.getProbability(dArray2[i], i);
                d2 = this.mvkeJoint.getProbability(dArray[i], dArray2[i], i);
            } else {
                d4 = this.mvkeSource.getProbability(dArray[i]);
                d3 = this.mvkeDest.getProbability(dArray2[i]);
                d2 = this.mvkeJoint.getProbability(dArray[i], dArray2[i]);
            }
            double d5 = 0.0;
            dArray3[i] = 0.0;
            if (d2 > 0.0) {
                d5 = d2 / (d4 * d3);
                dArray3[i] = Math.log(d5) / Math.log(2.0);
            }
            d += dArray3[i];
            if (!this.debug) continue;
            System.out.printf("%d: (%.5f, %.5f, %.5f) %.5f -> %.5f -> %.5f\n", i, d4, d3, d2, d5, dArray3[i], d);
        }
        this.lastAverage = d / (double)this.totalObservations;
        this.miComputed = true;
        return dArray3;
    }

    public double[] computeLocalJointEntropyOfPreviousObservations() throws Exception {
        return this.computeLocalJointEntropyUsingPreviousObservations(this.sourceObservations, this.destObservations, true);
    }

    public double[] computeLocalJointEntropyUsingPreviousObservations(double[][] dArray, double[][] dArray2) {
        return this.computeLocalJointEntropyUsingPreviousObservations(dArray, dArray2, false);
    }

    private double[] computeLocalJointEntropyUsingPreviousObservations(double[][] dArray, double[][] dArray2, boolean bl) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = bl ? this.mvkeJoint.getProbability(this.sourceObservations[i], this.destObservations[i], i) : this.mvkeJoint.getProbability(this.sourceObservations[i], this.destObservations[i]);
            dArray3[i] = 0.0;
            if (d > 0.0) {
                dArray3[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray3[i]);
        }
        return dArray3;
    }

    public double[] computeLocalEntropy1OfPreviousObservations() {
        return this.computeLocalEntropyFromPreviousObservations(this.sourceObservations, 1, true);
    }

    public double[] computeLocalEntropy1UsingPreviousObservations(double[][] dArray) {
        return this.computeLocalEntropyFromPreviousObservations(dArray, 1, false);
    }

    public double[] computeLocalEntropy2OfPreviousObservations() {
        return this.computeLocalEntropyFromPreviousObservations(this.destObservations, 2, true);
    }

    public double[] computeLocalEntropy2UsingPreviousObservations(double[][] dArray) {
        return this.computeLocalEntropyFromPreviousObservations(dArray, 2, false);
    }

    private double[] computeLocalEntropyFromPreviousObservations(double[][] dArray, int n, boolean bl) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = n == 1 ? (bl ? this.mvkeSource.getProbability(dArray[i], i) : this.mvkeSource.getProbability(dArray[i])) : (bl ? this.mvkeDest.getProbability(dArray[i], i) : this.mvkeDest.getProbability(dArray[i]));
            dArray2[i] = 0.0;
            if (d > 0.0) {
                dArray2[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray2[i]);
        }
        return dArray2;
    }

    public double[] computeLocalInfoDistanceOfPreviousObservations() {
        return this.computeLocalInfoDistanceUsingPreviousObservations(this.sourceObservations, this.destObservations, true);
    }

    public double[] computeLocalInfoDistanceUsingPreviousObservations(double[][] dArray, double[][] dArray2) {
        return this.computeLocalInfoDistanceUsingPreviousObservations(dArray, dArray2, false);
    }

    protected double[] computeLocalInfoDistanceUsingPreviousObservations(double[][] dArray, double[][] dArray2, boolean bl) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            double d3;
            if (bl) {
                d3 = this.mvkeSource.getProbability(dArray[i], i);
                d2 = this.mvkeDest.getProbability(dArray2[i], i);
                d = this.mvkeJoint.getProbability(dArray[i], dArray2[i], i);
            } else {
                d3 = this.mvkeSource.getProbability(dArray[i]);
                d2 = this.mvkeDest.getProbability(dArray2[i]);
                d = this.mvkeJoint.getProbability(dArray[i], dArray2[i]);
            }
            double d4 = 0.0;
            dArray3[i] = 0.0;
            if (d > 0.0) {
                d4 = d3 * d2 / (d * d);
                dArray3[i] = Math.log(d4) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d4 + " -> " + dArray3[i]);
        }
        return dArray3;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.kernelWidth = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.mvkeSource.setNormalise(this.normalise);
            this.mvkeDest.setNormalise(this.normalise);
            this.mvkeJoint.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            boolean bl2 = this.dynCorrExcl = this.dynCorrExclTime > 0;
            if (this.dynCorrExcl) {
                this.mvkeSource.setDynamicCorrelationExclusion(this.dynCorrExclTime);
                this.mvkeDest.setDynamicCorrelationExclusion(this.dynCorrExclTime);
                this.mvkeJoint.setDynamicCorrelationExclusion(this.dynCorrExclTime);
            } else {
                this.mvkeSource.clearDynamicCorrelationExclusion();
                this.mvkeDest.clearDynamicCorrelationExclusion();
                this.mvkeJoint.clearDynamicCorrelationExclusion();
            }
        } else if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            this.forceCompareToAll = Boolean.parseBoolean(string2);
            this.mvkeSource.setForceCompareToAll(this.forceCompareToAll);
            this.mvkeDest.setForceCompareToAll(this.forceCompareToAll);
            this.mvkeJoint.setForceCompareToAll(this.forceCompareToAll);
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            return Double.toString(this.kernelWidth);
        }
        if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            return Boolean.toString(this.normalise);
        }
        if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            return Integer.toString(this.dynCorrExclTime);
        }
        if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            return Boolean.toString(this.forceCompareToAll);
        }
        return super.getProperty(string);
    }

    public double getKernelWidth() {
        return this.kernelWidth;
    }

    protected Object clone() throws CloneNotSupportedException {
        MutualInfoCalculatorMultiVariateKernel mutualInfoCalculatorMultiVariateKernel = (MutualInfoCalculatorMultiVariateKernel)super.clone();
        mutualInfoCalculatorMultiVariateKernel.mvkeSource = (KernelEstimatorMultiVariate)this.mvkeSource.clone();
        mutualInfoCalculatorMultiVariateKernel.mvkeDest = (KernelEstimatorMultiVariate)this.mvkeDest.clone();
        mutualInfoCalculatorMultiVariateKernel.mvkeJoint = (KernelEstimatorMultiVariate)this.mvkeJoint.clone();
        return mutualInfoCalculatorMultiVariateKernel;
    }
}

