/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.measures.continuous.TransferEntropyCommon;
import infodynamics.measures.continuous.kernel.KernelCount;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public class TransferEntropyCalculatorKernelPlain
extends TransferEntropyCommon
implements TransferEntropyCalculator {
    protected double[][] destNextPastSourceVectors;
    private static final int NEXT_PAST_SOURCE = 0;
    private static final int PAST_SOURCE = 1;
    private static final int NEXT_PAST = 2;
    private static final int PAST = 3;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean dynCorrExcl = false;
    private int dynCorrExclTime = 100;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    public static final double DEFAULT_EPSILON = 0.25;
    private double epsilon = 0.25;
    private double[] epsilons;
    public static final String EPSILON_PROP_NAME = "EPSILON";

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.epsilon);
    }

    public void initialise(int n, double d) throws Exception {
        this.epsilon = d;
        super.initialise(n);
    }

    @Override
    public void initialise() {
        this.destNextPastSourceVectors = null;
        this.epsilons = new double[this.k + 2];
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        if (string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.epsilon = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            this.dynCorrExcl = this.dynCorrExclTime > 0;
        } else {
            super.setProperty(string, string2);
        }
        if (this.debug) {
            System.out.println("Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) {
        if (string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            return Double.toString(this.epsilon);
        }
        if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            return Boolean.toString(this.normalise);
        }
        if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            return Integer.toString(this.dynCorrExclTime);
        }
        return super.getProperty(string);
    }

    @Override
    public void finaliseAddObservations() {
        Object object2;
        this.totalObservations = 0;
        for (Object object2 : this.vectorOfDestinationObservations) {
            this.totalObservations += ((double[])object2).length - this.k;
        }
        this.destNextPastSourceVectors = new double[this.totalObservations][this.k + 2];
        int n = 0;
        object2 = this.vectorOfDestinationObservations.iterator();
        for (double[] dArray : this.vectorOfSourceObservations) {
            double[] dArray2 = (double[])object2.next();
            double[][] dArray3 = this.makeJointVectorForNextPastSource(dArray2, dArray);
            MatrixUtils.arrayCopy(dArray3, 0, 0, this.destNextPastSourceVectors, n, 0, dArray3.length, this.k + 2);
            n += dArray2.length - this.k;
        }
        if (this.normalise) {
            for (int i = 0; i < this.k + 2; ++i) {
                double d = MatrixUtils.stdDev(this.destNextPastSourceVectors, i);
                this.epsilons[i] = this.epsilon * d;
            }
        } else {
            for (int i = 0; i < this.k + 2; ++i) {
                this.epsilons[i] = this.epsilon;
            }
        }
        boolean bl = this.addedMoreThanOneObservationSet = this.vectorOfDestinationObservations.size() > 1;
        if (this.addedMoreThanOneObservationSet && this.dynCorrExcl) {
            throw new RuntimeException("Addition of multiple observation sets is not currently supported with property DYN_CORR_EXCL set");
        }
        this.vectorOfSourceObservations = null;
        this.vectorOfDestinationObservations = null;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = 0.0;
        if (this.debug) {
            MatrixUtils.printMatrix(System.out, this.destNextPastSourceVectors);
        }
        for (int i = 0; i < this.totalObservations; ++i) {
            int[] nArray = this.getCounts(this.destNextPastSourceVectors[i], i);
            double d2 = 0.0;
            double d3 = 0.0;
            if (nArray[0] > 0) {
                d2 = (double)nArray[0] / (double)nArray[1] / ((double)nArray[2] / (double)nArray[3]);
                d3 = Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + this.destNextPastSourceVectors[i][0] + " (" + nArray[0] + " / " + nArray[1] + ") / (" + nArray[2] + " / " + nArray[3] + ") = " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWithCorrection() throws Exception {
        double d = 0.0;
        if (this.debug) {
            MatrixUtils.printMatrix(System.out, this.destNextPastSourceVectors);
        }
        for (int i = 0; i < this.totalObservations; ++i) {
            int[] nArray = this.getCounts(this.destNextPastSourceVectors[i], i);
            double d2 = 0.0;
            if (nArray[0] > 0) {
                d2 = MathsUtils.digamma(nArray[0]) - MathsUtils.digamma(nArray[1]) - MathsUtils.digamma(nArray[2]) + MathsUtils.digamma(nArray[3]);
            }
            d += d2;
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(null, null, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    private double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2, boolean bl) throws Exception {
        double[] dArray3;
        double[][] dArray4 = bl ? this.destNextPastSourceVectors : this.makeJointVectorForNextPastSource(dArray2, dArray);
        double d = 0.0;
        int n = dArray4.length;
        int n2 = 0;
        if (bl && this.addedMoreThanOneObservationSet) {
            dArray3 = new double[n];
            n2 = 0;
        } else {
            dArray3 = new double[n + this.k];
            n2 = this.k;
        }
        for (int i = 0; i < n; ++i) {
            int[] nArray = this.getCounts(dArray4[i], bl ? i : -1);
            double d2 = 0.0;
            double d3 = 0.0;
            if (nArray[0] > 0) {
                d2 = (double)nArray[0] / (double)nArray[1] / ((double)nArray[2] / (double)nArray[3]);
                d3 = Math.log(d2);
            }
            dArray3[n2 + i] = d3;
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)n / Math.log(2.0);
        return dArray3;
    }

    private double[][] makeJointVectorForNextPastSource(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length - this.k][this.k + 2];
        for (int i = this.k; i < dArray.length; ++i) {
            for (int j = 0; j < this.k + 1; ++j) {
                dArray3[i - this.k][j] = dArray[i - j];
            }
            dArray3[i - this.k][this.k + 1] = dArray2[i - 1];
        }
        return dArray3;
    }

    protected int[] getCounts(double[] dArray, int n) {
        int[] nArray = new int[4];
        for (int i = 0; i < this.totalObservations; ++i) {
            if (n >= 0 && this.dynCorrExcl && Math.abs(i - n) < this.dynCorrExclTime || !this.compareStateVectors(dArray, i, 1, this.k)) continue;
            nArray[3] = nArray[3] + 1;
            boolean bl = Math.abs(dArray[0] - this.destNextPastSourceVectors[i][0]) <= this.epsilons[0];
            boolean bl2 = Math.abs(dArray[this.k + 1] - this.destNextPastSourceVectors[i][this.k + 1]) <= this.epsilons[this.k + 1];
            nArray[2] = nArray[2] + (bl ? 1 : 0);
            nArray[1] = nArray[1] + (bl2 ? 1 : 0);
            nArray[0] = nArray[0] + (bl && bl2 ? 1 : 0);
        }
        return nArray;
    }

    protected boolean compareStateVectors(double[] dArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (!(Math.abs(dArray[n2 + i] - this.destNextPastSourceVectors[n][n2 + i]) > this.epsilons[n2 + i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        throw new RuntimeException("Not implemented in this calculator");
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        throw new RuntimeException("Not implemented in this calculator");
    }

    public KernelCount[][] computeMatchesForEachObservations(boolean bl) throws Exception {
        KernelCount[][] kernelCountArray = new KernelCount[this.totalObservations][4];
        for (int i = 0; i < this.totalObservations; ++i) {
            int[] nArray = this.getCounts(this.destNextPastSourceVectors[i], i);
            kernelCountArray[i] = new KernelCount[4];
            for (int j = 0; j < 4; ++j) {
                int n = 0;
                if (this.dynCorrExcl) {
                    int n2 = i >= this.dynCorrExclTime ? this.dynCorrExclTime - 1 : i;
                    n2 += this.totalObservations - i >= this.dynCorrExclTime ? this.dynCorrExclTime - 1 : this.totalObservations - i - 1;
                    n = this.totalObservations - ++n2;
                } else {
                    n = this.totalObservations;
                }
                kernelCountArray[i][j] = new KernelCount(nArray[j], n);
            }
        }
        return kernelCountArray;
    }
}

