/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.measures.continuous.TransferEntropyCommon;
import infodynamics.measures.continuous.kernel.KernelCount;
import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class TransferEntropyCalculatorKernelSeparate
extends TransferEntropyCommon
implements TransferEntropyCalculator {
    protected KernelEstimatorMultiVariate mvkeDestinationPast = new KernelEstimatorMultiVariate();
    protected KernelEstimatorMultiVariate mvkeDestinationNextPast = new KernelEstimatorMultiVariate();
    protected KernelEstimatorMultiVariate mvkeDestinationPastSource = new KernelEstimatorMultiVariate();
    protected KernelEstimatorMultiVariate mvkeDestinationNextPastSource = new KernelEstimatorMultiVariate();
    protected double[][] destPastVectors;
    protected double[][] destNextPastVectors;
    protected double[][] destPastSourceVectors;
    protected double[][] destNextPastSourceVectors;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean dynCorrExcl = false;
    private int dynCorrExclTime = 100;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    private boolean forceCompareToAll = false;
    public static final String FORCE_KERNEL_COMPARE_TO_ALL = "FORCE_KERNEL_COMPARE_TO_ALL";
    public static final double DEFAULT_EPSILON = 0.25;
    private double epsilon = 0.25;
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public TransferEntropyCalculatorKernelSeparate() {
        this.mvkeDestinationPast.setNormalise(this.normalise);
        this.mvkeDestinationNextPast.setNormalise(this.normalise);
        this.mvkeDestinationPastSource.setNormalise(this.normalise);
        this.mvkeDestinationNextPastSource.setNormalise(this.normalise);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.epsilon);
    }

    public void initialise(int n, double d) throws Exception {
        this.epsilon = d;
        super.initialise(n);
    }

    @Override
    public void initialise() throws Exception {
        this.mvkeDestinationPast.initialise(this.k, this.epsilon);
        this.mvkeDestinationNextPast.initialise(this.k + 1, this.epsilon);
        this.mvkeDestinationPastSource.initialise(this.k + 1, this.epsilon);
        this.mvkeDestinationNextPastSource.initialise(this.k + 2, this.epsilon);
        this.destPastVectors = null;
        this.destNextPastVectors = null;
        this.destPastSourceVectors = null;
        this.destNextPastSourceVectors = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        super.setProperty(string, string2);
        boolean bl = true;
        if (string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.epsilon = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.mvkeDestinationPast.setNormalise(this.normalise);
            this.mvkeDestinationNextPast.setNormalise(this.normalise);
            this.mvkeDestinationPastSource.setNormalise(this.normalise);
            this.mvkeDestinationNextPastSource.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            boolean bl2 = this.dynCorrExcl = this.dynCorrExclTime > 0;
            if (this.dynCorrExcl) {
                this.mvkeDestinationPast.setDynamicCorrelationExclusion(this.dynCorrExclTime);
                this.mvkeDestinationNextPast.setDynamicCorrelationExclusion(this.dynCorrExclTime);
                this.mvkeDestinationPastSource.setDynamicCorrelationExclusion(this.dynCorrExclTime);
                this.mvkeDestinationNextPastSource.setDynamicCorrelationExclusion(this.dynCorrExclTime);
            } else {
                this.mvkeDestinationPast.clearDynamicCorrelationExclusion();
                this.mvkeDestinationNextPast.clearDynamicCorrelationExclusion();
                this.mvkeDestinationPastSource.clearDynamicCorrelationExclusion();
                this.mvkeDestinationNextPastSource.clearDynamicCorrelationExclusion();
            }
        } else if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            this.forceCompareToAll = Boolean.parseBoolean(string2);
            this.mvkeDestinationPast.setForceCompareToAll(this.forceCompareToAll);
            this.mvkeDestinationNextPast.setForceCompareToAll(this.forceCompareToAll);
            this.mvkeDestinationPastSource.setForceCompareToAll(this.forceCompareToAll);
            this.mvkeDestinationNextPastSource.setForceCompareToAll(this.forceCompareToAll);
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println("Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) {
        if (string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            return Double.toString(this.epsilon);
        }
        if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            return Boolean.toString(this.normalise);
        }
        if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            return Integer.toString(this.dynCorrExclTime);
        }
        if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            return Boolean.toString(this.forceCompareToAll);
        }
        return super.getProperty(string);
    }

    @Override
    public void finaliseAddObservations() {
        Object object2;
        this.totalObservations = 0;
        for (Object object2 : this.vectorOfDestinationObservations) {
            this.totalObservations += ((double[])object2).length - this.k;
        }
        this.destPastVectors = new double[this.totalObservations][this.k];
        this.destNextPastVectors = new double[this.totalObservations][this.k + 1];
        this.destPastSourceVectors = new double[this.totalObservations][this.k + 1];
        this.destNextPastSourceVectors = new double[this.totalObservations][this.k + 2];
        int n = 0;
        object2 = this.vectorOfDestinationObservations.iterator();
        for (double[] dArray : this.vectorOfSourceObservations) {
            double[] dArray2 = (double[])object2.next();
            double[][] dArray3 = this.makeJointVectorForPast(dArray2);
            MatrixUtils.arrayCopy(dArray3, 0, 0, this.destPastVectors, n, 0, dArray3.length, this.k);
            double[][] dArray4 = this.makeJointVectorForNextPast(dArray2);
            MatrixUtils.arrayCopy(dArray4, 0, 0, this.destNextPastVectors, n, 0, dArray4.length, this.k + 1);
            double[][] dArray5 = this.makeJointVectorForPastSource(dArray2, dArray);
            MatrixUtils.arrayCopy(dArray5, 0, 0, this.destPastSourceVectors, n, 0, dArray5.length, this.k + 1);
            double[][] dArray6 = this.makeJointVectorForNextPastSource(dArray2, dArray);
            MatrixUtils.arrayCopy(dArray6, 0, 0, this.destNextPastSourceVectors, n, 0, dArray6.length, this.k + 2);
            n += dArray2.length - this.k;
        }
        this.mvkeDestinationPast.setObservations(this.destPastVectors);
        this.mvkeDestinationNextPast.setObservations(this.destNextPastVectors);
        this.mvkeDestinationPastSource.setObservations(this.destPastSourceVectors);
        this.mvkeDestinationNextPastSource.setObservations(this.destNextPastSourceVectors);
        boolean bl = this.addedMoreThanOneObservationSet = this.vectorOfDestinationObservations.size() > 1;
        if (this.addedMoreThanOneObservationSet && this.dynCorrExcl) {
            throw new RuntimeException("Addition of multiple observation sets is not currently supported with property DYN_CORR_EXCL set");
        }
        this.vectorOfSourceObservations = null;
        this.vectorOfDestinationObservations = null;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = 0.0;
        if (this.debug) {
            MatrixUtils.printMatrix(System.out, this.destNextPastSourceVectors);
        }
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeDestinationPast.getCount(this.destPastVectors[i], i);
            double d3 = this.mvkeDestinationNextPast.getCount(this.destNextPastVectors[i], i);
            double d4 = this.mvkeDestinationPastSource.getCount(this.destPastSourceVectors[i], i);
            double d5 = this.mvkeDestinationNextPastSource.getCount(this.destNextPastSourceVectors[i], i);
            double d6 = 0.0;
            double d7 = 0.0;
            if (d5 > 0.0) {
                d6 = d5 / d4 / (d3 / d2);
                d7 = Math.log(d6);
            }
            d += d7;
            if (!this.debug) continue;
            System.out.println(i + ": " + this.destPastVectors[i][0] + " (" + d5 + " / " + d4 + ") / (" + d3 + " / " + d2 + ") = " + d6 + " -> " + d7 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWithCorrection() throws Exception {
        double d = 0.0;
        if (this.debug) {
            MatrixUtils.printMatrix(System.out, this.destNextPastSourceVectors);
        }
        for (int i = 0; i < this.totalObservations; ++i) {
            int n = this.mvkeDestinationPast.getCount(this.destPastVectors[i], i);
            int n2 = this.mvkeDestinationNextPast.getCount(this.destNextPastVectors[i], i);
            int n3 = this.mvkeDestinationPastSource.getCount(this.destPastSourceVectors[i], i);
            int n4 = this.mvkeDestinationNextPastSource.getCount(this.destNextPastSourceVectors[i], i);
            double d2 = 0.0;
            if (n4 > 0) {
                d2 = MathsUtils.digamma(n4) - MathsUtils.digamma(n3) - MathsUtils.digamma(n2) + MathsUtils.digamma(n);
            }
            d += d2;
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(null, null, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    private double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2, boolean bl) throws Exception {
        double[] dArray3;
        double[][] dArray4;
        double[][] dArray5;
        double[][] dArray6;
        double[][] dArray7;
        if (bl) {
            dArray7 = this.destPastVectors;
            dArray6 = this.destNextPastVectors;
            dArray5 = this.destPastSourceVectors;
            dArray4 = this.destNextPastSourceVectors;
        } else {
            dArray7 = this.makeJointVectorForPast(dArray2);
            dArray6 = this.makeJointVectorForNextPast(dArray2);
            dArray5 = this.makeJointVectorForPastSource(dArray2, dArray);
            dArray4 = this.makeJointVectorForNextPastSource(dArray2, dArray);
        }
        double d = 0.0;
        int n = dArray7.length;
        int n2 = 0;
        if (bl && this.addedMoreThanOneObservationSet) {
            dArray3 = new double[n];
            n2 = 0;
        } else {
            dArray3 = new double[n + this.k];
            n2 = this.k;
        }
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3;
            double d4;
            double d5;
            if (bl) {
                d5 = this.mvkeDestinationPast.getCount(dArray7[i], i);
                d4 = this.mvkeDestinationNextPast.getCount(dArray6[i], i);
                d3 = this.mvkeDestinationPastSource.getCount(dArray5[i], i);
                d2 = this.mvkeDestinationNextPastSource.getCount(dArray4[i], i);
            } else {
                d5 = this.mvkeDestinationPast.getCount(dArray7[i]);
                d4 = this.mvkeDestinationNextPast.getCount(dArray6[i]);
                d3 = this.mvkeDestinationPastSource.getCount(dArray5[i]);
                d2 = this.mvkeDestinationNextPastSource.getCount(dArray4[i]);
            }
            double d6 = 0.0;
            double d7 = 0.0;
            if (d2 > 0.0) {
                d6 = d2 / d3 / (d4 / d5);
                d7 = Math.log(d6) / Math.log(2.0);
            }
            dArray3[n2 + i] = d7;
            d += d7;
            if (!this.debug) continue;
            System.out.println(i + ": " + d6 + " -> " + d7 + " -> sum: " + d);
        }
        this.lastAverage = d / (double)n;
        return dArray3;
    }

    private double[][] makeJointVectorForPastSource(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length - this.k][this.k + 1];
        for (int i = this.k; i < dArray.length; ++i) {
            for (int j = 0; j < this.k; ++j) {
                dArray3[i - this.k][j] = dArray[i - j - 1];
            }
            dArray3[i - this.k][this.k] = dArray2[i - 1];
        }
        return dArray3;
    }

    private double[][] makeJointVectorForNextPastSource(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length - this.k][this.k + 2];
        for (int i = this.k; i < dArray.length; ++i) {
            for (int j = 0; j < this.k + 1; ++j) {
                dArray3[i - this.k][j] = dArray[i - j];
            }
            dArray3[i - this.k][this.k + 1] = dArray2[i - 1];
        }
        return dArray3;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.totalObservations, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        double d = this.computeAverageLocalOfObservations();
        double[] dArray = MatrixUtils.selectColumn(this.destPastSourceVectors, this.k);
        int n2 = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        for (int i = 0; i < n; ++i) {
            double d2;
            if (nArray[i].length != this.totalObservations) {
                throw new Exception("Length " + nArray[i].length + " of reordering " + i + " in newOrderings does not " + " match the number of observations " + this.totalObservations);
            }
            MatrixUtils.reorderVectorIntoMatrix(dArray, nArray[i], this.destPastSourceVectors, this.k);
            MatrixUtils.reorderVectorIntoMatrix(dArray, nArray[i], this.destNextPastSourceVectors, this.k + 1);
            this.mvkeDestinationPastSource.initialise(this.k + 1, this.epsilon);
            this.mvkeDestinationNextPastSource.initialise(this.k + 2, this.epsilon);
            this.mvkeDestinationPastSource.setObservations(this.destPastSourceVectors);
            this.mvkeDestinationNextPastSource.setObservations(this.destNextPastSourceVectors);
            empiricalMeasurementDistribution.distribution[i] = d2 = this.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n2;
        }
        this.lastAverage = d;
        MatrixUtils.copyIntoColumn(this.destPastSourceVectors, this.k, dArray);
        MatrixUtils.copyIntoColumn(this.destNextPastSourceVectors, this.k + 1, dArray);
        this.mvkeDestinationPastSource.initialise(this.k + 1, this.epsilon);
        this.mvkeDestinationNextPastSource.initialise(this.k + 2, this.epsilon);
        this.mvkeDestinationPastSource.setObservations(this.destPastSourceVectors);
        this.mvkeDestinationNextPastSource.setObservations(this.destNextPastSourceVectors);
        empiricalMeasurementDistribution.pValue = (double)n2 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    public KernelCount[][] computeMatchesForEachObservations(boolean bl) throws Exception {
        KernelCount[][] kernelCountArray = new KernelCount[this.totalObservations][4];
        for (int i = 0; i < this.totalObservations; ++i) {
            kernelCountArray[i][0] = this.mvkeDestinationPast.getCompleteKernelCount(this.destPastVectors[i], i, bl);
            kernelCountArray[i][1] = this.mvkeDestinationNextPast.getCompleteKernelCount(this.destNextPastVectors[i], i, bl);
            kernelCountArray[i][2] = this.mvkeDestinationPastSource.getCompleteKernelCount(this.destPastSourceVectors[i], i, bl);
            kernelCountArray[i][3] = this.mvkeDestinationNextPastSource.getCompleteKernelCount(this.destNextPastSourceVectors[i], i, bl);
        }
        return kernelCountArray;
    }

    @Override
    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this.mvkeDestinationPast.setDebug(bl);
        this.mvkeDestinationNextPast.setDebug(bl);
        this.mvkeDestinationPastSource.setDebug(bl);
        this.mvkeDestinationNextPastSource.setDebug(bl);
    }
}

