/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kozachenko;

import infodynamics.measures.continuous.EntropyCalculator;
import infodynamics.measures.continuous.EntropyCalculatorMultiVariate;
import infodynamics.utils.EuclideanUtils;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public class EntropyCalculatorMultiVariateKozachenko
implements EntropyCalculator,
EntropyCalculatorMultiVariate {
    protected boolean debug = false;
    private int totalObservations = 0;
    private int dimensions = 1;
    protected double[][] rawData;
    private double lastAverage = 0.0;
    private double[] lastLocalEntropy = null;
    private boolean isComputed = false;
    public static final double EULER_MASCHERONI_CONSTANT = 0.5772156;

    @Override
    public void initialise() throws Exception {
        this.initialise(this.dimensions);
    }

    @Override
    public void initialise(int n) {
        this.dimensions = n;
        this.rawData = null;
        this.totalObservations = 0;
        this.isComputed = false;
        this.lastLocalEntropy = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("NUM_DIMENSIONS")) {
            this.dimensions = Integer.parseInt(string2);
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase("NUM_DIMENSIONS")) {
            return Integer.toString(this.dimensions);
        }
        return null;
    }

    @Override
    public void setObservations(double[][] dArray) {
        this.rawData = dArray;
        this.totalObservations = dArray.length;
        this.isComputed = false;
        this.lastLocalEntropy = null;
    }

    @Override
    public void setObservations(double[] dArray) {
        this.rawData = MatrixUtils.reshape(dArray, dArray.length, 1);
        this.setObservations(this.rawData);
    }

    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        int n = dArray.length;
        if (dArray == null || dArray2 == null) {
            throw new Exception("Cannot have null data arguments");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception("Length of data1 (" + dArray.length + ") is not equal to the length of data2 (" + dArray2.length + ")");
        }
        int n2 = dArray[0].length;
        int n3 = dArray2[0].length;
        double[][] dArray3 = new double[n][n2 + n3];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray3[i], 0, n2);
            System.arraycopy(dArray2[i], 0, dArray3[i], n2, n3);
        }
        this.setObservations(dArray3);
    }

    @Override
    public double computeAverageLocalOfObservations() {
        if (this.isComputed) {
            return this.lastAverage;
        }
        double d = this.sdTerm(this.totalObservations, this.dimensions);
        double d2 = this.eulerMacheroniTerm(this.totalObservations);
        double[] dArray = EuclideanUtils.computeMinEuclideanDistances(this.rawData);
        double d3 = 0.0;
        if (this.debug) {
            System.out.println("t,\tminDist,\tlogMinDist,\tsum");
        }
        for (int i = 0; i < this.rawData.length; ++i) {
            d3 += Math.log(2.0 * dArray[i]);
            if (!this.debug) continue;
            System.out.println(i + ",\t" + dArray[i] + ",\t" + Math.log(dArray[i]) + ",\t" + d3);
        }
        d3 *= (double)this.dimensions / (double)this.totalObservations;
        if (this.debug) {
            System.out.println("Sum part:   " + d3);
            System.out.println("Euler part: " + d2);
            System.out.println("Sd term:    " + d);
        }
        d3 += d2;
        this.lastAverage = d3 += d;
        this.isComputed = true;
        return d3;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() {
        if (this.lastLocalEntropy != null) {
            return this.lastLocalEntropy;
        }
        double d = this.sdTerm(this.totalObservations, this.dimensions);
        double d2 = this.eulerMacheroniTerm(this.totalObservations);
        double d3 = d + d2;
        double[] dArray = EuclideanUtils.computeMinEuclideanDistances(this.rawData);
        double d4 = 0.0;
        double[] dArray2 = new double[this.rawData.length];
        if (this.debug) {
            System.out.println("t,\tminDist,\tlogMinDist,\tlocal,\tsum");
        }
        for (int i = 0; i < this.rawData.length; ++i) {
            dArray2[i] = Math.log(2.0 * dArray[i]) * (double)this.dimensions;
            int n = i;
            dArray2[n] = dArray2[n] + d3;
            d4 += dArray2[i];
            if (!this.debug) continue;
            System.out.println(i + ",\t" + dArray[i] + ",\t" + Math.log(dArray[i]) + ",\t" + dArray2[i] + ",\t" + d4);
        }
        this.lastAverage = d4 /= (double)this.totalObservations;
        this.lastLocalEntropy = dArray2;
        return dArray2;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) throws Exception {
        throw new Exception("Local method for other data not implemented");
    }

    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2) throws Exception {
        throw new Exception("Local method for other data not implemented");
    }

    public double eulerMacheroniTerm(int n) {
        try {
            return -MathsUtils.digamma(1) + MathsUtils.digamma(n);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public double sdTerm(int n, int n2) {
        double d = Math.pow(0.7853981633974483, (double)n2 / 2.0);
        double d2 = 0.0;
        if (n2 % 2 == 0) {
            for (int i = n2 / 2; i > 1; --i) {
                d2 -= Math.log(i);
            }
        } else {
            d *= Math.pow(2.0, (double)(n2 + 1) / 2.0);
            d /= Math.sqrt(Math.PI);
            for (int i = n2; i > 1; i -= 2) {
                d2 -= Math.log(i);
            }
        }
        return d2 += Math.log(d);
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public int getNumObservations() {
        return this.totalObservations;
    }
}

