/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.NeighbourNodeData;
import java.util.Calendar;
import java.util.PriorityQueue;

public class ConditionalMutualInfoCalculatorMultiVariateKraskov1
extends ConditionalMutualInfoCalculatorMultiVariateKraskov {
    public ConditionalMutualInfoCalculatorMultiVariateKraskov1() {
        this.isAlgorithm1 = true;
    }

    @Override
    protected double[] partialComputeFromObservations(int n, int n2, boolean bl) throws Exception {
        long l;
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray = null;
        if (bl) {
            dArray = new double[n2];
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean[] blArray = new boolean[this.totalObservations];
        int[] nArray = new int[this.totalObservations + 1];
        for (int i = n; i < n + n2; ++i) {
            int n3;
            l = Calendar.getInstance().getTimeInMillis();
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            l2 += Calendar.getInstance().getTimeInMillis() - l;
            NeighbourNodeData neighbourNodeData = priorityQueue.poll();
            if (this.debug) {
                l = Calendar.getInstance().getTimeInMillis();
            }
            if (this.dimensionsCond > 0) {
                this.nnSearcherConditional.findPointsWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime, false, blArray, nArray);
            }
            if (this.debug) {
                l3 += Calendar.getInstance().getTimeInMillis() - l;
                l = Calendar.getInstance().getTimeInMillis();
            }
            int n4 = this.dimensionsCond == 0 ? (this.dimensionsVar1 > 1 ? this.kdTreeVar1Conditional.countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime) : this.uniNNSearcherVar1.countPointsWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime, false)) : (this.dimensionsVar1 > 1 ? this.kdTreeVar1Conditional.countPointsWithinR(i, neighbourNodeData.distance, false, 1, blArray) : this.uniNNSearcherVar1.countPointsWithinR(i, neighbourNodeData.distance, false, blArray));
            if (this.debug) {
                l4 += Calendar.getInstance().getTimeInMillis() - l;
                l = Calendar.getInstance().getTimeInMillis();
            }
            int n5 = this.dimensionsCond == 0 ? (this.dimensionsVar2 > 1 ? this.kdTreeVar2Conditional.countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime) : this.uniNNSearcherVar2.countPointsWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime, false)) : (this.dimensionsVar2 > 1 ? this.kdTreeVar2Conditional.countPointsWithinR(i, neighbourNodeData.distance, false, 1, blArray) : this.uniNNSearcherVar2.countPointsWithinR(i, neighbourNodeData.distance, false, blArray));
            if (this.debug) {
                l5 += Calendar.getInstance().getTimeInMillis() - l;
            }
            if (this.dimensionsCond == 0) {
                n3 = this.totalObservations - 1;
            } else {
                n3 = 0;
                while (nArray[n3] != -1) {
                    blArray[nArray[n3]] = false;
                    ++n3;
                }
            }
            d3 += (double)n4;
            d4 += (double)n5;
            d5 += (double)n3;
            double d6 = MathsUtils.digamma(n4 + 1);
            double d7 = MathsUtils.digamma(n5 + 1);
            double d8 = MathsUtils.digamma(n3 + 1);
            d2 += d8 - d6 - d7;
            if (bl) {
                dArray[i - n] = this.digammaK - d6 - d7 + d8;
                if (!this.debug) continue;
                System.out.printf("t=%d, r=%.5f, n_xz=%d, n_yz=%d, n_z=%d, local=%.4f, digamma(n_xz+1)=%.5f, digamma(n_yz+1)=%.5f, digamma(n_z+1)=%.5f, \n", i, neighbourNodeData.distance, n4, n5, n3, dArray[i - n], d6, d7, d8);
                continue;
            }
            if (!this.debug) continue;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, digamma(n_xz+1)=%.5f, digamma(n_yz+1)=%.5f, digamma(n_z+1)=%.5f, \n", i, n4, n5, n3, d6, d7, d8);
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
            System.out.println("Total exec times for: ");
            System.out.println("\tknn search: " + (double)l2 / 1000.0);
            System.out.println("\tz   search: " + (double)l3 / 1000.0);
            System.out.println("\tzx  search: " + (double)l4 / 1000.0);
            System.out.println("\tzy  search: " + (double)l5 / 1000.0);
            System.out.printf("%d:%d -- Returning: %.4f, %.4f, %.4f, %.4f\n", n, n + n2, d2, d3, d4, d5);
        }
        if (bl) {
            return dArray;
        }
        double[] dArray2 = new double[6];
        dArray2[0] = d2;
        dArray2[1] = d3;
        dArray2[2] = d4;
        dArray2[3] = d5;
        return dArray2;
    }

    @Override
    protected double[] partialComputeFromNewObservations(int n, int n2, double[][] dArray, double[][] dArray2, double[][] dArray3, boolean bl) throws Exception {
        long l;
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray4 = null;
        if (bl) {
            dArray4 = new double[n2];
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean[] blArray = new boolean[this.totalObservations];
        int[] nArray = new int[this.totalObservations + 1];
        for (int i = n; i < n + n2; ++i) {
            int n3;
            l = Calendar.getInstance().getTimeInMillis();
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, new double[][]{dArray[i], dArray2[i], dArray3[i]});
            l2 += Calendar.getInstance().getTimeInMillis() - l;
            NeighbourNodeData neighbourNodeData = priorityQueue.poll();
            if (this.debug) {
                System.out.print("t = " + i + " : for data point: ");
                MatrixUtils.printArray(System.out, dArray[i]);
                MatrixUtils.printArray(System.out, dArray2[i]);
                if (this.dimensionsCond > 0) {
                    MatrixUtils.printArray(System.out, dArray3[i]);
                } else {
                    System.out.print("[]");
                }
                System.out.printf("t=%d : K=%d NNs found at range %.5f (point %d)\n", i, this.k, neighbourNodeData.distance, neighbourNodeData.sampleIndex);
            }
            if (this.debug) {
                l = Calendar.getInstance().getTimeInMillis();
            }
            if (this.dimensionsCond > 0) {
                this.nnSearcherConditional.findPointsWithinR(neighbourNodeData.distance, new double[][]{dArray3[i]}, false, blArray, nArray);
            }
            if (this.debug) {
                l3 += Calendar.getInstance().getTimeInMillis() - l;
                l = Calendar.getInstance().getTimeInMillis();
            }
            int n4 = this.dimensionsCond == 0 ? (this.dimensionsVar1 > 1 ? this.kdTreeVar1Conditional.countPointsWithinR(new double[][]{dArray[i], dArray3[i]}, neighbourNodeData.distance, false) : this.uniNNSearcherVar1.countPointsWithinR(new double[][]{dArray[i]}, neighbourNodeData.distance, false)) : (this.dimensionsVar1 > 1 ? this.kdTreeVar1Conditional.countPointsWithinR(neighbourNodeData.distance, new double[][]{dArray[i], dArray3[i]}, false, 1, blArray) : this.uniNNSearcherVar1.countPointsWithinR(new double[][]{dArray[i]}, neighbourNodeData.distance, false, blArray));
            if (this.debug) {
                l4 += Calendar.getInstance().getTimeInMillis() - l;
                l = Calendar.getInstance().getTimeInMillis();
            }
            int n5 = this.dimensionsCond == 0 ? (this.dimensionsVar2 > 1 ? this.kdTreeVar2Conditional.countPointsWithinR(new double[][]{dArray2[i], dArray3[i]}, neighbourNodeData.distance, false) : this.uniNNSearcherVar2.countPointsWithinR(new double[][]{dArray2[i]}, neighbourNodeData.distance, false)) : (this.dimensionsVar2 > 1 ? this.kdTreeVar2Conditional.countPointsWithinR(neighbourNodeData.distance, new double[][]{dArray2[i], dArray3[i]}, false, 1, blArray) : this.uniNNSearcherVar2.countPointsWithinR(new double[][]{dArray2[i]}, neighbourNodeData.distance, false, blArray));
            if (this.debug) {
                l5 += Calendar.getInstance().getTimeInMillis() - l;
            }
            if (this.dimensionsCond == 0) {
                n3 = this.totalObservations - 1;
            } else {
                n3 = 0;
                while (nArray[n3] != -1) {
                    blArray[nArray[n3]] = false;
                    ++n3;
                }
            }
            d3 += (double)n4;
            d4 += (double)n5;
            d5 += (double)n3;
            double d6 = MathsUtils.digamma(n4 + 1);
            double d7 = MathsUtils.digamma(n5 + 1);
            double d8 = MathsUtils.digamma(n3 + 1);
            d2 += d8 - d6 - d7;
            if (bl) {
                dArray4[i - n] = this.digammaK - d6 - d7 + d8;
                if (!this.debug) continue;
                System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, local=%.4f, digamma(n_xz+1)=%.5f, digamma(n_yz+1)=%.5f, digamma(n_z+1)=%.5f, \n", i, n4, n5, n3, dArray4[i - n], d6, d7, d8);
                continue;
            }
            if (!this.debug) continue;
            double d9 = this.digammaK - d6 - d7 + d8;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, local=%.4f, digamma(n_xz+1)=%.5f, digamma(n_yz+1)=%.5f, digamma(n_z+1)=%.5f, \n", i, n4, n5, n3, d9, d6, d7, d8);
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
            System.out.println("Total exec times for: ");
            System.out.println("\tknn search: " + (double)l2 / 1000.0);
            System.out.println("\tz   search: " + (double)l3 / 1000.0);
            System.out.println("\tzx  search: " + (double)l4 / 1000.0);
            System.out.println("\tzy  search: " + (double)l5 / 1000.0);
            System.out.printf("%d:%d -- Returning: %.4f, %.4f, %.4f, %.4f\n", n, n + n2, d2, d3, d4, d5);
        }
        if (bl) {
            return dArray4;
        }
        double[] dArray5 = new double[6];
        dArray5[0] = d2;
        dArray5[1] = d3;
        dArray5[2] = d4;
        dArray5[3] = d5;
        return dArray5;
    }
}

