/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.MultiInfoCalculatorCommon;
import infodynamics.utils.KdTree;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.UnivariateNearestNeighbourSearcher;
import java.util.Calendar;
import java.util.Random;

public abstract class MultiInfoCalculatorKraskov
extends MultiInfoCalculatorCommon
implements Cloneable {
    protected int k = 4;
    protected int normType = 2;
    public static final String PROP_K = "k";
    public static final String PROP_NORM_TYPE = "NORM_TYPE";
    public static final String PROP_ADD_NOISE = "NOISE_LEVEL_TO_ADD";
    public static final String PROP_DYN_CORR_EXCL_TIME = "DYN_CORR_EXCL";
    public static final String PROP_NUM_THREADS = "NUM_THREADS";
    public static final String USE_ALL_THREADS = "USE_ALL";
    protected boolean addNoise = true;
    protected double noiseLevel = 1.0E-8;
    protected boolean dynCorrExcl = false;
    protected int dynCorrExclTime = 0;
    protected int numThreads = Runtime.getRuntime().availableProcessors();
    protected boolean isAlgorithm1 = false;
    protected KdTree kdTreeJoint;
    protected UnivariateNearestNeighbourSearcher[] rangeSearchersInMarginals;
    protected double digammaK;
    protected double digammaN;

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.kdTreeJoint = null;
        this.rangeSearchersInMarginals = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(PROP_K)) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_NORM_TYPE)) {
            this.normType = KdTree.validateNormType(string2);
        } else if (string.equalsIgnoreCase(PROP_DYN_CORR_EXCL_TIME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            this.dynCorrExcl = this.dynCorrExclTime > 0;
        } else if (string.equalsIgnoreCase(PROP_ADD_NOISE)) {
            if (string2.equals("0") || string2.equalsIgnoreCase("false")) {
                this.addNoise = false;
                this.noiseLevel = 0.0;
            } else {
                this.addNoise = true;
                this.noiseLevel = Double.parseDouble(string2);
            }
        } else if (string.equalsIgnoreCase(PROP_NUM_THREADS)) {
            this.numThreads = string2.equalsIgnoreCase(USE_ALL_THREADS) ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(string2);
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase(PROP_K)) {
            return Integer.toString(this.k);
        }
        if (string.equalsIgnoreCase(PROP_NORM_TYPE)) {
            return KdTree.convertNormTypeToString(this.normType);
        }
        if (string.equalsIgnoreCase(PROP_DYN_CORR_EXCL_TIME)) {
            return Integer.toString(this.dynCorrExclTime);
        }
        if (string.equalsIgnoreCase(PROP_ADD_NOISE)) {
            return Double.toString(this.noiseLevel);
        }
        if (string.equalsIgnoreCase(PROP_NUM_THREADS)) {
            return Integer.toString(this.numThreads);
        }
        return super.getProperty(string);
    }

    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        int n;
        int n2;
        if (dArray == null || dArray[0].length == 0 || dArray2 == null || dArray2[0].length == 0) {
            throw new Exception("Computing MI with a null set of data");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception("Length of the time series to be joined to not match");
        }
        if (dArray[0].length + dArray2[0].length != this.dimensions) {
            throw new Exception("Incorrect number of dimensions " + (dArray[0].length + dArray2[0].length) + " in supplied observations (expected " + this.dimensions + ")");
        }
        this.totalObservations = dArray.length;
        this.observations = new double[this.totalObservations][this.dimensions];
        for (int i = 0; i < this.totalObservations; ++i) {
            n2 = 0;
            for (n = 0; n < dArray[i].length; ++n) {
                this.observations[i][n2++] = dArray[i][n];
            }
            for (n = 0; n < dArray2[i].length; ++n) {
                this.observations[i][n2++] = dArray2[i][n];
            }
        }
        if (this.normalise) {
            MatrixUtils.normalise(this.observations);
        }
        if (this.addNoise) {
            Random random = new Random();
            for (n2 = 0; n2 < this.observations.length; ++n2) {
                n = 0;
                while (n < this.dimensions) {
                    double[] dArray3 = this.observations[n2];
                    int n3 = n++;
                    dArray3[n3] = dArray3[n3] + random.nextGaussian() * this.noiseLevel;
                }
            }
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        super.finaliseAddObservations();
        if (this.dynCorrExcl && this.addedMoreThanOneObservationSet) {
            throw new RuntimeException("Addition of multiple observation sets is not currently supported with property DYN_CORR_EXCL set");
        }
        if (this.totalObservations <= this.k + 2 * this.dynCorrExclTime) {
            throw new Exception("There are less observations provided (" + this.totalObservations + ") than required for the number of nearest neighbours parameter (" + this.k + ") and any dynamic correlation exclusion (" + this.dynCorrExclTime + ")");
        }
        if (this.normalise) {
            this.observations = MatrixUtils.normaliseIntoNewArray(this.observations);
        }
        if (this.addNoise) {
            Random random = new Random();
            for (int i = 0; i < this.observations.length; ++i) {
                int n = 0;
                while (n < this.dimensions) {
                    double[] dArray = this.observations[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] + random.nextGaussian() * this.noiseLevel;
                }
            }
        }
        this.digammaK = MathsUtils.digamma(this.k);
        this.digammaN = MathsUtils.digamma(this.totalObservations);
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        this.lastAverage = this.computeFromObservations(false)[0];
        this.miComputed = true;
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        double[] dArray = this.computeFromObservations(true);
        this.lastAverage = MatrixUtils.mean(dArray);
        this.miComputed = true;
        return dArray;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) throws Exception {
        throw new Exception("Local method not implemented yet");
    }

    protected double[] computeFromObservations(boolean bl) throws Exception {
        Object[] objectArray;
        int n;
        double[] dArray = null;
        Object object = null;
        int[] nArray = null;
        if (this.kdTreeJoint == null) {
            object = new double[this.dimensions][][];
            nArray = new int[this.dimensions];
            for (n = 0; n < this.dimensions; ++n) {
                object[n] = MatrixUtils.selectColumns(this.observations, new int[]{n});
                nArray[n] = 1;
            }
            this.kdTreeJoint = new KdTree(nArray, (double[][][])object);
            this.kdTreeJoint.setNormType(this.normType);
        }
        if (this.rangeSearchersInMarginals == null) {
            this.rangeSearchersInMarginals = new UnivariateNearestNeighbourSearcher[this.dimensions];
            for (n = 0; n < this.dimensions; ++n) {
                this.rangeSearchersInMarginals[n] = new UnivariateNearestNeighbourSearcher(MatrixUtils.selectColumn(this.observations, n));
                this.rangeSearchersInMarginals[n].setNormType(this.normType);
            }
        }
        if (this.numThreads == 1) {
            dArray = this.partialComputeFromObservations(0, this.totalObservations, bl);
        } else {
            int n2;
            dArray = bl ? new double[this.totalObservations] : new double[1 + this.dimensions];
            n = this.totalObservations / this.numThreads;
            int n3 = this.totalObservations % this.numThreads;
            if (this.debug) {
                System.out.printf("Computing Kraskov Multi-Info with %d threads (%d timesteps each, plus %d residual)\n", this.numThreads, n, n3);
            }
            objectArray = new Thread[this.numThreads];
            MultiInfoKraskovThreadRunner[] multiInfoKraskovThreadRunnerArray = new MultiInfoKraskovThreadRunner[this.numThreads];
            for (n2 = 0; n2 < this.numThreads; ++n2) {
                int n4;
                int n5 = n2 == 0 ? 0 : n * n2 + n3;
                int n6 = n4 = n2 == 0 ? n + n3 : n;
                if (this.debug) {
                    System.out.println(n2 + ".Thread: from " + n5 + " to " + (n5 + n4));
                }
                multiInfoKraskovThreadRunnerArray[n2] = new MultiInfoKraskovThreadRunner(this, n5, n4, bl);
                objectArray[n2] = (double)new Thread(multiInfoKraskovThreadRunnerArray[n2]);
                objectArray[n2].start();
            }
            for (n2 = 0; n2 < this.numThreads; ++n2) {
                if (objectArray[n2] != null) {
                    objectArray[n2].join();
                }
                if (bl) {
                    System.arraycopy(multiInfoKraskovThreadRunnerArray[n2].getReturnValues(), 0, dArray, multiInfoKraskovThreadRunnerArray[n2].myStartTimePoint, multiInfoKraskovThreadRunnerArray[n2].numberOfTimePoints);
                    continue;
                }
                MatrixUtils.addInPlace(dArray, multiInfoKraskovThreadRunnerArray[n2].getReturnValues());
            }
        }
        if (bl) {
            return dArray;
        }
        double d = dArray[0] / (double)this.totalObservations;
        objectArray = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            objectArray[i] = dArray[1 + i] / (double)this.totalObservations;
            if (!this.debug) continue;
            System.out.printf("Average n_%d=%.3f, ", i, objectArray[i]);
        }
        if (this.debug) {
            System.out.println();
        }
        if (this.isAlgorithm1) {
            return new double[]{this.digammaK - d + (double)(this.dimensions - 1) * this.digammaN};
        }
        return new double[]{this.digammaK - (double)(this.dimensions - 1) / (double)this.k - d + (double)(this.dimensions - 1) * this.digammaN};
    }

    protected abstract double[] partialComputeFromObservations(int var1, int var2, boolean var3) throws Exception;

    private class MultiInfoKraskovThreadRunner
    implements Runnable {
        protected MultiInfoCalculatorKraskov miCalc;
        protected int myStartTimePoint;
        protected int numberOfTimePoints;
        protected boolean computeLocals;
        protected double[] returnValues = null;
        protected Exception problem = null;
        public static final int INDEX_SUM_DIGAMMAS = 0;

        public MultiInfoKraskovThreadRunner(MultiInfoCalculatorKraskov multiInfoCalculatorKraskov2, int n, int n2, boolean bl) {
            this.miCalc = multiInfoCalculatorKraskov2;
            this.myStartTimePoint = n;
            this.numberOfTimePoints = n2;
            this.computeLocals = bl;
        }

        public double[] getReturnValues() throws Exception {
            if (this.problem != null) {
                throw this.problem;
            }
            return this.returnValues;
        }

        @Override
        public void run() {
            try {
                this.returnValues = this.miCalc.partialComputeFromObservations(this.myStartTimePoint, this.numberOfTimePoints, this.computeLocals);
            }
            catch (Exception exception) {
                this.problem = exception;
                return;
            }
        }
    }
}

