/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.MultiInfoCalculatorKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.NeighbourNodeData;
import java.util.Calendar;
import java.util.PriorityQueue;

public class MultiInfoCalculatorKraskov1
extends MultiInfoCalculatorKraskov {
    public MultiInfoCalculatorKraskov1() {
        this.isAlgorithm1 = true;
    }

    @Override
    protected double[] partialComputeFromObservations(int n, int n2, boolean bl) throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray = null;
        if (bl) {
            dArray = new double[n2];
        }
        double d2 = (double)(this.dimensions - 1) * this.digammaN;
        double d3 = 0.0;
        double[] dArray2 = new double[this.dimensions];
        for (int i = n; i < n + n2; ++i) {
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            NeighbourNodeData neighbourNodeData = priorityQueue.poll();
            int[] nArray = new int[this.dimensions];
            double d4 = 0.0;
            for (int j = 0; j < this.dimensions; ++j) {
                nArray[j] = this.rangeSearchersInMarginals[j].countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime);
                int n3 = j;
                dArray2[n3] = dArray2[n3] + (double)nArray[j];
                d4 += MathsUtils.digamma(nArray[j] + 1);
            }
            d3 += d4;
            if (!bl) continue;
            dArray[i - n] = this.digammaK - d4 + d2;
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        if (bl) {
            return dArray;
        }
        double[] dArray3 = new double[this.dimensions + 1];
        dArray3[0] = d3;
        System.arraycopy(dArray2, 0, dArray3, 1, this.dimensions);
        return dArray3;
    }
}

