/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.mixed;

import infodynamics.measures.mixed.ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSource;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public abstract class ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceCommon
implements ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSource {
    protected double[][] continuousDataX;
    protected double[][] conditionedDataZ;
    protected int[] discreteData;
    protected int[] counts;
    protected int base;
    protected int dimensionsContinuous;
    protected int dimensionsConditional;
    protected double[] meansX;
    protected double[] stdsX;
    protected double[] meansZ;
    protected double[] stdsZ;
    protected boolean debug;
    protected double condMi;
    protected boolean miComputed;
    protected int totalObservations;
    public static final String PROP_NORMALISE = "NORMALISE";
    protected boolean normalise = true;

    @Override
    public void initialise(int n, int n2, int n3) {
        this.condMi = 0.0;
        this.miComputed = false;
        this.continuousDataX = null;
        this.discreteData = null;
        this.base = n2;
        this.dimensionsContinuous = n;
        this.dimensionsConditional = n3;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase(PROP_NORMALISE)) {
            this.normalise = Boolean.parseBoolean(string2);
        }
    }

    @Override
    public void startAddObservations() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.meansX = MatrixUtils.means(this.continuousDataX);
        this.stdsX = MatrixUtils.stdDevs(this.continuousDataX, this.meansX);
        this.meansZ = MatrixUtils.means(this.conditionedDataZ);
        this.stdsZ = MatrixUtils.stdDevs(this.conditionedDataZ, this.meansZ);
        if (this.normalise) {
            this.continuousDataX = MatrixUtils.normaliseIntoNewArray(this.continuousDataX);
            this.conditionedDataZ = MatrixUtils.normaliseIntoNewArray(this.conditionedDataZ);
        }
        this.counts = new int[this.base];
        for (int i = 0; i < this.discreteData.length; ++i) {
            int n = this.discreteData[i];
            this.counts[n] = this.counts[n] + 1;
        }
        this.totalObservations = this.discreteData.length;
    }

    @Override
    public void addObservations(double[][] dArray, int[] nArray, double[][] dArray2) throws Exception {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void setObservations(double[][] dArray, int[] nArray, double[][] dArray2) throws Exception {
        if (dArray.length != nArray.length || dArray.length != dArray2.length) {
            throw new Exception("Time steps for observations2 " + nArray.length + " does not match the length " + "of observations1 " + dArray.length + " and of conditionedObservations " + dArray2.length);
        }
        if (dArray[0].length == 0) {
            throw new Exception("Computing MI with a null set of data");
        }
        if (dArray2[0].length == 0) {
            throw new Exception("Computing MI with a null set of conditioned data");
        }
        this.continuousDataX = dArray;
        this.discreteData = nArray;
        this.conditionedDataZ = dArray2;
        this.finaliseAddObservations();
    }

    @Override
    public synchronized EmpiricalMeasurementDistribution computeSignificance(boolean bl, int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.continuousDataX.length, n);
        return this.computeSignificance(bl, nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(boolean bl, int[][] nArray) throws Exception {
        int n = nArray.length;
        if (!this.miComputed) {
            this.computeAverageLocalOfObservations();
        }
        ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSource conditionalMutualInfoCalculatorMultiVariateWithDiscreteSource = (ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSource)this.clone();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            if (bl) {
                object = MatrixUtils.extractSelectedTimePoints(this.discreteData, nArray[i]);
                conditionalMutualInfoCalculatorMultiVariateWithDiscreteSource.initialise(this.dimensionsContinuous, this.base, this.dimensionsConditional);
                conditionalMutualInfoCalculatorMultiVariateWithDiscreteSource.setObservations(this.continuousDataX, (int[])object, this.conditionedDataZ);
            } else {
                object = MatrixUtils.extractSelectedTimePointsReusingArrays(this.continuousDataX, nArray[i]);
                conditionalMutualInfoCalculatorMultiVariateWithDiscreteSource.initialise(this.dimensionsContinuous, this.base, this.dimensionsConditional);
                conditionalMutualInfoCalculatorMultiVariateWithDiscreteSource.setObservations((double[][])object, this.discreteData, this.conditionedDataZ);
            }
            dArray[i] = conditionalMutualInfoCalculatorMultiVariateWithDiscreteSource.computeAverageLocalOfObservations();
            if (!this.debug) continue;
            System.out.println("New MI was " + dArray[i]);
        }
        return new EmpiricalMeasurementDistribution(dArray, this.condMi);
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.condMi;
    }

    @Override
    public int getNumObservations() {
        return this.totalObservations;
    }
}

