/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.mixed.kernel;

import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;
import infodynamics.measures.mixed.MutualInfoCalculatorMultiVariateWithDiscrete;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Arrays;

public class MutualInfoCalculatorMultiVariateWithDiscreteKernel
implements MutualInfoCalculatorMultiVariateWithDiscrete {
    protected KernelEstimatorMultiVariate mvke = new KernelEstimatorMultiVariate();
    protected KernelEstimatorMultiVariate[] mvkeForEachDiscrete = null;
    protected int base = 0;
    private int totalObservations = 0;
    private boolean debug = false;
    private double[][] contObservations;
    private int[] discObservations;
    private int[] discCounts;
    private double lastAverage;
    private boolean miComputed;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean forceCompareToAll = false;
    public static final String FORCE_KERNEL_COMPARE_TO_ALL = "FORCE_KERNEL_COMPARE_TO_ALL";
    public static final double DEFAULT_EPSILON = 0.25;
    private double epsilon = 0.25;
    private boolean usingSingleKernelWidthValue = true;
    private double[] epsilons = null;
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public MutualInfoCalculatorMultiVariateWithDiscreteKernel() {
        this.mvke.setNormalise(this.normalise);
    }

    @Override
    public void initialise(int n, int n2) {
        if (this.usingSingleKernelWidthValue) {
            this.mvke.initialise(n, this.epsilon);
        } else {
            this.mvke.initialise(this.epsilons);
        }
        this.initialiseCommon(n2);
    }

    public void initialise(int n, int n2, double d) {
        this.epsilon = d;
        this.usingSingleKernelWidthValue = true;
        this.mvke.initialise(n, d);
        this.initialiseCommon(n2);
    }

    public void initialise(int n, double[] dArray) {
        this.epsilons = dArray;
        this.usingSingleKernelWidthValue = false;
        this.mvke.initialise(dArray);
        this.initialiseCommon(n);
    }

    protected void initialiseCommon(int n) {
        this.base = n;
        this.mvkeForEachDiscrete = new KernelEstimatorMultiVariate[n];
        for (int i = 0; i < n; ++i) {
            this.mvkeForEachDiscrete[i] = new KernelEstimatorMultiVariate();
            this.mvkeForEachDiscrete[i].setNormalise(false);
            this.mvkeForEachDiscrete[i].setForceCompareToAll(this.forceCompareToAll);
        }
        this.discCounts = new int[n];
        this.lastAverage = 0.0;
        this.miComputed = false;
    }

    @Override
    public void setObservations(double[][] dArray, int[] nArray) throws Exception {
        if (dArray.length != nArray.length) {
            throw new Exception("Observations are not of the same length");
        }
        this.contObservations = dArray;
        this.mvke.setObservations(dArray);
        this.setDiscreteData(dArray, nArray);
        this.totalObservations = dArray.length;
    }

    protected void setDiscreteData(double[][] dArray, int[] nArray) {
        int n;
        Arrays.fill(this.discCounts, 0);
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            this.discCounts[n2] = this.discCounts[n2] + 1;
        }
        for (n = 0; n < this.base; ++n) {
            double[][] dArray2 = MatrixUtils.extractSelectedPointsMatchingCondition(dArray, nArray, n, this.discCounts[n]);
            this.mvkeForEachDiscrete[n].initialise(this.mvke.getKernelWidthsInUse());
            this.mvkeForEachDiscrete[n].setObservations(dArray2);
        }
        this.discObservations = nArray;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvke.getProbability(this.contObservations[i]);
            double d3 = this.mvkeForEachDiscrete[this.discObservations[i]].getProbability(this.contObservations[i]);
            double d4 = 0.0;
            double d5 = 0.0;
            if (d3 > 0.0) {
                d4 = d3 / d2;
                d5 = Math.log(d4);
            }
            d += d5;
            if (!this.debug) continue;
            System.out.printf("%d: %.3f, %d, (%.3f %d, %.5f %d) %.5f -> %.5f -> %.5f\n", i, this.contObservations[i][0], this.discObservations[i], d3, this.mvkeForEachDiscrete[this.discObservations[i]].getCount(this.contObservations[i]), d2, this.mvke.getCount(this.contObservations[i]), d4, d5, d);
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        this.miComputed = true;
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservations(int[] nArray) throws Exception {
        double d = this.lastAverage;
        int[] nArray2 = this.discObservations;
        int[] nArray3 = MatrixUtils.extractSelectedTimePoints(nArray2, nArray);
        this.setDiscreteData(this.contObservations, nArray3);
        double d2 = this.computeAverageLocalOfObservations();
        this.lastAverage = d;
        this.setDiscreteData(this.contObservations, nArray2);
        return d2;
    }

    @Override
    public synchronized EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.contObservations.length, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        if (!this.miComputed) {
            this.computeAverageLocalOfObservations();
        }
        double d = this.lastAverage;
        int[] nArray2 = this.discObservations;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2;
            int[] nArray3 = MatrixUtils.extractSelectedTimePoints(nArray2, nArray[i]);
            this.setDiscreteData(this.contObservations, nArray3);
            empiricalMeasurementDistribution.distribution[i] = d2 = this.computeAverageLocalOfObservations();
            if (this.debug) {
                System.out.println("New MI was " + d2);
            }
            if (!(d2 >= d)) continue;
            ++n2;
        }
        this.lastAverage = d;
        this.setDiscreteData(this.contObservations, nArray2);
        empiricalMeasurementDistribution.pValue = (double)n2 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    public double computeAverageJointEntropy() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeForEachDiscrete[this.discObservations[i]].getProbability(this.contObservations[i]) * (double)this.discCounts[this.discObservations[i]] / (double)this.totalObservations;
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageEntropyOfObservation1() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvke.getProbability(this.contObservations[i]);
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageEntropyOfObservation2() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = (double)this.discCounts[this.discObservations[i]] / (double)this.totalObservations;
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageInfoDistanceOfObservations() {
        throw new RuntimeException("Not implemented yet");
    }

    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(this.contObservations, this.discObservations);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, int[] nArray) {
        double d = 0.0;
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2 = this.mvke.getProbability(dArray[i]);
            double d3 = this.mvkeForEachDiscrete[nArray[i]].getProbability(dArray[i]);
            double d4 = 0.0;
            dArray2[i] = 0.0;
            if (d3 > 0.0) {
                d4 = d3 / d2;
                dArray2[i] = Math.log(d4) / Math.log(2.0);
            }
            d += dArray2[i];
            if (!this.debug) continue;
            System.out.printf("%d: (%.5f, %.5f) %.5f -> %.5f -> %.5f\n", i, d3, d2, d4, dArray2[i], d);
        }
        this.lastAverage = d / (double)this.totalObservations;
        this.miComputed = true;
        return dArray2;
    }

    public double[] computeLocalJointEntropyOfPreviousObservations() throws Exception {
        return this.computeLocalJointEntropyUsingPreviousObservations(this.contObservations, this.discObservations);
    }

    public double[] computeLocalJointEntropyUsingPreviousObservations(double[][] dArray, int[] nArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = this.mvkeForEachDiscrete[nArray[i]].getProbability(dArray[i]) * (double)this.discCounts[nArray[i]] / (double)this.totalObservations;
            dArray2[i] = 0.0;
            if (d > 0.0) {
                dArray2[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray2[i]);
        }
        return dArray2;
    }

    public double[] computeLocalEntropy1OfPreviousObservations() {
        return this.computeLocalEntropyFromPreviousObservations(this.contObservations);
    }

    public double[] computeLocalEntropy2OfPreviousObservations() {
        return this.computeLocalEntropyFromPreviousObservations(this.discObservations);
    }

    public double[] computeLocalEntropyFromPreviousObservations(double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = this.mvke.getProbability(dArray[i]);
            dArray2[i] = 0.0;
            if (d > 0.0) {
                dArray2[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray2[i]);
        }
        return dArray2;
    }

    public double[] computeLocalEntropyFromPreviousObservations(int[] nArray) {
        int n = nArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = (double)this.discCounts[nArray[i]] / (double)this.totalObservations;
            dArray[i] = 0.0;
            if (d > 0.0) {
                dArray[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray[i]);
        }
        return dArray;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public void setProperty(String string, String string2) {
        boolean bl = true;
        if (string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.usingSingleKernelWidthValue = true;
            this.epsilon = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.mvke.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            this.forceCompareToAll = Boolean.parseBoolean(string2);
            this.mvke.setForceCompareToAll(this.forceCompareToAll);
            for (int i = 0; i < this.base; ++i) {
                this.mvkeForEachDiscrete[i].setForceCompareToAll(this.forceCompareToAll);
            }
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public int getNumObservations() {
        return this.totalObservations;
    }

    public double[] getKernelWidthsInUse() {
        return Arrays.copyOf(this.mvke.getKernelWidthsInUse(), this.mvke.getKernelWidthsInUse().length);
    }
}

