/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.KdTree;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.NeighbourNodeData;
import infodynamics.utils.UnivariateNearestNeighbourSearcher;
import java.util.Collection;
import java.util.PriorityQueue;

public abstract class NearestNeighbourSearcher {
    protected int normTypeToUse = 2;

    public static NearestNeighbourSearcher create(double[][] dArray) throws Exception {
        if (dArray == null || dArray[0].length == 0) {
            return null;
        }
        if (dArray[0].length == 1) {
            return new UnivariateNearestNeighbourSearcher(MatrixUtils.selectColumn(dArray, 0));
        }
        return new KdTree(dArray);
    }

    public static NearestNeighbourSearcher create(int[] nArray, double[][][] dArray) throws Exception {
        if (nArray.length == 1 && nArray[0] == 1) {
            return new UnivariateNearestNeighbourSearcher(MatrixUtils.selectColumn(dArray[0], 0));
        }
        return new KdTree(nArray, dArray);
    }

    public void setNormType(int n) {
        if (n != 0 && n != 3 && n != 2) {
            throw new UnsupportedOperationException("Norm type " + n + " is not supported in KdTree");
        }
        if (n == 0) {
            n = 3;
        }
        this.normTypeToUse = n;
    }

    public void setNormType(String string) {
        this.normTypeToUse = NearestNeighbourSearcher.validateNormType(string);
    }

    public int getNormType() {
        return this.normTypeToUse;
    }

    public String getNormTypeAsString() {
        return NearestNeighbourSearcher.convertNormTypeToString(this.normTypeToUse);
    }

    public static int validateNormType(String string) {
        if (string.equalsIgnoreCase("EUCLIDEAN")) {
            string = "EUCLIDEAN_SQUARED";
        }
        if (string.equalsIgnoreCase("EUCLIDEAN_SQUARED")) {
            return 3;
        }
        if (string.equalsIgnoreCase("MAX_NORM")) {
            return 2;
        }
        throw new UnsupportedOperationException("Norm type " + string + " is not supported in NearestNeighbourSearcher");
    }

    public static String convertNormTypeToString(int n) {
        if (n == 3) {
            return "EUCLIDEAN_SQUARED";
        }
        if (n == 0) {
            return "EUCLIDEAN";
        }
        if (n == 2) {
            return "MAX_NORM";
        }
        throw new Error("normTypeToUse set to an invalid value: " + n);
    }

    public abstract NeighbourNodeData findNearestNeighbour(int var1);

    public abstract PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int var1, int var2) throws Exception;

    public abstract PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int var1, int var2, int var3) throws Exception;

    public abstract int countPointsWithinR(int var1, double var2, boolean var4);

    public abstract int countPointsWithinR(int var1, double var2, int var4, boolean var5);

    public abstract int countPointsWithinR(double[][] var1, double var2, boolean var4);

    public abstract Collection<NeighbourNodeData> findPointsWithinR(int var1, double var2, boolean var4);

    public abstract void findPointsWithinR(int var1, double var2, boolean var4, boolean[] var5, int[] var6);

    public abstract void findPointsWithinR(int var1, double var2, int var4, boolean var5, boolean[] var6, int[] var7);

    public abstract int findPointsWithinR(int var1, double var2, int var4, boolean var5, boolean[] var6, double[] var7, double[][] var8);

    public abstract void findPointsWithinR(double var1, double[][] var3, boolean var4, boolean[] var5, int[] var6);

    public int countPointsStrictlyWithinR(int n, double d, int n2) {
        return this.countPointsWithinR(n, d, n2, false);
    }

    public int countPointsStrictlyWithinR(int n, double d) {
        return this.countPointsWithinR(n, d, false);
    }

    public Collection<NeighbourNodeData> findPointsStrictlyWithinR(int n, double d) {
        return this.findPointsWithinR(n, d, false);
    }

    public void findPointsStrictlyWithinR(int n, double d, boolean[] blArray, int[] nArray) {
        this.findPointsWithinR(n, d, false, blArray, nArray);
    }

    public int countPointsWithinOrOnR(int n, double d) {
        return this.countPointsWithinR(n, d, true);
    }

    public int countPointsWithinOrOnR(int n, double d, int n2) {
        return this.countPointsWithinR(n, d, n2, true);
    }

    public Collection<NeighbourNodeData> findPointsWithinOrOnR(int n, double d) {
        return this.findPointsWithinR(n, d, true);
    }

    public void findPointsWithinOrOnR(int n, double d, boolean[] blArray, int[] nArray) {
        this.findPointsWithinR(n, d, true, blArray, nArray);
    }

    public abstract int countPointsWithinR(int var1, double var2, boolean var4, boolean[] var5);

    public abstract int countPointsWithinR(int var1, double var2, boolean var4, boolean[] var5, int[] var6);

    public abstract int countPointsWithinR(double[][] var1, double var2, boolean var4, boolean[] var5);
}

