/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class RandomGenerator {
    Random random = new Random();

    public void setSeed(long l) {
        this.random.setSeed(l);
    }

    public double[] generateRandomData(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.random.nextDouble();
        }
        return dArray;
    }

    public double[] generateRandomData(int n, double d, double d2) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + this.random.nextDouble() * (d2 - d);
        }
        return dArray;
    }

    public double[][] generateRandomData(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.random.nextDouble();
            }
        }
        return dArray;
    }

    public int[] generateDistinctRandomInts(int n, int n2) {
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n; ++i) {
            int n3 = this.random.nextInt(n2);
            while (blArray[n3]) {
                n3 = this.random.nextInt(n2);
            }
            nArray[i] = n3;
            blArray[n3] = true;
        }
        return nArray;
    }

    public double[] generateNormalData(int n, double d, double d2) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.random.nextGaussian() * d2 + d;
        }
        return dArray;
    }

    public double[][] generateNormalData(int n, int n2, double d, double d2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.random.nextGaussian() * d2 + d;
            }
        }
        return dArray;
    }

    public double[][] generateBivariateNormalData(int n, double d, double d2, double d3, double d4, double d5) {
        double[][] dArray = new double[n][2];
        double d6 = d5 / d2;
        double d7 = Math.sqrt(d4 * d4 - d6 * d6);
        for (int i = 0; i < n; ++i) {
            double d8 = this.random.nextGaussian();
            double d9 = this.random.nextGaussian();
            dArray[i][0] = d + d2 * d8;
            dArray[i][1] = d3 + d6 * d8 + d7 * d9;
        }
        return dArray;
    }

    public double[][] generateCovariantGaussians(int n, int n2, double[] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = this.generateNormalData(n2, 0.0, 1.0);
            for (int j = 0; j < n2; ++j) {
                dArray3[i][j] = dArray[j];
                for (int k = 0; k < n2; ++k) {
                    double[] dArray5 = dArray3[i];
                    int n3 = j;
                    dArray5[n3] = dArray5[n3] + dArray2[j][k] * dArray4[k];
                }
            }
        }
        return dArray3;
    }

    public int[] generateRandomInts(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.random.nextInt(n2);
        }
        return nArray;
    }

    public int[][] generateRandomInts(int n, int n2, int n3) {
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[i][j] = this.random.nextInt(n3);
            }
        }
        return nArray;
    }

    public int[][] generateDistinctRandomSets(int n, int n2, int n3) {
        int n4 = 0;
        try {
            n4 = MathsUtils.numOfSets(n, n2);
            if (n3 > n4) {
                n3 = n4;
                return this.generateAllDistinctSets(n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[][] nArray = new int[n3][n2];
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            vector.add(new Integer(i));
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        Hashtable<Vector<Integer>, Integer> hashtable = new Hashtable<Vector<Integer>, Integer>();
        for (int i = 0; i < n3; ++i) {
            do {
                int n5;
                vector.addAll(vector2);
                vector2.clear();
                for (n5 = 0; n5 < n2; ++n5) {
                    int n6 = this.random.nextInt(n - n5);
                    Integer n7 = (Integer)vector.remove(n6);
                    nArray[i][n5] = n7;
                }
                Arrays.sort(nArray[i]);
                for (n5 = 0; n5 < n2; ++n5) {
                    vector2.add(new Integer(nArray[i][n5]));
                }
            } while (hashtable.get(vector2) != null);
            hashtable.put(vector2, new Integer(0));
        }
        return nArray;
    }

    public int[][] generateNRandomSets(int n, int n2, int n3) {
        int[][] nArray = this.generateDistinctRandomSets(n, n2, n3);
        if (nArray.length == n3) {
            return nArray;
        }
        if (nArray.length > n3) {
            throw new RuntimeException("generateDistinctRandomSets generated more than " + n3 + " distinct sets when asked for " + n3 + "; note n=" + n + " p=" + n2);
        }
        int[][] nArrayArray = new int[n3][];
        for (int i = 0; i < n3; ++i) {
            nArrayArray[i] = nArray[this.random.nextInt(nArray.length)];
        }
        return nArrayArray;
    }

    private int[][] generateDistinctRandomSets(int n, int n2, int n3, int[][] nArray) {
        throw new RuntimeException("Not implemented yet");
    }

    public int[][] generateNRandomSetsNoOverlap(int n, int n2, int n3, int[][] nArray) {
        int[][] nArray2 = this.generateDistinctRandomSets(n, n2, n3, nArray);
        if (nArray2.length == n3) {
            return nArray2;
        }
        if (nArray2.length > n3) {
            throw new RuntimeException("generateDistinctRandomSets generated more than " + n3 + " distinct sets when asked for " + n3 + "; note n=" + n + " p=" + n2);
        }
        int[][] nArrayArray = new int[n3][];
        for (int i = 0; i < n3; ++i) {
            nArrayArray[i] = nArray2[this.random.nextInt(nArray2.length)];
        }
        return nArrayArray;
    }

    public int[][] generateAllDistinctSets(int n, int n2) throws Exception {
        int n3;
        try {
            n3 = MathsUtils.numOfSets(n, n2);
        }
        catch (Exception exception) {
            throw new Exception("nCp too large");
        }
        int[][] nArray = new int[n3][n2];
        int[] nArray2 = new int[n2];
        this.addToDistinctSets(nArray, n, n2, 0, nArray2, 0, 0);
        return nArray;
    }

    protected int addToDistinctSets(int[][] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5) {
        if (n4 == n2) {
            System.arraycopy(nArray2, 0, nArray[n3], 0, n2);
            ++n3;
        } else {
            for (int i = n5; i < n; ++i) {
                nArray2[n4] = i;
                n3 = this.addToDistinctSets(nArray, n, n2, n3, nArray2, n4 + 1, i + 1);
            }
        }
        return n3;
    }

    public int[][] generateDistinctRandomPerturbations(int n, int n2) {
        int n3 = 0;
        try {
            n3 = MathsUtils.factorialCheckBounds(n);
            if (n2 > n3) {
                n2 = n3;
                return this.generateAllDistinctPerturbations(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[][] nArray = new int[n2][n];
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            vector.add(new Integer(i));
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        Hashtable<Vector<Integer>, Integer> hashtable = new Hashtable<Vector<Integer>, Integer>();
        for (int i = 0; i < n2; ++i) {
            do {
                int n4;
                vector.addAll(vector2);
                vector2.clear();
                for (n4 = 0; n4 < n; ++n4) {
                    int n5 = this.random.nextInt(n - n4);
                    Integer n6 = (Integer)vector.remove(n5);
                    nArray[i][n4] = n6;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    vector2.add(new Integer(nArray[i][n4]));
                }
            } while (hashtable.get(vector2) != null);
            hashtable.put(vector2, new Integer(0));
        }
        return nArray;
    }

    public int[][] generateAllDistinctPerturbations(int n) throws Exception {
        int n2;
        try {
            n2 = MathsUtils.factorialCheckBounds(n);
        }
        catch (Exception exception) {
            throw new Exception("n! too large");
        }
        int[][] nArray = new int[n2][n];
        int[] nArray2 = new int[n];
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            vector.add(new Integer(i));
        }
        this.addToDistinctPerturbations(nArray, n, 0, nArray2, 0, vector);
        return nArray;
    }

    protected int addToDistinctPerturbations(int[][] nArray, int n, int n2, int[] nArray2, int n3, Vector<Integer> vector) {
        if (n3 == n) {
            System.arraycopy(nArray2, 0, nArray[n2], 0, n);
            ++n2;
        } else {
            Vector vector2 = (Vector)vector.clone();
            for (Integer n4 : vector2) {
                int n5;
                nArray2[n3] = n5 = n4.intValue();
                vector.remove(n4);
                n2 = this.addToDistinctPerturbations(nArray, n, n2, nArray2, n3 + 1, vector);
                vector.add(n4);
            }
        }
        return n2;
    }

    public int[][] generateRandomPerturbations(int n, int n2) {
        int n3;
        int[][] nArray = new int[n2][n];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n; ++n3) {
            arrayList.add(n3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            Collections.shuffle(arrayList, this.random);
            for (int i = 0; i < n; ++i) {
                nArray[n3][i] = (Integer)arrayList.get(i);
            }
        }
        return nArray;
    }

    public static void main(String[] stringArray) throws Exception {
        Hashtable<int[], Integer> hashtable = new Hashtable<int[], Integer>();
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        int[] nArray2 = new int[]{1, 2, 3, 4, 5};
        int[] nArray3 = new int[]{1, 2, 3, 5, 5};
        hashtable.put(nArray, 0);
        hashtable.put(nArray3, 1);
        System.out.println(hashtable.get(nArray));
        System.out.println(hashtable.get(nArray2));
        System.out.println(hashtable.get(nArray3));
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(new Integer(nArray[i]));
            vector2.add(new Integer(nArray2[i]));
            vector3.add(new Integer(nArray3[i]));
        }
        Hashtable<Vector<Integer>, Integer> hashtable2 = new Hashtable<Vector<Integer>, Integer>();
        hashtable2.put(vector, 1);
        hashtable2.put(vector3, 3);
        System.out.println(hashtable2.get(vector));
        System.out.println(hashtable2.get(vector2));
        System.out.println(hashtable2.get(vector3));
        RandomGenerator randomGenerator = new RandomGenerator();
        MatrixUtils.printMatrix(System.out, randomGenerator.generateAllDistinctSets(5, 3));
        System.out.println("Generating all distinct perturbations of 5:");
        MatrixUtils.printMatrix(System.out, randomGenerator.generateAllDistinctPerturbations(5));
        System.out.println("Generating 10 distinct perturbations of 4:");
        MatrixUtils.printMatrix(System.out, randomGenerator.generateDistinctRandomPerturbations(4, 10));
    }

    public RandomPairs generateDistinctPairsOfRandomSets(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        RandomPairs randomPairs = new RandomPairs(n, n2, n3, n4, n5);
        try {
            n7 = MathsUtils.numOfSets(n, n3);
        }
        catch (Exception exception) {
            n7 = Integer.MAX_VALUE;
        }
        try {
            n6 = MathsUtils.numOfSets(n2, n4);
        }
        catch (Exception exception) {
            n6 = Integer.MAX_VALUE;
        }
        int[][] nArray = this.generateDistinctRandomSets(n, n3, n5);
        int[][] nArray2 = this.generateDistinctRandomSets(n2, n4, n5);
        if (n7 < n5 || n6 < n5) {
            long l = n7 * n6;
            if (l < (long)n5) {
                randomPairs.sets1 = new int[(int)l][];
                randomPairs.sets2 = new int[(int)l][];
                int n8 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < nArray2.length; ++j) {
                        randomPairs.sets1[n8] = nArray[i];
                        randomPairs.sets2[n8] = nArray2[j];
                        ++n8;
                    }
                }
            } else {
                randomPairs.sets1 = new int[n5][];
                randomPairs.sets2 = new int[n5][];
                HashSet hashSet = new HashSet();
                for (int i = 0; i < n5; ++i) {
                    int n9;
                    int n10;
                    Vector<Integer> vector;
                    do {
                        vector = new Vector<Integer>();
                        n10 = this.random.nextInt(nArray.length);
                        n9 = this.random.nextInt(nArray2.length);
                        vector.clear();
                        vector.add(n10);
                        vector.add(n9);
                    } while (hashSet.contains(vector));
                    randomPairs.sets1[i] = nArray[n10];
                    randomPairs.sets2[i] = nArray2[n9];
                    hashSet.add(vector);
                }
            }
        } else {
            randomPairs.sets1 = nArray;
            randomPairs.sets2 = nArray2;
        }
        return randomPairs;
    }

    public class RandomPairs {
        public int n1;
        public int n2;
        public int p1;
        public int p2;
        public int N;
        public int[][] sets1;
        public int[][] sets2;

        public RandomPairs(int n, int n2, int n3, int n4, int n5) {
            this.n1 = n;
            this.n2 = n2;
            this.p1 = n3;
            this.p2 = n4;
            this.N = n5;
            this.sets1 = null;
            this.sets2 = null;
        }
    }
}

