/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.distribution;

import infodynamics.utils.commonsmath3.distribution.AbstractRealDistribution;
import infodynamics.utils.commonsmath3.exception.NotStrictlyPositiveException;
import infodynamics.utils.commonsmath3.exception.OutOfRangeException;
import infodynamics.utils.commonsmath3.exception.util.Localizable;
import infodynamics.utils.commonsmath3.exception.util.LocalizedFormats;
import infodynamics.utils.commonsmath3.random.RandomGenerator;
import infodynamics.utils.commonsmath3.random.Well19937c;
import infodynamics.utils.commonsmath3.util.CombinatoricsUtils;
import infodynamics.utils.commonsmath3.util.FastMath;
import infodynamics.utils.commonsmath3.util.ResizableDoubleArray;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private static final double[] EXPONENTIAL_SA_QI;
    private final double mean;
    private final double logMean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistribution(double d) {
        this(d, 1.0E-9);
    }

    public ExponentialDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d) throws NotStrictlyPositiveException {
        this(randomGenerator, d, 1.0E-9);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d, double d2) throws NotStrictlyPositiveException {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d);
        }
        this.mean = d;
        this.logMean = FastMath.log(d);
        this.solverAbsoluteAccuracy = d2;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double density(double d) {
        double d2 = this.logDensity(d);
        return d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
    }

    @Override
    public double logDensity(double d) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -d / this.mean - this.logMean;
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = d <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-d / this.mean);
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws OutOfRangeException {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0.0, 1.0);
        }
        double d2 = d == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - d);
        return d2;
    }

    @Override
    public double sample() {
        double d;
        double d2;
        double d3 = 0.0;
        for (d2 = this.random.nextDouble(); d2 < 0.5; d2 *= 2.0) {
            d3 += EXPONENTIAL_SA_QI[0];
        }
        if ((d2 += d2 - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return this.mean * (d3 + d2);
        }
        int n = 0;
        double d4 = d = this.random.nextDouble();
        do {
            ++n;
            d = this.random.nextDouble();
            if (!(d < d4)) continue;
            d4 = d;
        } while (d2 > EXPONENTIAL_SA_QI[n]);
        return this.mean * (d3 + d4 * EXPONENTIAL_SA_QI[0]);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        double d = this.getMean();
        return d * d;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    static {
        double d = FastMath.log(2.0);
        double d2 = 0.0;
        int n = 1;
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray(20);
        while (d2 < 1.0) {
            resizableDoubleArray.addElement(d2 += FastMath.pow(d, n) / (double)CombinatoricsUtils.factorial(n));
            ++n;
        }
        EXPONENTIAL_SA_QI = resizableDoubleArray.getElements();
    }
}

