/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.random;

import infodynamics.utils.commonsmath3.exception.NotStrictlyPositiveException;
import infodynamics.utils.commonsmath3.random.RandomGenerator;
import java.util.Random;

public class RandomGeneratorFactory {
    private RandomGeneratorFactory() {
    }

    public static RandomGenerator createRandomGenerator(final Random random) {
        return new RandomGenerator(){

            @Override
            public void setSeed(int n) {
                random.setSeed(n);
            }

            @Override
            public void setSeed(int[] nArray) {
                random.setSeed(RandomGeneratorFactory.convertToLong(nArray));
            }

            @Override
            public void setSeed(long l) {
                random.setSeed(l);
            }

            @Override
            public void nextBytes(byte[] byArray) {
                random.nextBytes(byArray);
            }

            @Override
            public int nextInt() {
                return random.nextInt();
            }

            @Override
            public int nextInt(int n) {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException(n);
                }
                return random.nextInt(n);
            }

            @Override
            public long nextLong() {
                return random.nextLong();
            }

            @Override
            public boolean nextBoolean() {
                return random.nextBoolean();
            }

            @Override
            public float nextFloat() {
                return random.nextFloat();
            }

            @Override
            public double nextDouble() {
                return random.nextDouble();
            }

            @Override
            public double nextGaussian() {
                return random.nextGaussian();
            }
        };
    }

    public static long convertToLong(int[] nArray) {
        long l = 0L;
        for (int n : nArray) {
            l = l * 0xFFFFFFFBL + (long)n;
        }
        return l;
    }
}

