---
name: moai-domain-frontend
version: 2.1.0
created: 2025-10-22
updated: 2025-11-02
status: active
description: React 19/Vue 3.5/Angular 19 with state management, performance optimization, accessibility, and meta-frameworks (Nuxt, SvelteKit, Astro, SolidJS).
keywords: ['react', 'vue', 'angular', 'state', 'accessibility', 'nuxt', 'sveltekit', 'astro', 'solidjs']
allowed-tools:
  - Read
  - Bash
---

# Domain Frontend Skill

## Skill Metadata

| Field | Value |
| ----- | ----- |
| **Skill Name** | moai-domain-frontend |
| **Version** | 2.1.0 (2025-11-02) |
| **Allowed tools** | Read (read_file), Bash (terminal) |
| **Auto-load** | On demand when keywords detected |
| **Tier** | Domain |

---

## What It Does

React 19/Vue 3.5/Angular 19 with state management, performance optimization, accessibility, and meta-frameworks (Nuxt, SvelteKit, Astro, SolidJS).

**Key capabilities**:
- ✅ Best practices enforcement for frontend domain
- ✅ TRUST 5 principles integration
- ✅ Latest tool versions (2025-11-02)
- ✅ TDD workflow support
- ✅ Meta-framework patterns (Nuxt, SvelteKit, Astro)

---

## When to Use

**Automatic triggers**:
- Related code discussions and file patterns
- SPEC implementation (`/alfred:2-run`)
- Code review requests

**Manual invocation**:
- Review code for TRUST 5 compliance
- Design new features
- Troubleshoot issues

---

## Tool Version Matrix (2025-11-02)

| Tool | Version | Purpose | Status |
|------|---------|---------|--------|
| **React** | 19.0.0 | UI Library | ✅ Current |
| **Vue** | 3.5.13 | UI Framework | ✅ Current |
| **Angular** | 19.0.0 | UI Framework | ✅ Current |
| **Svelte** | 4.2+ | UI Framework | ✅ Current |
| **SolidJS** | 1.2.0 | UI Library | ✅ Current |
| **Vite** | 6.0.5 | Build tool | ✅ Current |
| **Astro** | 5.15.3 | Static site gen | ✅ Current |

---

## Inputs

- Language-specific source directories
- Configuration files
- Test suites and sample data

## Outputs

- Test/lint execution plan
- TRUST 5 review checkpoints
- Migration guidance

## Failure Modes

- When required tools are not installed
- When dependencies are missing
- When test coverage falls below 85%

## Dependencies

- Access to project files via Read/Bash tools
- Integration with `moai-foundation-langs` for language detection
- Integration with `moai-foundation-trust` for quality gates

---

## References (Latest Documentation)

_Documentation links updated 2025-10-22_

---

## Changelog

- **v2.0.0** (2025-10-22): Major update with latest tool versions, comprehensive best practices, TRUST 5 integration
- **v1.0.0** (2025-03-29): Initial Skill release

---

## Works Well With

- `moai-foundation-trust` (quality gates)
- `moai-alfred-code-reviewer` (code review)
- `moai-essentials-debug` (debugging support)

---

## Best Practices

✅ **DO**:
- Follow domain best practices
- Use latest stable tool versions
- Maintain test coverage ≥85%
- Document all public APIs

❌ **DON'T**:
- Skip quality gates
- Use deprecated tools
- Ignore security warnings
- Mix testing frameworks
